function [Err,dof,res]= DPG2D(Pr)

% Checks ------------------------------------------------------------------

if Pr.MType==5
    if (Pr.nelx==2 || Pr.nelx==4 || Pr.nelx==8 || Pr.nelx==16)
    else
        disp('Number of elements for polygonal mesh can only be 2,4,8,16');
        Err=-1;dof=-1;res=-1; return
    end
end
if (Pr.MType==3 && Pr.RefT==2)
    disp('Adaptive refinements with triangular mesh is not supported yet');
    Err=-1;dof=-1;res=-1; return
end
if (Pr.P +Pr.dP > 21)
    disp('Pr.P +Pr.dP should be less than 21');
    Err=-1;dof=-1;res=-1; return
end
% poolobj = gcp('nocreate'); 
% if isempty(poolobj);
%    disp('Parallel Pool is not running');
%    Err=-1;dof=-1;res=-1; return
% else
%     pln=poolobj.NumWorkers;
% end
% ------------------------------------------------------------------
[Pr]=preprocessor(Pr);
if (Pr.RefT==1 || Pr.nRef==0)
    [Pr,ue]= boundary(Pr);
    [Pr,Ke,fe,Ge,Be,Bhe,fee]= assembly(Pr,ue); clear ue;
    [Pr,ue]= solver(Pr);
    [Pr]=residual(Pr,Ke,fe,ue,Ge,Be,Bhe,fee);  clear Ge Be Bhe fee;
    if Pr.Stype>0; [Pr]=errorcalc(Pr,Ke,fe,ue);  else  Pr.Err=0; end
    disp('Err, Resid'); disp([Pr.Err, sqrt(sum(Pr.res))]);
    if ((Pr.Ptrial==1 || Pr.Ptrace==1) && Pr.indx==Pr.nRef+1); [Pr]=postprocessor(Pr,Ke,fe,ue); end
    if (Pr.Pmesh==1 && Pr.indx==Pr.nRef+1); plotmeshPl(Pr); end
    clear Ke fe ue;
    Err=Pr.Err; dof=max(max(Pr.dof))-length(Pr.dofDBC)-length(Pr.dofNBC);  res= sqrt(sum(Pr.res));
elseif (Pr.RefT==2 && Pr.nRef>0)
    Err=zeros(1,Pr.nRef); dof=Err; res=Err;
    for i=1:Pr.nRef+1
        if (Pr.Pmesh==1); plotmeshPl(Pr); pause(.01); end
        [Pr,ue]= boundary(Pr);
        [Pr,Ke,fe,Ge,Be,Bhe,fee]= assembly(Pr,ue); clear ue;
        [Pr,ue]= solver(Pr);
        if Pr.nRef>0;[Pr]=residual(Pr,Ke,fe,ue,Ge,Be,Bhe,fee); else Pr.res=0; end
        clear Ge Be Bhe fee;
        if Pr.Stype>0; [Pr]=errorcalc(Pr,Ke,fe,ue);  else  Pr.Err=0; end
        disp('   Re. Err | Rel. Residual'); disp([Pr.Err, sqrt(sum(Pr.res))]);
        Err(i)=Pr.Err; dof(i)=max(max(Pr.dof))-length(Pr.dofDBC)-length(Pr.dofNBC);  res(i)= sqrt(sum(Pr.res));
        if (i~=Pr.nRef+1 && (Pr.Ptrial==1 || Pr.Ptrace==1)); clear Ke fe ue; end
        if (Pr.nRef>0 && i<Pr.nRef+1); close all;  [Pr]=refine(Pr); end 
    end
    if (Pr.Ptrial==1 || Pr.Ptrace==1); postprocessor(Pr,Ke,fe,ue); end
    
    clear Ke fe ue;
end