function [F,U,GradU,Grad2U]=Exact(xc,type,Length,Height)

x=xc(1); y=xc(2);

if type==1
    
    nx=Length; ny=Height;
    
    U=sin((pi*x)/nx)*sin((pi*y)/ny);                          %   u
    GradU(1)=(pi*cos((pi*x)/nx)*sin((pi*y)/ny))/nx;           %   u,x
    GradU(2)=(pi*cos((pi*y)/ny)*sin((pi*x)/nx))/ny;           %   u,y
    Grad2U(1,1)=-(pi^2*sin((pi*x)/nx)*sin((pi*y)/ny))/nx^2;   %   u,xx
    Grad2U(1,2)=(pi^2*cos((pi*x)/nx)*cos((pi*y)/ny))/(nx*ny); %   u,xy
    Grad2U(2,1)=(pi^2*cos((pi*x)/nx)*cos((pi*y)/ny))/(nx*ny); %   u,yx
    Grad2U(2,2)=-(pi^2*sin((pi*x)/nx)*sin((pi*y)/ny))/ny^2;   %   u,yy
    
elseif type==2
    
    mx=0.75; my=0.75; sx=sqrt(.01); sy=sqrt(.01);
    
    U= (exp(-(mx - x)^2/(2*sx^2))*exp(-(my - y)^2/(2*sy^2)))/(2*sx*sy*pi);
    GradU(1)=(exp(-(mx - x)^2/(2*sx^2))*exp(-(my - y)^2/(2*sy^2))*(2*mx - 2*x))/(4*sx^3*sy*pi);
    GradU(2)=(exp(-(mx - x)^2/(2*sx^2))*exp(-(my - y)^2/(2*sy^2))*(2*my - 2*y))/(4*sx*sy^3*pi);
    Grad2U(1,1)=-(exp(- (mx - x)^2/(2*sx^2) - (my - y)^2/(2*sy^2))*(- mx^2 + 2*mx*x + sx^2 - x^2))/(2*sx^5*sy*pi);
    Grad2U(1,2)= (exp(-(mx - x)^2/(2*sx^2))*exp(-(my - y)^2/(2*sy^2))*(2*mx - 2*x)*(2*my - 2*y))/(8*sx^3*sy^3*pi);
    Grad2U(2,1)= (exp(-(mx - x)^2/(2*sx^2))*exp(-(my - y)^2/(2*sy^2))*(2*mx - 2*x)*(2*my - 2*y))/(8*sx^3*sy^3*pi);
    Grad2U(2,2)=-(exp(- (mx - x)^2/(2*sx^2) - (my - y)^2/(2*sy^2))*(- my^2 + 2*my*y + sy^2 - y^2))/(2*sx*sy^5*pi);
    
end

F=-(Grad2U(1,1)+Grad2U(2,2));