

#include "fintrf.h"

C     Gateway routine
      subroutine mexFunction(nlhs, plhs, nrhs, prhs)

C     Declarations
      implicit none

c----------------------------------------------------------------------
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c----------------------------------------------------------------------
C--------    PRINT      -------------------------------------------------
C          open(12, file='val.txt',status='replace',form='formatted'
C     .                                        ,access='sequential')
C          write(12,*) int(Norder(1))
C          close(12)
C-----------------------------------------------------------------------

c  ...maximum order of approximation
      integer, parameter :: MAXP=19

c  ...increment in order to define the enriched spaces
      integer, parameter :: MAXNORD_ADD=1

c----------------------------------------------------------------------
c      === ELEMENT ====
c       ...max number of local dof for a 2D quad element
      integer, parameter :: MAXquadH = (MAXP+1)**2
      integer, parameter :: MAXquadE = 2*MAXP*(MAXP+1)
      integer, parameter :: MAXquadV = MAXquadE
      integer, parameter :: MAXquadQ = MAXP**2
c       ...max number of local dof for a 2D triangular element
      integer, parameter :: MAXtriaH = (MAXP+1)*(MAXP+2)/2
      integer, parameter :: MAXtriaE = MAXP*(MAXP+2)
      integer, parameter :: MAXtriaV = MAXtriaE
      integer, parameter :: MAXtriaQ = MAXP*(MAXP+1)/2

c----------------------------------------------------------------------
c       ==== NODE ===
c       ...maximum number of dof for 'mdlt'
      integer, parameter :: MAXmdltH=(MAXP-2)*(MAXP-1)/2
      integer, parameter :: MAXmdltE=(MAXP-1)*MAXP
      integer, parameter :: MAXmdltV=MAXmdltE
      integer, parameter :: MAXmdltQ=MAXP*(MAXP+1)/2
c       ...maximum number of dof for 'mdlq'
      integer, parameter :: MAXmdlqH=(MAXP-1)**2
      integer, parameter :: MAXmdlqE=2*MAXP*(MAXP-1)
      integer, parameter :: MAXmdlqV=MAXmdlqE
      integer, parameter :: MAXmdlqQ=MAXP**2

c----------------------------------------------------------------------

c  ...maximum enriched order
      integer, parameter :: MAXPP = MAXP+MAXNORD_ADD
c
c  ...maximum number of quadrature points for an enriched  2D element
      integer, parameter :: MAXNINT2ADD = (MAXPP+1)**2
c
c  ...maximum number of quadrature points for an enriched  3D element
      integer, parameter :: MAXNINT3ADD = (MAXPP+1)**2*(MAXPP+2)
c
c----------------------------------------------------------------------
c  === ELEMENT ====
c  ...max number of local dof for a 2D quad element
      integer, parameter :: MAXquadHH = (MAXPP+1)**2
      integer, parameter :: MAXquadEE = 2*MAXPP*(MAXPP+1)
      integer, parameter :: MAXquadVV = MAXquadEE
      integer, parameter :: MAXquadQQ = MAXPP**2
c
c  ...max number of local dof for a 2D triangular element
      integer, parameter :: MAXtriaHH = (MAXPP+1)*(MAXPP+2)/2
      integer, parameter :: MAXtriaEE = MAXPP*(MAXPP+2)
      integer, parameter :: MAXtriaVV = MAXtriaEE
      integer, parameter :: MAXtriaQQ = MAXPP*(MAXPP+1)/2

c----------------------------------------------------------------------


C     mexFunction arguments:
      mwPointer plhs(*), prhs(*)
      integer nlhs, nrhs

C     Function declarations:
      mwPointer mxGetPr
      mwPointer mxCreateDoubleMatrix


C     Pointers to input/output mxArrays:
      mwPointer flag_ptr,Xi_ptr,Norder_ptr,NoriE_ptr,Num_ptr
      mwPointer ShapH_ptr,GradH_ptr,DivV_ptr,ShapE_ptr
      mwPointer CurlE_ptr,ShapQ_ptr,ShapV_ptr,NoriF_ptr

C     Arguments for computational routine:
      real*8  flag,Num
      integer iNum,n,t,s,f,c,i
      real*8, dimension(:),   allocatable :: Xi,Norder,NoriE,NoriF
      real*8, dimension(:),   allocatable :: ShapH,DivV,ShapQ
      real*8, dimension(:,:), allocatable :: GradH,ShapV,CurlE,ShapE
      character(len=4) type
C-----------------------------------------------------------------------
      

C     Create Fortran array from the input argument.

      flag_ptr = mxGetPr(prhs(1))
      call mxCopyPtrToReal8(flag_ptr,flag,1*1)

c     n (dimension), t (type), s (space), c (continuous)
      f=int(flag)
      do i = 1, 4
        if     (i.eq.1) then
          c=f - (f/10)*10
        elseif (i.eq.2) then
          s=f - (f/10)*10
        elseif (i.eq.3) then
          t=f - (f/10)*10
        elseif (i.eq.4) then
          n=f - (f/10)*10
        endif
        f = f/10
      enddo

      if (n.eq.1) then
C---------------------------------------------  1D
        allocate(Xi(1),Norder(1))
        Xi_ptr = mxGetPr(prhs(2))
        call mxCopyPtrToReal8(Xi_ptr,Xi,1*1)
        Norder_ptr = mxGetPr(prhs(3))
        call mxCopyPtrToReal8(Norder_ptr,Norder,1*1)
      elseif (n.eq.2) then
C---------------------------------------------  2D
        allocate(Xi(2),Norder(5),NoriE(4))
        Xi_ptr = mxGetPr(prhs(2))
        call mxCopyPtrToReal8(Xi_ptr,Xi,1*2)
        if (c.eq.1) then
          Norder_ptr = mxGetPr(prhs(3))
          call mxCopyPtrToReal8(Norder_ptr,Norder,1*5)
          NoriE_ptr = mxGetPr(prhs(4))
          call mxCopyPtrToReal8(NoriE_ptr,NoriE,1*4)
        elseif (c.eq.0) then
          Norder_ptr = mxGetPr(prhs(3))
          call mxCopyPtrToReal8(Norder_ptr,Norder,1*1)
        endif
      endif
C-----------------------------------------------------------------------

C     Call the computational subroutine.
	  
	    if (n.eq.1) then
C---------------------------------------------  1D
	      if (s.eq.0) then
            if (c.eq.1) then
                allocate(ShapH(MAXP+1),GradH(n,MAXP+1))
                call shape1DH(Xi(1),int(Norder(1)), iNum,ShapH,GradH)
            elseif (c.eq.0) then
                allocate(ShapH(MAXPP+1),GradH(n,MAXPP+1))
                call shape1HH(Xi(1),int(Norder(1)), iNum,ShapH,GradH)
            endif
	      elseif (s.eq.3) then
            if (c.eq.1) then
                allocate(ShapQ(MAXP))
                call shape1DQ(Xi(1),int(Norder(1)), iNum,ShapQ)
            elseif (c.eq.0) then
                allocate(ShapQ(MAXPP))
                call shape1QQ(Xi(1),int(Norder(1)), iNum,ShapQ)
            endif
	      endif
	    elseif (n.eq.2) then
C---------------------------------------------  2D
	  	  if (t.eq.4) then
	  	    type='quad'
	  	  elseif (t.eq.3) then
	  	    type='tria'
	  	  endif
        if (s.eq.0) then
          if (c.eq.1) then
            allocate(ShapH(MAXquadH),GradH(n,MAXquadH))
            call shape2DH(type,Xi,int(Norder),int(NoriE),
     .                                    iNum,ShapH,GradH)
          elseif (c.eq.0) then
            allocate(ShapH(MAXquadHH),GradH(n,MAXquadHH))
            call shape2HH(type,Xi,int(Norder(1)),iNum,ShapH,GradH)
          endif
        elseif (s.eq.1) then
          if (c.eq.1) then
            allocate(ShapE(n,MAXquadE),CurlE(2*n-3,MAXquadE))
            call shape2DE(type,Xi,int(Norder),int(NoriE),
     .                                    iNum,ShapE,CurlE)
          elseif (c.eq.0) then
            allocate(ShapE(n,MAXquadEE),CurlE(2*n-3,MAXquadEE))
            call shape2EE(type,Xi,int(Norder(1)),iNum,ShapE,CurlE)
          endif
        elseif (s.eq.2) then
          if (c.eq.1) then
            allocate(ShapV(n,MAXquadV),DivV(MAXquadV))
            call shape2DV(type,Xi,int(Norder),int(NoriE),
     .                                  iNum,ShapV,DivV)
          elseif (c.eq.0) then
            allocate(ShapV(n,MAXquadVV),DivV(MAXquadVV))
            call shape2VV(type,Xi,int(Norder(1)),iNum,ShapV,DivV)
          endif
        elseif (s.eq.3) then
          if (c.eq.1) then
            allocate(ShapQ(MAXquadQ))
            call shape2DQ(type,Xi,int(Norder), iNum,ShapQ)
          elseif (c.eq.0) then
            allocate(ShapQ(MAXquadQQ))
            call shape2QQ(type,Xi,int(Norder(1)), iNum,ShapQ)
          endif
        endif
	  	  
      endif
      Num=real(iNum)
C-----------------------------------------------------------------------

C     Create matrix for the output argument.
C     Load the data into y_ptr, which is the output to MATLAB.
      if (s.eq.0) then
        plhs(1) = mxCreateDoubleMatrix(1,iNum,0)
        ShapH_ptr = mxGetPr(plhs(1))
        plhs(2) = mxCreateDoubleMatrix(n,iNum,0)
        GradH_ptr = mxGetPr(plhs(2))
        call mxCopyReal8ToPtr(ShapH(1:iNum),ShapH_ptr,1*iNum)     
        call mxCopyReal8ToPtr(GradH(1:n,1:iNum),GradH_ptr,n*iNum)
      elseif (s.eq.1) then
        plhs(1) = mxCreateDoubleMatrix(n,iNum,0)
        ShapE_ptr = mxGetPr(plhs(1))
        plhs(2) = mxCreateDoubleMatrix(2*n-3,iNum,0)
        CurlE_ptr = mxGetPr(plhs(2))
        call mxCopyReal8ToPtr(ShapE(1:n,1:iNum),ShapE_ptr,n*iNum)     
        call mxCopyReal8ToPtr(CurlE(1:2*n-3,1:iNum),CurlE_ptr,
     .												(2*n-3)*iNum)
      elseif (s.eq.2) then
        plhs(1) = mxCreateDoubleMatrix(n,iNum,0)
        ShapV_ptr = mxGetPr(plhs(1))
        plhs(2) = mxCreateDoubleMatrix(1,iNum,0)
        DivV_ptr = mxGetPr(plhs(2))
        call mxCopyReal8ToPtr(ShapV(1:n,1:iNum),ShapV_ptr,n*iNum)     
        call mxCopyReal8ToPtr(DivV(1:iNum),DivV_ptr,1*iNum)
	    elseif (s.eq.3) then
  		  plhs(1) = mxCreateDoubleMatrix(1,iNum,0)
        ShapQ_ptr = mxGetPr(plhs(1))
        call mxCopyReal8ToPtr(ShapQ(1:iNum),ShapQ_ptr,1*iNum)
      endif

      return
      end


c----------------------------------------------------------------------


      module parameters

      implicit none

c       ...maximum order of approximation
      integer, parameter :: MAXP=7

c  ...modulo to encode polynomial orders 
c  ...(do not change unless using stand-alone shape functions package)
      integer, parameter :: MODORDER=100


c----------------------------------------------------------------------
c      === ELEMENT ====
c       ...max number of local dof for a 2D quad element
      integer, parameter :: MAXquadH = (MAXP+1)**2
      integer, parameter :: MAXquadE = 2*MAXP*(MAXP+1)
      integer, parameter :: MAXquadV = MAXquadE
      integer, parameter :: MAXquadQ = MAXP**2
c       ...max number of local dof for a 2D triangular element
      integer, parameter :: MAXtriaH = (MAXP+1)*(MAXP+2)/2
      integer, parameter :: MAXtriaE = MAXP*(MAXP+2)
      integer, parameter :: MAXtriaV = MAXtriaE
      integer, parameter :: MAXtriaQ = MAXP*(MAXP+1)/2
c----------------------------------------------------------------------
c       ...max number of local dof for a 3D brick element
      integer, parameter :: MAXbrickH = 1
      integer, parameter :: MAXbrickE = 1
      integer, parameter :: MAXbrickV = 1
      integer, parameter :: MAXbrickQ = 1
c       ...max number of local dof for a 3D prism element
      integer, parameter :: MAXprismH = 1
      integer, parameter :: MAXprismE = 1
      integer, parameter :: MAXprismV = 1
      integer, parameter :: MAXprismQ = 1
c       ...max number of local dof for a 3D tetrahedral  element
      integer, parameter :: MAXtetraH = 1
      integer, parameter :: MAXtetraE = 1
      integer, parameter :: MAXtetraV = 1
      integer, parameter :: MAXtetraQ = 1
c       ...max number of local dof for a 3D pyramid  element
      integer, parameter :: MAXpyramH = 1
      integer, parameter :: MAXpyramE = 1
      integer, parameter :: MAXpyramV = 1
      integer, parameter :: MAXpyramQ = 1
c----------------------------------------------------------------------
c       ==== NODE ===
c       ...maximum number of dof for 'mdlt'
      integer, parameter :: MAXmdltH=(MAXP-2)*(MAXP-1)/2
      integer, parameter :: MAXmdltE=(MAXP-1)*MAXP
      integer, parameter :: MAXmdltV=MAXmdltE
      integer, parameter :: MAXmdltQ=MAXP*(MAXP+1)/2
c       ...maximum number of dof for 'mdlq'
      integer, parameter :: MAXmdlqH=(MAXP-1)**2
      integer, parameter :: MAXmdlqE=2*MAXP*(MAXP-1)
      integer, parameter :: MAXmdlqV=MAXmdlqE
      integer, parameter :: MAXmdlqQ=MAXP**2
c       ...maximum number of dof for 'mdlb'
      integer, parameter :: MAXmdlbH=1
      integer, parameter :: MAXmdlbE=1
      integer, parameter :: MAXmdlbV=1
      integer, parameter :: MAXmdlbQ=1
c       ...maximum number of dof for 'mdln'
      integer, parameter :: MAXmdlnH=1
      integer, parameter :: MAXmdlnE=1
      integer, parameter :: MAXmdlnV=1
      integer, parameter :: MAXmdlnQ=1
c       ...maximum number of dof for 'mdlp'
      integer, parameter :: MAXmdlpH=1
      integer, parameter :: MAXmdlpE=1
      integer, parameter :: MAXmdlpV=1
      integer, parameter :: MAXmdlpQ=1
c     maximum number of dof for 'mdld'
      integer, parameter :: MAXmdldH=1
      integer, parameter :: MAXmdldE=1
      integer, parameter :: MAXmdldV=1
      integer, parameter :: MAXmdldQ=1

      end module parameters

      module parametersDPG

      use parameters

      implicit none
c
c  ...increment in order to define the enriched spaces
      integer, parameter :: MAXNORD_ADD=1
c
c  ...maximum enriched order
      integer, parameter :: MAXPP = MAXP+MAXNORD_ADD
c
c  ...maximum number of quadrature points for an enriched  2D element
      integer, parameter :: MAXNINT2ADD = (MAXPP+1)**2
c
c  ...maximum number of quadrature points for an enriched  3D element
      integer, parameter :: MAXNINT3ADD = 1
c
c----------------------------------------------------------------------
c  === ELEMENT ====
c  ...max number of local dof for a 2D quad element
      integer, parameter :: MAXquadHH = (MAXPP+1)**2
      integer, parameter :: MAXquadEE = 2*MAXPP*(MAXPP+1)
      integer, parameter :: MAXquadVV = MAXquadEE
      integer, parameter :: MAXquadQQ = MAXPP**2
c
c  ...max number of local dof for a 2D triangular element
      integer, parameter :: MAXtriaHH = (MAXPP+1)*(MAXPP+2)/2
      integer, parameter :: MAXtriaEE = MAXPP*(MAXPP+2)
      integer, parameter :: MAXtriaVV = MAXtriaEE
      integer, parameter :: MAXtriaQQ = MAXPP*(MAXPP+1)/2
c
c----------------------------------------------------------------------
c
c  ...max number of local dof for a 3D brick element
      integer, parameter :: MAXbrickHH = 1
      integer, parameter :: MAXbrickEE = 1
      integer, parameter :: MAXbrickVV = 1
      integer, parameter :: MAXbrickQQ = 1
c
c  ...max number of local dof for a 3D prism element
      integer, parameter :: MAXprismHH = 1
      integer, parameter :: MAXprismEE = 1
      integer, parameter :: MAXprismVV = 1
      integer, parameter :: MAXprismQQ = 1
c
c  ...max number of local dof for a 3D tetrahedral  element
      integer, parameter :: MAXtetraHH = 1
      integer, parameter :: MAXtetraEE = 1
      integer, parameter :: MAXtetraVV = 1
      integer, parameter :: MAXtetraQQ = 1
c
c  ...max number of local dof for a 3D pyramid  element
      integer, parameter :: MAXpyramHH = 1
      integer, parameter :: MAXpyramEE = 1
      integer, parameter :: MAXpyramVV = 1
      integer, parameter :: MAXpyramQQ = 1

      end module parametersDPG


c Routines:
c  - shape1DH
c  - shape1DQ
c  - shape2DH
c  - shape2DE
c  - shape2DV
c  - shape2DQ
c  - shape3DH
c  - shape3DE
c  - shape3DV
c  - shape3DQ
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                            1D: H1--->L2
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 1D H1
c----------------------------------------------------------------------
c
c     routine name      - shape1DH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate 1D H1 shape functions
c
c     arguments:
c
c     in:
c       Xi              - master element coordinates
c       Nord            - polynomial order of edge node (H1 sense)
c
c     out:
c       NrdofH          - number of shape functions
c       ShapH           - values of shape functions
c       GradH           - gradients of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1DH(Xi,Nord, NrdofH,ShapH,GradH)
c
      use parameters , only : MAXP
c
      implicit none
      integer, intent(in)  :: Nord
      integer :: NordA(1)
      integer, intent(out) :: NrdofH
      integer :: nsize(2)
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapH(MAXP+1)
      double precision, intent(out) :: GradH(MAXP+1)
c
      NordA(1)=Nord
      call checkorder('segm','contin',NordA,MAXP, nsize,1)
      call shape1DHSeg(Xi,Nord,nsize, NrdofH,ShapH,GradH)
c
      end subroutine shape1DH
c
c----------------------------------------------------------------------
c                                 1D L2
c----------------------------------------------------------------------
c
c     routine name      - shape1DQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate 1D L2 shape functions
c
c     arguments:
c
c     in:
c       Xi              - master element coordinates
c       Nord            - polynomial order of edge node (H1 sense)
c
c     out:
c       NrdofQ          - number of shape functions
c       ShapQ           - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1DQ(Xi,Nord, NrdofQ,ShapQ)
c
      use parameters , only : MAXP
c
      implicit none
      integer, intent(in)  :: Nord
      integer :: NordA(1)
      integer, intent(out) :: NrdofQ
      integer :: nsize(2)
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapQ(MAXP)
c
      NordA(1)=Nord
      call checkorder('segm','discon',NordA,MAXP, nsize,1)
      call shape1DQSeg(Xi,Nord,nsize, NrdofQ,ShapQ)
c
      end subroutine shape1DQ
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                        2D: H1--->Hcurl--->L2
c                            H1--->Hdiv --->L2 (rotated)
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 2D H1
c----------------------------------------------------------------------
c
c     routine name      - shape2DH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of a 2D element
c                         H1 shape functions and their derivatives
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c
c     out:
c       NrdofH          - number of dof
c       ShapH           - values of the shape functions at the point
c       GradH           - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DH(Type,Xi,Norder,NoriE, NrdofH,ShapH,GradH)
c
      use parameters , only : MAXP,MAXquadH
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: Norder(5)
      integer, intent(in)  :: NoriE(4)
      integer, intent(out) :: NrdofH
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapH(MAXquadH)
      double precision, intent(out) :: GradH(2,MAXquadH)
c
      call checkorder(Type,'contin',Norder,MAXP, nsize,5)
      select case(Type)
      case('tria','mdlt')
        call shape2DHTri(Xi,Norder,NoriE,nsize, NrdofH,ShapH,GradH)
      case('quad','mdlq','rect')
        call shape2DHQuad(Xi,Norder,NoriE,nsize, NrdofH,ShapH,GradH)
      case default
        write(*,*)'shape2DH: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2DH
c
c----------------------------------------------------------------------
c                                2D Hcurl
c----------------------------------------------------------------------
c
c     routine name      - shape2DE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of a 2D element
c                         H(curl) shape functions and their curl
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c     out:
c       NrdofE          - number of dof
c       ShapE           - values of the shape functions at the point
c       CurlE           - curl of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DE(Type,Xi,Norder,NoriE, NrdofE,ShapE,CurlE)
c
      use parameters , only : MAXP,MAXquadE
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: Norder(5)
      integer, intent(in)  :: NoriE(4)
      integer, intent(out) :: NrdofE
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapE(2,MAXquadE)
      double precision, intent(out) :: CurlE(MAXquadE)
c
      call checkorder(Type,'tangen',Norder,MAXP, nsize,5)
      select case(Type)
      case('tria','mdlt')
        call shape2DETri(Xi,Norder,NoriE,nsize, NrdofE,ShapE,CurlE)
      case('quad','mdlq','rect')
        call shape2DEQuad(Xi,Norder,NoriE,nsize, NrdofE,ShapE,CurlE)
      case default
        write(*,*)'shape2DE: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2DE
c
c----------------------------------------------------------------------
c                          2D Hdiv (rotated Hcurl)
c----------------------------------------------------------------------
c
c     routine name      - shape2DV
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of a 2D element
c                         H(div) shape functions and their divergence
c                         NOTE: only relevant in 2D problems!!
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c
c     out:
c       NrdofV          - number of dof
c       ShapV           - values of the shape functions at the point
c       DivV            - divergences of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DV(Type,Xi,Norder,NoriE, NrdofV,ShapV,DivV)
c
      use parameters , only : MAXP,MAXquadV
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: Norder(5)
      integer, intent(in)  :: NoriE(4)
      integer, intent(out) :: NrdofV
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapV(2,MAXquadV)
      double precision, intent(out) :: DivV(MAXquadV)
c
      call checkorder(Type,'normal',Norder,MAXP, nsize,5)
      select case(Type)
      case('tria','mdlt')
        call shape2DVTri(Xi,Norder,NoriE,nsize, NrdofV,ShapV,DivV)
      case('quad','mdlq','rect')
        call shape2DVQuad(Xi,Norder,NoriE,nsize, NrdofV,ShapV,DivV)
      case default
        write(*,*)'shape2DV: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2DV
c
c----------------------------------------------------------------------
c                                 2D L2
c----------------------------------------------------------------------
c
c     routine name      - shape2DQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of a 2D element
c                         L2 shape functions
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c
c     out:
c       NrdofQ          - number of dof
c       ShapQ           - values of the shape functions at the point
c
c----------------------------------------------------------------------
c
      subroutine shape2DQ(Type,Xi,Norder, NrdofQ,ShapQ)
c
      use parameters , only : MAXP,MAXquadQ
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: Norder(5)
      integer, intent(out) :: NrdofQ
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapQ(MAXquadQ)
c
      call checkorder(Type,'discon',Norder,MAXP, nsize,5)
      select case(Type)
      case('tria','mdlt')
        call shape2DQTri(Xi,Norder,nsize, NrdofQ,ShapQ)
      case('quad','mdlq','rect')
        call shape2DQQuad(Xi,Norder,nsize, NrdofQ,ShapQ)
      case default
        write(*,*)'shape2DQ: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2DQ
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                      3D: H1--->Hcurl--->Hdiv--->L2
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 3D H1
c----------------------------------------------------------------------
c
c     routine name      - shape3DH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates H1 shape functions for 3D
c                         elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c       NoriF           - face orientations
c
c     out:
c       NrdofH          - number of the element shape functions
c       ShapH           - values of shape functions
c       GradH           - gradients of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3DH(Type,Xi,Norder,NoriE,NoriF,
     .                                             NrdofH,ShapH,GradH)
c
      use parameters , only : MAXP,MAXbrickH
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NoriE(12)
      integer, intent(in)  :: NoriF(6)
      integer, intent(in)  :: Norder(19)
      integer, intent(out) :: NrdofH
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(MAXbrickH)
      double precision, intent(out) :: GradH(3,MAXbrickH)
c
      call checkorder(Type,'contin',Norder,MAXP, nsize,19)
      select case(Type)
      case('bric','mdlb')
        call shape3DHHexa(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofH,ShapH,GradH)
      case('tetr','mdln')
        call shape3DHTet(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofH,ShapH,GradH)
      case('pris','mdlp')
        call shape3DHPris(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofH,ShapH,GradH)
      case('pyra','mdld')
        call shape3DHPyra(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofH,ShapH,GradH)
      case default
        write(*,*)'shape3DH: Type = ', Type
        stop
      end select
c
      end subroutine shape3DH
c
c----------------------------------------------------------------------
c                                3D Hcurl
c----------------------------------------------------------------------
c
c     routine name      - shape3DE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates H(curl) shape functions for
c                         3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c       NoriF           - face orientations
c
c     out:
c       NrdofE          - number of the element shape functions
c       ShapE           - shape functions
c       CurlE           - curls of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3DE(Type,Xi,Norder,NoriE,NoriF,
     .                                             NrdofE,ShapE,CurlE)
c
      use parameters , only : MAXP,MAXbrickE
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NoriE(12)
      integer, intent(in)  :: NoriF(6)
      integer, intent(in)  :: Norder(19)
      integer, intent(out) :: NrdofE
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(3,MAXbrickE)
      double precision, intent(out) :: CurlE(3,MAXbrickE)
c
      call checkorder(Type,'tangen',Norder,MAXP, nsize,19)
      select case(Type)
      case('bric','mdlb')
        call shape3DEHexa(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofE,ShapE,CurlE)
      case('tetr','mdln')
        call shape3DETet(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofE,ShapE,CurlE)
      case('pris','mdlp')
        call shape3DEPris(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofE,ShapE,CurlE)
      case('pyra','mdld')
        call shape3DEPyra(Xi,Norder,NoriE,NoriF,nsize,
     .                                  NrdofE,ShapE,CurlE)
      case default
        write(*,*)'shape3DE: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3DE
c
c----------------------------------------------------------------------
c                                3D Hdiv
c----------------------------------------------------------------------
c
c     routine name      - shape3DV
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates H(div) shape functions for
c                         3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order for the nodes (H1 sense)
c       NoriF           - face orientations
c
c     out:
c       NrdofV          - number of the element shape functions
c       ShapV           - shape functions
c       DivV            - divergence of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3DV(Type,Xi,Norder,NoriF, NrdofV,ShapV,DivV)
c
      use parameters , only : MAXP,MAXbrickV
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NoriF(6)
      integer, intent(in)  :: Norder(19)
      integer, intent(out) :: NrdofV
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(3,MAXbrickV)
      double precision, intent(out) :: DivV(MAXbrickV)
c
      call checkorder(Type,'normal',Norder,MAXP, nsize,19)
      select case(Type)
      case('bric','mdlb')
        call shape3DVHexa(Xi,Norder,NoriF,nsize, NrdofV,ShapV,DivV)
      case('tetr','mdln')
        call shape3DVTet(Xi,Norder,NoriF,nsize, NrdofV,ShapV,DivV)
      case('pris','mdlp')
        call shape3DVPris(Xi,Norder,NoriF,nsize, NrdofV,ShapV,DivV)
      case('pyra','mdld')
        call shape3DVPyra(Xi,Norder,NoriF,nsize, NrdofV,ShapV,DivV)
      case default
        write(*,*)'shape3DV: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3DV
c
c----------------------------------------------------------------------
c                                 3D L2
c----------------------------------------------------------------------
c
c     routine name      - shape3DQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates L2 shape functions for 3D
c                         elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       Norder          - polynomial order of interior node (H1 sense)
c
c     out:
c       NrdofQ          - number of the element shape functions
c       ShapQ           - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3DQ(Type,Xi,Norder, NrdofQ,ShapQ)
c
      use parameters , only : MAXP,MAXbrickQ
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: Norder(19)
      integer, intent(out) :: NrdofQ
      integer :: nsize(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(MAXbrickQ)
c
      call checkorder(Type,'discon',Norder,MAXP, nsize,19)
      select case(Type)
      case('bric','mdlb')
        Nsize=(/MAXP,MAXbrickQ/)
        call shape3DQHexa(Xi,Norder,nsize, NrdofQ,ShapQ)
      case('tetr','mdln')
        call shape3DQTet(Xi,Norder,nsize, NrdofQ,ShapQ)
      case('pris','mdlp')
        call shape3DQPris(Xi,Norder,nsize, NrdofQ,ShapQ)
      case('pyra','mdld')
        call shape3DQPyra(Xi,Norder,nsize, NrdofQ,ShapQ)
      case default
        write(*,*)'shape3DQ: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3DQ
c









c Routines:
c  - shape1HH
c  - shape1QQ
c  - shape2HH
c  - shape2EE
c  - shape2VV
c  - shape2QQ
c  - shape3HH
c  - shape3EE
c  - shape3VV
c  - shape3QQ
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                            1D: H1--->L2
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 1D H1
c----------------------------------------------------------------------
c
c     routine name      - shape1HH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate 1D BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofH          - number of the element shape functions
c       ShapH           - values of shape functions
c       GradH           - gradients of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1HH(Xi,NordM, NrdofH,ShapH,GradH)
c
      use parametersDPG , only : MAXPP
c
      implicit none
      integer, intent(in)  :: NordM
      integer :: NordA(1)
      integer, intent(out) :: NrdofH
      integer :: nsize(2)
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapH(MAXPP+1)
      double precision, intent(out) :: GradH(MAXPP+1)
c
      NordA(1)=NordM
      call checkorder('segm','contin',NordA,MAXPP, nsize,1)
      call shape1DHBrokenSeg(Xi,NordM,nsize, NrdofH,ShapH,GradH)
c
      end subroutine shape1HH
c
c----------------------------------------------------------------------
c                                 1D L2
c----------------------------------------------------------------------
c
c     routine name      - shape1QQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate 1D BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofQ          - number of the element shape functions
c       ShapQ           - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1QQ(Xi,NordM, NrdofQ,ShapQ)
c
      use parametersDPG , only : MAXPP
c
      implicit none
      integer, intent(in)  :: NordM
      integer :: NordA(1)
      integer, intent(out) :: NrdofQ
      integer :: nsize(2)
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapQ(MAXPP)
c
      NordA(1)=NordM
      call checkorder('segm','discon',NordA,MAXPP, nsize,1)
      call shape1DQBrokenSeg(Xi,NordM,nsize, NrdofQ,ShapQ)
c
      end subroutine shape1QQ
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                        2D: H1--->Hcurl--->L2
c                            H1--->Hdiv --->L2 (rotated)
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 2D H1
c----------------------------------------------------------------------
c
c     routine name      - shape2HH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H1 shape 
c                         functions for 2D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofH          - number of the element shape functions
c       ShapH           - values of shape functions
c       GradH           - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2HH(Type,Xi,NordM, NrdofH,ShapH,GradH)
c
      use parametersDPG , only : MAXPP,MAXquadHH
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofH
      integer :: nsize(2),norder(5)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapH(MAXquadHH)
      double precision, intent(out) :: GradH(2,MAXquadHH)
c
      select case(Type)
      case('tria','mdlt')
        norder(1:3)=1
        norder(4)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,5)
        call shape2DHBrokenTri(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case('quad','mdlq','rect')
        norder(1:4)=1
        norder(5)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,5)
        call shape2DHBrokenQuad(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case default
        write(*,*)'shape2HH: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2HH
c
c----------------------------------------------------------------------
c                                2D Hcurl
c----------------------------------------------------------------------
c
c     routine name      - shape2EE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H(curl) shape 
c                         functions for 2D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofE          - number of the element shape functions
c       ShapE           - shape functions
c       CurlE           - curls of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2EE(Type,Xi,NordM, NrdofE,ShapE,CurlE)
c
      use parametersDPG , only : MAXPP,MAXquadEE
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofE
      integer :: nsize(2),norder(5)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapE(2,MAXquadEE)
      double precision, intent(out) :: CurlE(MAXquadEE)
c
      select case(Type)
      case('tria','mdlt')
        norder(1:3)=1
        norder(4)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,5)
        call shape2DEBrokenTri(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case('quad','mdlq','rect')
        norder(1:4)=1
        norder(5)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,5)
        call shape2DEBrokenQuad(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case default
        write(*,*)'shape2EE: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2EE
c
c----------------------------------------------------------------------
c                          2D Hdiv (rotated Hcurl)
c----------------------------------------------------------------------
c
c     routine name      - shape2VV
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H(div) shape 
c                         functions for 2D elements of various types
c                         NOTE: only relevant in 2D problems!!
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofV          - number of the element shape functions
c       ShapV           - shape functions
c       DivV            - divergence of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2VV(Type,Xi,NordM, NrdofV,ShapV,DivV)
c
      use parametersDPG , only : MAXPP,MAXquadVV
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofV
      integer :: nsize(2),norder(5)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapV(2,MAXquadVV)
      double precision, intent(out) :: DivV(MAXquadVV)
c
      select case(Type)
      case('tria','mdlt')
        norder(1:3)=1
        norder(4)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,5)
        call shape2DVBrokenTri(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case('quad','mdlq','rect')
        norder(1:4)=1
        norder(5)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,5)
        call shape2DVBrokenQuad(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case default
        write(*,*)'shape2VV: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2VV
c
c----------------------------------------------------------------------
c                                 2D L2
c----------------------------------------------------------------------
c
c     routine name      - shape2QQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN L2 shape 
c                         functions for 2D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofQ          - number of the element shape functions
c       ShapQ           - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2QQ(Type,Xi,NordM, NrdofQ,ShapQ)
c
      use parametersDPG , only : MAXPP,MAXquadQQ
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofQ
      integer :: nsize(2),norder(5)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapQ(MAXquadQQ)
c
      select case(Type)
      case('tria','mdlt')
        norder(1:3)=1
        norder(4)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,5)
        call shape2DQBrokenTri(Xi,NordM,nsize, NrdofQ,ShapQ)
      case('quad','mdlq','rect')
        norder(1:4)=1
        norder(5)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,5)
        call shape2DQBrokenQuad(Xi,NordM,nsize, NrdofQ,ShapQ)
      case default
        write(*,*)'shape2QQ: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape2QQ
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                      3D: H1--->Hcurl--->Hdiv--->L2
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c                                 3D H1
c----------------------------------------------------------------------
c
c     routine name      - shape3HH
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H1 shape 
c                         functions for 3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofH          - number of the element shape functions
c       ShapH           - values of shape functions
c       GradH           - gradients of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3HH(Type,Xi,NordM, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
      use parametersDPG , only : MAXPP,MAXbrickHH
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofH
      integer :: nsize(2),norder(19),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(MAXbrickHH)
      double precision, intent(out) :: GradH(3,MAXbrickHH)
c
      select case(Type)
      case('bric','mdlb')
        norder(1:12)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(13:18)=nordF
        norder(19)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,19)
        call shape3DHBrokenHexa(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case('tetr','mdln')
        norder(1:10)=1
        norder(11)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,19)
        call shape3DHBrokenTet(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case('pris','mdlp')
        norder(1:11)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(12:14)=nordF
        norder(15)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,19)
        call shape3DHBrokenPris(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case('pyra','mdld')
        norder(1:8)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(9)=nordF
        norder(10:13)=1
        norder(14)=NordM
        call checkorder(Type,'contin',norder,MAXPP, nsize,19)
        call shape3DHBrokenPyra(Xi,NordM,nsize, NrdofH,ShapH,GradH)
      case default
        write(*,*)'shape3HH: Type = ', Type
        stop
      end select
c
      end subroutine shape3HH
c
c----------------------------------------------------------------------
c                                3D Hcurl
c----------------------------------------------------------------------
c
c     routine name      - shape3EE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H(curl) shape 
c                         functions for 3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofE          - number of the element shape functions
c       ShapE           - shape functions
c       CurlE           - curls of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3EE(Type,Xi,NordM, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
      use parametersDPG , only : MAXPP,MAXbrickEE
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofE
      integer :: nsize(2),norder(19),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(3,MAXbrickEE)
      double precision, intent(out) :: CurlE(3,MAXbrickEE)
c
      select case(Type)
      case('bric','mdlb')
        norder(1:12)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(13:18)=nordF
        norder(19)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,19)
        call shape3DEBrokenHexa(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case('tetr','mdln')
        norder(1:10)=1
        norder(11)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,19)
        call shape3DEBrokenTet(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case('pris','mdlp')
        norder(1:11)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(12:14)=nordF
        norder(15)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,19)
        call shape3DEBrokenPris(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case('pyra','mdld')
        norder(1:8)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(9)=nordF
        norder(10:13)=1
        norder(14)=NordM
        call checkorder(Type,'tangen',norder,MAXPP, nsize,19)
        call shape3DEBrokenPyra(Xi,NordM,nsize, NrdofE,ShapE,CurlE)
      case default
        write(*,*)'shape3EE: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3EE
c
c----------------------------------------------------------------------
c                                3D Hdiv
c----------------------------------------------------------------------
c
c     routine name      - shape3VV
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN H(div) shape 
c                         functions for 3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofV          - number of the element shape functions
c       ShapV           - shape functions
c       DivV            - divergence of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3VV(Type,Xi,NordM, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
      use parametersDPG , only : MAXPP,MAXbrickVV
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofV
      integer :: nsize(2),norder(19),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(3,MAXbrickVV)
      double precision, intent(out) :: DivV(MAXbrickVV)
c
      select case(Type)
      case('bric','mdlb')
        norder(1:12)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(13:18)=nordF
        norder(19)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,19)
        call shape3DVBrokenHexa(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case('tetr','mdln')
        norder(1:10)=1
        norder(11)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,19)
        call shape3DVBrokenTet(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case('pris','mdlp')
        norder(1:11)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(12:14)=nordF
        norder(15)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,19)
        call shape3DVBrokenPris(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case('pyra','mdld')
        norder(1:8)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(9)=nordF
        norder(10:13)=1
        norder(14)=NordM
        call checkorder(Type,'normal',norder,MAXPP, nsize,19)
        call shape3DVBrokenPyra(Xi,NordM,nsize, NrdofV,ShapV,DivV)
      case default
        write(*,*)'shape3VV: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3VV
c
c----------------------------------------------------------------------
c                                 3D L2
c----------------------------------------------------------------------
c
c     routine name      - shape3QQ
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine evaluates BROKEN L2 shape 
c                         functions for 3D elements of various types
c
c     arguments:
c
c     in:
c       Type            - element type
c       Xi              - master element coordinates
c       NordM           - polynomial order for middle node (H1 sense)
c
c     out:
c       NrdofQ          - number of the element shape functions
c       ShapQ           - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape3QQ(Type,Xi,NordM, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
      use parametersDPG , only : MAXPP,MAXbrickQQ
c
      implicit none
      character(len=4), intent(in)  :: Type
      integer, intent(in)  :: NordM
      integer, intent(out) :: NrdofQ
      integer :: nsize(2),norder(19),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(MAXbrickQQ)
c
      select case(Type)
      case('bric','mdlb')
        norder(1:12)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(13:18)=nordF
        norder(19)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,19)
        call shape3DQBrokenHexa(Xi,NordM,nsize, NrdofQ,ShapQ)
      case('tetr','mdln')
        norder(1:10)=1
        norder(11)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,19)
        call shape3DQBrokenTet(Xi,NordM,nsize, NrdofQ,ShapQ)
      case('pris','mdlp')
        norder(1:11)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(12:14)=nordF
        norder(15)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,19)
        call shape3DQBrokenPris(Xi,NordM,nsize, NrdofQ,ShapQ)
      case('pyra','mdld')
        norder(1:8)=1
        call encod((/1,1/),MODORDER,2, nordF)
        norder(9)=nordF
        norder(10:13)=1
        norder(14)=NordM
        call checkorder(Type,'discon',norder,MAXPP, nsize,19)
        call shape3DQBrokenPyra(Xi,NordM,nsize, NrdofQ,ShapQ)
      case default
        write(*,*)'shape3QQ: Type = ', Type
c        stop 1
      end select
c
      end subroutine shape3QQ
c








c Routines:
c  - shape2DHQuad
c  - shape2DEQuad
c  - shape2DVQuad
c  - shape2DQQuad
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DHQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate quad H1 shape functions and their
c                         gradient
c
c     arguments:
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order for the nodes (H1 sense)
c        NoriE          - edge orientations
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofH         - number of dof
c        ShapH          - values of shape functions
c        GradH          - gradients of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DHQuad(Xi,Nord,NoriE,Nsize, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(5),NoriE(4),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: iprint,N,m,v,e,i,j,nordE,ndofE,nordF(2),ndofF
      integer :: minI,minJ,maxI,maxJ
      logical :: IdecE,IdecF(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(2,Nsize(2))
      double precision :: Mu(2,0:1),DMu(2,2,0:1)
      double precision :: MubV(4,2),DMubV(4,2,2)
      double precision :: MubE(4),DMubE(4,2)
      double precision :: MupE(4,0:1),DMupE(4,2,0:1)
      double precision :: GMupE(0:1),GDMupE(2,0:1)
      double precision :: phiE(2:Nsize(1)),DphiE(2,2:Nsize(1))
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(2,2:Nsize(1),2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...local parameters
      minI  = 2
      minJ  = 2
c
c  ...Define affine coordinates and gradients
      call AffineQuadrilateral(Xi, Mu,DMu)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendQuadV(Mu,DMu, MubV,DMubV)
c  ...loop over vertices
      do v=1,4
        m=m+1
c
        ShapH(m)     = MubV(v,1)*MubV(v,2)
        GradH(1:N,m) = DMubV(v,1:N,1)*MubV(v,2)
     .               + MubV(v,1)*DMubV(v,1:N,2)
      enddo
c
c  ...EDGE SHAPE FUNCTIONS
      call BlendProjectQuadE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE-1
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE
c      ...orient
          call OrientE(MupE(e,0:1),DMupE(e,1:N,0:1),NoriE(e),N,
     .                                                    GMupE,GDMupE)
c      ...construct the shape functions
          call AncPhiE(GMupE,GDMupE,nordE,IdecE,N,
     .                            phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapH(m)     = MubE(e)*phiE(i)
            GradH(1:N,m) = MubE(e)*DphiE(1:N,i)
     .                   + DMubE(e,1:N)*phiE(i)
          enddo
        endif
      enddo
c
c  ...FACE BUBBLE FUNCTIONS
c  ...local parameters
      IdecF(1:2) = .TRUE.
      call decod(Nord(5),MODORDER,2, nordF)
      ndofF = (nordF(1)-1)*(nordF(2)-1)
      if (ndofF.gt.0) then
c    ...local parameters (again)
        maxI = nordF(1)
        maxJ = nordF(2)
c    ...construct the shape functions
        call AncPhiQuad(Mu,DMu,nordF,IdecF,N,
     .                                    phiQuad(minI:maxI,minJ:maxJ),
     .                               DphiQuad(1:N,minI:maxI,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
c
            ShapH(m)     = phiQuad(i,j)
            GradH(1:N,m) = DphiQuad(1:N,i,j)
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi(1:2),Nord(1:5),NoriE(1:4)
 7001   format('shape2DHQuad: Xi = ',2f8.3,/,
     .         'Norder  = ',4i2,2x,i2,/,
     .         'Norient = ',4i2)
        write(*,7002)
 7002   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,4
          m=v
          write(*,7003) m,ShapH(m),GradH(1:2,m)
 7003     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,2e12.5)
        enddo
        do e=1,4
          ndofE = Nord(e)-1
          if (ndofE.gt.0) then
            write(*,7004) e
 7004       format('EDGE SHAPE FUNCTIONS = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapH(m),GradH(1:2,m)
            enddo
          endif
        enddo
        if (ndofF.gt.0) then
          write(*,7005)
 7005     format('FACE BUBBLES = ')
          do j=1,ndofF
            m=m+1
            write(*,7003) m,ShapH(m),GradH(1:2,m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DHQuad
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DEQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate quad H(curl) shape functions and 
c                         their curls
c
c     arguments:
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order for the nodes (H1 sense)
c        NoriE          - edge orientations
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofE         - number of dof
c        ShapE          - values of shape functions
c        CurlE          - curls of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DEQuad(Xi,Nord,NoriE,Nsize, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(5),NoriE(4),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: iprint,N,m,e,i,j,ij(2),ig,jg,nordE,ndofE,a,b,ab(2),fam
      integer :: nordF(2),ndofF(0:1),minI,maxI,minF(2),maxF(2)
      logical :: IdecE,IdecF(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapE(2,Nsize(2))
      double precision, intent(out) :: CurlE(Nsize(2))
      double precision :: Mu(2,0:1),DMu(2,2,0:1)
      double precision :: MubE(4),DMubE(4,2)
      double precision :: MupE(4,0:1),DMupE(4,2,0:1)
      double precision :: GMupE(0:1),GDMupE(2,0:1)
      double precision :: EE(2,0:Nsize(1)-1),curlEE(0:Nsize(1)-1)
      double precision :: EQuad(2,0:Nsize(1)-1,2:Nsize(1))
      double precision :: curlEQuad(0:Nsize(1)-1,2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...local parameters
      minI = 0
c
c  ...Define affine coordinates and gradients
      call AffineQuadrilateral(Xi, Mu,DMu)
c
c  ...EDGE SHAPE FUNCTIONS
      call BlendProjectQuadE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE-1
c      ...orient
          call OrientE(MupE(e,0:1),DMupE(e,1:N,0:1),NoriE(e),N,
     .                                                    GMupE,GDMupE)
c      ...construct the shape functions (curlEE should evaluate to 0)
          call AncEE(GMupE,GDMupE,nordE,IdecE,N,
     .                             EE(1:N,minI:maxI),curlEE(minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = MubE(e)*EE(1:N,i)
            call cross(N,DMubE(e,1:N),EE(1:N,i), CurlE(m))
          enddo
        endif
      enddo
c
c  ...FACE BUBBLE FUNCTIONS
c  ...local parameters
      IdecF(1:2) = .TRUE.
      call decod(Nord(5),MODORDER,2, nordF)
c    ...loop over families
      do fam=0,1
        ab = cshift((/1,2/),fam);
        a = ab(1); b = ab(2)
c    ...degrees of freedom (dof) for this family
        ndofF(fam) = nordF(a)*(nordF(b)-1)
        if (ndofF(fam).gt.0) then
c      ...local parameters (again)
          minF(1) = 0
          minF(2) = 2
          maxF(1) = nordF(a)-1
          maxF(2) = nordF(b)
c      ...construct the shape functions
          call AncEQuad(Mu(ab,0:1),DMu(1:N,ab,0:1),
     .                                       nordF(ab),IdecF(ab),N,
     .                      EQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)),
     .                      curlEQuad(minF(1):maxF(1),minF(2):maxF(2)))
c      ...in the code the outer loop always is
c      ...numbered wrt the second global face axis
          minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
          do jg=minF(2),maxF(2)
            do ig=minF(1),maxF(1)
              ij = cshift((/ig,jg/),fam)
              i = ij(1); j = ij(2)
              m=m+1
c
              ShapE(1:N,m) = EQuad(1:N,i,j)
              CurlE(m)     = curlEQuad(i,j)
            enddo
          enddo
        endif
      enddo
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi(1:2),Nord(1:5),NoriE(1:4)
 7001   format('shape2DEQuad: Xi = ',2f8.3,/,
     .         'Norder  = ',4i2,2x,i2,/,
     .         'Norient = ',4i2)
        m=0
        do e=1,4
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7002) e
 7002       format('EDGE SHAPE FUNCTIONS = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapE(1:N,m),CurlE(m)
 7003         format('k = ',i3,' ShapE, CurlE = ',2e12.5,3x,e12.5)
            enddo
          endif
        enddo
        if ((ndofF(0)+ndofF(1)).gt.0) then
          write(*,7004)
 7004     format('FACE BUBBLES = ')
          do fam=0,1
            if (ndofF(fam).gt.0) then
              write(*,7005) fam
 7005         format('family = ',i2)
              do j=1,ndofF(fam)
                m=m+1
                write(*,7003) m,ShapE(1:2,m),CurlE(m)
              enddo
            endif
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DEQuad
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DVQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate quad H(div) shape functions and
c                         their divergences
c
c     arguments :
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order for the nodes (H1 sense)
c        NoriE          - edge orientations
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofV         - number of dof
c        ShapV          - values of shape functions
c        DivV           - divergences of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DVQuad(Xi,Nord,NoriE,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(5),NoriE(4),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: iprint,m,j,e,ndofE,nordF(2),ndofF(0:1)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapV(2,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: shapE(2,Nsize(2))

c
c  ...debugging flag
      iprint=0
c
c  ...compute H(curl) shape functions
c  ...remember that NrdofE = NrdofV, div(V) = curl(E)
      call shape2DEQuad(Xi,Nord,NoriE,Nsize, NrdofV,shapE,DivV)
c
c  ...'rotate' shape functions
      do m=1,NrdofV
        ShapV(1,m) = shapE(2,m)
        ShapV(2,m) = -shapE(1,m)
      end do
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi(1:2),Nord(1:5),NoriE(1:4)
 7001   format('shape2DVQuad: Xi = ',2f8.3,/,
     .         'Norder  = ',4i2,2x,i2,/,
     .         'Norient = ',4i2)
        m=0
        do e=1,4
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7002) e
 7002       format('EDGE SHAPE FUNCTIONS = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapV(1:2,m),DivV(m)
 7003         format('k = ',i3,' ShapV, DivV = ',2e12.5,3x,e12.5)
            enddo
          endif
        enddo
        call decod(Nord(5),MODORDER,2, nordF)
        ndofF(0) = nordF(1)*(nordF(2)-1)
        ndofF(1) = (nordF(1)-1)*nordF(2)
        if ((ndofF(0)+ndofF(1)).gt.0) then
          write(*,7004)
 7004     format('FACE BUBBLES = ')
          do j=1,ndofF(0)+ndofF(1)
            m=m+1
            write(*,7003) m,ShapV(1:2,m),DivV(m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DVQuad
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DQQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate quad L2 shape functions
c
c     arguments :
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order of face node (H1 sense)
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofQ         - number of dof
c        ShapQ          - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DQQuad(Xi,Nord,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(5),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: iprint,i,j,m,N,nordF(2),ndofF
      integer :: minI,minJ,maxI,maxJ
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Mu(2,0:1),DMu(2,2,0:1)
      double precision :: homP(2,0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineQuadrilateral(Xi, Mu,DMu)
c
c  ...order and dof
      call decod(Nord(5),MODORDER,2, nordF)
      ndofF = nordF(1)*nordF(2)
      if (ndofF.gt.0) then
c    ...local parameters (again)
        minI = 0
        minJ = 0
        maxI = nordF(1)-1
        maxJ = nordF(2)-1
c    ...construct the shape functions
        call HomLegendre(Mu(1,0:1),maxI, homP(1,minI:maxI))
        call HomLegendre(Mu(2,0:1),maxJ, homP(2,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
c
            ShapQ(m) = homP(1,i)*homP(2,j)
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi(1:2),Nord(5)
 7001   format('shape2DQQuad: Xi = ',2f8.3,/,
     .         'Norder  = ',i2)
        if (ndofF.gt.0) then
          write(*,7002)
 7002     format('FACE FUNCTIONS = ')
          do m=1,ndofF
            write(*,7003) m,ShapQ(m)
 7003       format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DQQuad
c




c Routines:
c  - shape2DHTri
c  - shape2DETri
c  - shape2DVTri
c  - shape2DQTri
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DHTri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate triangle H1 shape functions and 
c                         their gradient
c
c     arguments:
c
c     in:
c       X               - master element coordinates
c       Nord            - polynomial order for the nodes (H1 sense)
c       NoriE           - edge orientations
c       Nsize           - relevant sizes of local arrays
c
c     out:
c       NrdofH          - number of dof
c       ShapH           - values of the shape functions
c       GradH           - gradients of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DHTri(X,Nord,NoriE,Nsize, NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in)  :: Nord(4),NoriE(3),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: i,j,nij,m,v,e,N,nordE,ndofE,nordF,ndofF,iprint
      integer :: minI,minJ,minIJ,maxI,maxJ,maxIJ
      logical :: IdecE,IdecF
      double precision, intent(in)  :: X(2)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(2,Nsize(2))
      double precision :: Nu(0:2),DNu(2,0:2)
      double precision :: NubV(3),DNubV(3,2)
      double precision :: NupE(3,0:1),DNupE(3,2,0:1)
      double precision :: GNupE(0:1),GDNupE(2,0:1)
      double precision :: phiE(2:Nsize(1)),DphiE(2,2:Nsize(1))
      double precision :: phiTri(2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DphiTri(2,2:Nsize(1)-1,1:Nsize(1)-2)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...local parameters
      minI = 2; minJ = 1
      minIJ = minI+minJ
c
c  ...Define affine coordinates and gradients
      call AffineTriangle(X, Nu,DNu)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendTriV(Nu,DNu, NubV,DNubV)
      do v=1,3
        m=m+1
c
        ShapH(m)     = NubV(v)
        GradH(1:N,m) = DNubV(v,1:N)
      enddo
c
c  ...EDGE SHAPE FUNCTIONS
      call ProjectTriE(Nu,DNu, NupE,DNupE,IdecE)
c  ...loop over edges
      do e=1,3
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE-1
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE
c      ...orient
          call OrientE(NupE(e,0:1),DNupE(e,1:N,0:1),NoriE(e),N,
     .                                                    GNupE,GDNupE)
c      ...construct the shape functions
          call AncPhiE(GNupE,GDNupE,nordE,IdecE,N,
     .                            phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapH(m)     = phiE(i)
            GradH(1:N,m) = DphiE(1:N,i)
          enddo
        endif
      enddo
c
c  ...FACE BUBBLE FUNCTIONS
c  ...local parameters
      nordF = Nord(4)
      ndofF = (nordF-1)*(nordF-2)/2
      IdecF = .TRUE.
      if (ndofF.gt.0) then
c    ...local parameters (again)
        maxIJ = nordF
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
c    ...construct the shape functions
        call AncPhiTri(Nu,DNu,nordF,IdecF,N,
     .                                     phiTri(minI:maxI,minJ:maxJ),
     .                                DphiTri(1:N,minI:maxI,minJ:maxJ))
        do nij=minIJ,maxIJ
          do i=minI,nij-minJ
            j=nij-i
            m=m+1
c
            ShapH(m)     = phiTri(i,j)
            GradH(1:N,m) = DphiTri(1:N,i,j)
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) X(1:2),Nord(1:4),NoriE(1:3)
 7001   format('shape2DHTri: Xi = ',2f8.3,/,
     .         'Norder  = ',3i2,2x,i2,/,
     .         'Norient = ',3i2)
        write(*,7002)
 7002   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,3
          m=v
          write(*,7003) m,ShapH(m),GradH(1:2,m)
 7003     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,2e12.5)
        enddo
        do e=1,3
          ndofE = Nord(e)-1
          if (ndofE.gt.0) then
            write(*,7004) e
 7004       format('EDGE SHAPE FUNCTIONS = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapH(m),GradH(1:2,m)
            enddo
          endif
        enddo
        if (ndofF.gt.0) then
          write(*,7005)
 7005     format('FACE BUBBLES = ')
          do j=1,ndofF
            m=m+1
            write(*,7003) m,ShapH(m),GradH(1:2,m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DHTri
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DETri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate triangle H(curl) shape functions and
c                         their curls
c
c     arguments:
c
c     in:
c          X            - master triangle coordinates from (0,1)^2
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientations
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions
c          CurlE        - curls of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DETri(X,Nord,NoriE,Nsize, NrdofE,ShapE,CurlE)
c
      implicit none
      integer, intent(in)  :: Nord(4),NoriE(3),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: i,j,nij,m,v,e,N,nordE,ndofE,nordF,ndofF,iprint
      integer :: minI,minJ,minIJ,maxI,maxJ,maxIJ,abc(3),fam,famctr
      logical :: IdecE,IdecF
      double precision, intent(in)  :: X(2)
      double precision, intent(out) :: ShapE(2,Nsize(2))
      double precision, intent(out) :: CurlE(Nsize(2))
      double precision :: Nu(0:2),DNu(2,0:2)
      double precision :: NupE(3,0:1),DNupE(3,2,0:1)
      double precision :: GNupE(0:1),GDNupE(2,0:1)
      double precision :: EE(2,0:Nsize(1)-1),CurlEE(0:Nsize(1)-1)
      double precision :: ETri(2,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: CurlETri(0:Nsize(1)-2,1:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...local parameters
      minI = 0; minJ = 1
      minIJ = minI+minJ
c
c  ...Define affine coordinates and gradients
      call AffineTriangle(X, Nu,DNu)
c
c  ...EDGE SHAPE FUNCTIONS
      call ProjectTriE(Nu,DNu, NupE,DNupE,IdecE)
c  ...loop over edges
      do e=1,3
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE-1
c      ...orient first
          call OrientE(NupE(e,0:1),DNupE(e,1:N,0:1),NoriE(e),N,
     .                                                    GNupE,GDNupE)
c      ...construct the shape functions
          call AncEE(GNupE,GDNupE,nordE,IdecE,N,
     .                             EE(1:N,minI:maxI),CurlEE(minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = EE(1:N,i)
            CurlE(m)     = CurlEE(i)
          enddo
        endif
      enddo
c
c  ...FACE BUBBLE FUNCTIONS
c  ...local parameters
      nordF = Nord(4)
      ndofF = nordF*(nordF-1)/2
      IdecF = .TRUE.
      if (ndofF.gt.0) then
c    ...local parameters (again)
        maxIJ = nordF-1
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
c    ...loop over families
        famctr=m
        do fam=0,1
          m=famctr+fam-1
          abc = cshift((/0,1,2/),fam)
c      ...construct the shape functions
          call AncETri(Nu(abc),DNu(1:N,abc),nordF,IdecF,N,
     .                                   ETri(1:N,minI:maxI,minJ:maxJ),
     .                                   CurlETri(minI:maxI,minJ:maxJ))
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+2
c
              ShapE(1:N,m) = ETri(1:N,i,j)
              CurlE(m)     = CurlETri(i,j)
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) X(1:2),Nord(1:4),NoriE(1:3)
 7001   format('shape2DETri: Xi = ',2f8.3,/,
     .         'Norder  = ',3i2,2x,i2,/,
     .         'Norient = ',3i2)
        m=0
        do e=1,3
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7002) e
 7002       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapE(1:2,m),CurlE(m)
 7003         format('k = ',i3,' ShapE, CurlE = ',2e12.5,3x,e12.5)
            enddo
          endif
        enddo
        if (ndofF.gt.0) then
          write(*,7004)
 7004     format('FACE BUBBLES = ')
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            write(*,7005) fam
 7005       format('family = ',i2)
            do j=1,ndofF
              m=m+2
              write(*,7003) m,ShapE(1:2,m),CurlE(m)
            enddo
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DETri
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DVTri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate triangle H(div) shape functions and
c                         their divergences
c
c     arguments :
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order for the nodes (H1 sense)
c        NoriE          - edge orientations
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofV         - number of dof
c        ShapV          - values of shape functions
c        DivV           - divergences of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DVTri(X,Nord,NoriE,Nsize, NrdofV,ShapV,DivV)
c
      implicit none
      integer, intent(in)  :: Nord(4),NoriE(3),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: iprint,m,j,e,ndofE,nordF,ndofF,famctr,fam
      double precision, intent(in)  :: X(2)
      double precision, intent(out) :: ShapV(2,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: shapE(2,Nsize(2))

c
c  ...debugging flag
      iprint=0
c
c  ...compute H(curl) shape functions
c  ...remember that NrdofE = NrdofV, div(V) = curl(E)
      call shape2DETri(X,Nord,NoriE,Nsize, NrdofV,shapE,DivV)
c
c  ...'rotate' shape functions
      do m=1,NrdofV
        ShapV(1,m) = shapE(2,m)
        ShapV(2,m) = -shapE(1,m)
      end do
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) X(1:2),Nord(1:4),NoriE(1:3)
 7001   format('shape2DVTri: Xi = ',2f8.3,/,
     .         'Norder  = ',3i2,2x,i2,/,
     .         'Norient = ',3i2)
        m=0
        do e=1,3
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7002) e
 7002       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapV(1:2,m),DivV(m)
 7003         format('k = ',i3,' ShapV, DivV = ',2e12.5,3x,e12.5)
            enddo
          endif
        enddo
        nordF = Nord(4)
        ndofF = nordF*(nordF-1)/2
        if (ndofF.gt.0) then
          write(*,7004)
 7004     format('FACE BUBBLES = ')
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            write(*,7005) fam
 7005       format('family = ',i2)
            do j=1,ndofF
              m=m+2
              write(*,7003) m,ShapV(1:2,m),DivV(m)
            enddo
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DVTri
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape2DQTri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - evaluate triangle L2 shape functions
c
c     arguments :
c
c     in:
c        Xi             - master element coordinates
c        Nord           - polynomial order of face node (H1 sense)
c        Nsize          - relevant sizes of local arrays
c
c     out:
c        NrdofQ         - number of dof
c        ShapQ          - values of shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape2DQTri(X,Nord,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: Nord(4),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: iprint,i,j,nij,m,N,ndofF
      integer :: minalpha,minI,minJ,minIJ,maxI,maxJ,maxIJ
      double precision, intent(in)  :: X(2)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Nu(0:2),DNu(2,0:2)
      double precision :: homP(0:Nsize(1)-1)
      double precision :: homPal(0:Nsize(1)-1,0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=2
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineTriangle(X, Nu,DNu)
c
c  ...order and dof
      ndofF = (Nord(4)+1)*Nord(4)/2
      if (ndofF.gt.0) then
c
c    ...local parameters
        minI = 0; minJ = 0
        minIJ = minI+minJ
        maxIJ = Nord(4)-1
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
        minalpha = 2*minI+1
c    ...construct shape functions with homogenized Legendre and Jacobi
c    ...polynomials: homP and homPal respectively
        call HomLegendre(Nu(0:1),maxI, homP(minI:maxI))
        call HomJacobi((/Nu(0)+Nu(1),Nu(2)/),maxJ,minalpha,
     .                                     homPal(minI:maxI,minJ:maxJ))
c    ...construct the shape functions
        do nij=minIJ,maxIJ
          do i=minI,nij-minJ
            j=nij-i
            m=m+1
c
            ShapQ(m) = homP(i)*homPal(i,j)
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7002) X(1:2),Nord(4)
 7002   format('shape2DQTri: Xi = ',2f8.3,/,
     .         'Norder  = ',i2)
        if (ndofF.gt.0) then
          write(*,7003)
 7003     format('FACE FUNCTIONS = ')
          do m=1,ndofF
            write(*,7004) m,ShapQ(m)
 7004       format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape2DQTri
c











c Routines:
c  - AffineSegment
c  - AffineQuadrilateral
c  - AffineTriangle
c  - AffineHexahedron
c  - AffineTetrahedron
c  - AffinePrism
c  - AffinePyramid
c----------------------------------------------------------------------
c  Define relevant affine coordinates for each element
c  People who want different master element geometries only need to
c  modify this file.
c----------------------------------------------------------------------
      subroutine AffineSegment(Xi, Mu,DMu)
c
      implicit none
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: Mu(0:1),DMu(0:1)
c
c  ...Define affine coordinates and their gradients
      Mu(0)  = 1.d0-Xi; Mu(1)  = Xi
      DMu(0) = -1.d0;   DMu(1) = 1.d0
c
      end subroutine AffineSegment
c----------------------------------------------------------------------
      subroutine AffineQuadrilateral(Xi, Mu,DMu)
c
      implicit none
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: Mu(1:2,0:1),DMu(1:2,1:2,0:1)
c
c  ...Define affine coordinates
      Mu(1,0) = 1.d0-Xi(1); Mu(1,1) = Xi(1)
      Mu(2,0) = 1.d0-Xi(2); Mu(2,1) = Xi(2)
c  ...and their gradients
      DMu(1:2,1:2,0:1) = 0.d0
      DMu(1,1,0) = -1.d0; DMu(1,1,1) = 1.d0
      DMu(2,2,0) = -1.d0; DMu(2,2,1) = 1.d0
c
      end subroutine AffineQuadrilateral
c----------------------------------------------------------------------
      subroutine AffineTriangle(X, Nu,DNu)
c
      implicit none
      double precision, intent(in)  :: X(2)
      double precision, intent(out) :: Nu(0:2),DNu(1:2,0:2)
c
c  ...Define affine coordinates
      Nu(0) = 1.d0-X(1)-X(2); Nu(1) = X(1); Nu(2) = X(2)
c  ...and their gradients
      DNu(1,0) = -1.d0;  DNu(1,1) = 1.d0; DNu(1,2) = 0.d0
      DNu(2,0) = -1.d0;  DNu(2,1) = 0.d0; DNu(2,2) = 1.d0
c
      end subroutine AffineTriangle
c----------------------------------------------------------------------
      subroutine AffineHexahedron(Xi, Mu,DMu)
c
      implicit none
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
c
c  ...Define affine coordinates
      Mu(1,0) = 1.d0-Xi(1); Mu(1,1) = Xi(1)
      Mu(2,0) = 1.d0-Xi(2); Mu(2,1) = Xi(2)
      Mu(3,0) = 1.d0-Xi(3); Mu(3,1) = Xi(3)
c  ...and their gradients
      DMu(1:3,1:3,0:1) = 0.d0
      DMu(1,1,0) = -1.d0; DMu(1,1,1) = 1.d0
      DMu(2,2,0) = -1.d0; DMu(2,2,1) = 1.d0
      DMu(3,3,0) = -1.d0; DMu(3,3,1) = 1.d0
c
      end subroutine AffineHexahedron
c----------------------------------------------------------------------
      subroutine AffineTetrahedron(X, Lam,DLam)
c
      implicit none
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: Lam(0:3),DLam(1:3,0:3)
c
c  ...Define affine coordinates
      Lam(0) = 1.d0-X(1)-X(2)-X(3); Lam(1) = X(1)
      Lam(2) = X(2);                Lam(3) = X(3)
c  ...and their gradients
      DLam(1:3,0:3) = 0.d0
      DLam(1,0) = -1.d0;  DLam(1,1) = 1.d0
      DLam(2,0) = -1.d0;  DLam(2,2) = 1.d0
      DLam(3,0) = -1.d0;  DLam(3,3) = 1.d0
c
      end subroutine AffineTetrahedron
c----------------------------------------------------------------------
      subroutine AffinePrism(X, Mu,DMu,Nu,DNu)
c
      implicit none
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(out) :: Nu(0:2),DNu(1:3,0:2)
c
c  ...Define triangle affine coordinates
      Nu(0) = 1.d0-X(1)-X(2); Nu(1) = X(1); Nu(2) = X(2)
c  ...and their gradients
      DNu(1:3,0:2) = 0.d0
      DNu(1,0) = -1.d0;  DNu(1,1) = 1.d0
      DNu(2,0) = -1.d0;  DNu(2,2) = 1.d0
c  ...Define segment affine coordinates
      Mu(0) = 1.d0-X(3); Mu(1) = X(3)
c  ...and their gradients
      DMu(1:3,0:1) = 0.d0
      DMu(3,0) = -1.d0;  DMu(3,1) = 1.d0
c
      end subroutine AffinePrism
c----------------------------------------------------------------------
      subroutine AffinePyramid(Xi, Lam,DLam,Mu,DMu,Nu,DNu,MuZ,DMuZ)
c
      implicit none
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: Lam(1:5),DLam(1:3,1:5)
      double precision, intent(out) :: Mu(1:2,0:1),DMu(1:3,1:2,0:1)
      double precision, intent(out) :: Nu(1:2,0:2),DNu(1:3,1:2,0:2)
      double precision, intent(out) :: MuZ(0:1),DMuZ(1:3,0:1)
      double precision :: zeta, eps
c
      eps = 1.0d-12
c
      zeta = Xi(3)
c  ...First define the two sets of triangle affine coordinates
      Nu(1,0) = 1.d0-Xi(1)-zeta; Nu(1,1) = Xi(1); Nu(1,2) = zeta
      Nu(2,0) = 1.d0-Xi(2)-zeta; Nu(2,1) = Xi(2); Nu(2,2) = zeta
c  ...and their gradients
      DNu(1:3,1:2,0:2) = 0.d0
      DNu(1,1,0) = -1.d0;  DNu(1,1,1) = 1.d0
      DNu(3,1,0) = -1.d0;  DNu(3,1,2) = 1.d0
      DNu(2,2,0) = -1.d0;  DNu(2,2,1) = 1.d0
      DNu(3,2,0) = -1.d0;  DNu(3,2,2) = 1.d0
c
c  ...Define segment affine coordinates over the height
      MuZ(0) = 1.d0-zeta; MuZ(1) = zeta
c  ...Don't divide by zero
      if (abs(MuZ(0)) < eps)  then
        MuZ(0) = 1.d0-eps; MuZ(1) = eps
      endif
c  ...and their gradients
      DMuZ(1:3,0:1) = 0.d0
      DMuZ(3,0) = -1.d0;  DMuZ(3,1) = 1.d0
c
c  ...Next the two sets of scaled segment affine coordinates
      Mu(1,0) = 1.d0-Xi(1)/MuZ(0); Mu(1,1) = Xi(1)/MuZ(0)
      Mu(2,0) = 1.d0-Xi(2)/MuZ(0); Mu(2,1) = Xi(2)/MuZ(0)
c  ...and their gradients
      DMu(1:3,1:2,0:1) = 0.d0
      DMu(1,1,0) = -1.d0/MuZ(0);     DMu(1,1,1) = 1.d0/MuZ(0)
      DMu(3,1,0) = -Xi(1)/MuZ(0)**2; DMu(3,1,1) = Xi(1)/MuZ(0)**2
      DMu(2,2,0) = -1.d0/MuZ(0);     DMu(2,2,1) = 1.d0/MuZ(0)
      DMu(3,2,0) = -Xi(2)/MuZ(0)**2; DMu(3,2,1) = Xi(2)/MuZ(0)**2
c
c  ...Finally the pyramid affine-like coordinates
      Lam(1) = Nu(1,0)*Mu(2,0)
      Lam(2) = Nu(2,0)*Mu(1,1)
      Lam(3) = Nu(1,1)*Mu(2,1)
      Lam(4) = Nu(2,1)*Mu(1,0)
      Lam(5) = zeta
c  ...and their gradients
      DLam(1:3,1) = Nu(1,0)*DMu(1:3,2,0)+DNu(1:3,1,0)*Mu(2,0)
      DLam(1:3,2) = Nu(2,0)*DMu(1:3,1,1)+DNu(1:3,2,0)*Mu(1,1)
      DLam(1:3,3) = Nu(1,1)*DMu(1:3,2,1)+DNu(1:3,1,1)*Mu(2,1)
      DLam(1:3,4) = Nu(2,1)*DMu(1:3,1,0)+DNu(1:3,2,1)*Mu(1,0)
      DLam(1,5) = 0.d0; DLam(2,5) = 0.d0; DLam(3,5) = 1.d0
c
      end subroutine AffinePyramid
c----------------------------------------------------------------------












c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                                  EDGES
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c
c     routine name      - AncPhiE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute edge H1 ancillary functions and
c                         their gradients
c
c     arguments:
c
c     in:
c             S         - (s0,s1) affine coordinates associated to edge
c             DS        - gradients of S in R^N
c             Nord      - polynomial order
c             Idec      - Binary flag:
c                         = FALSE  s0+s1 != 1
c                         = TRUE   s0+s1  = 1
c             N         - spatial dimension
c
c     out:
c             PhiE      - values of edge H1 ancillary functions
c             DPhiE     - gradients of edge H1 ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncPhiE(S,DS,Nord,Idec,N, PhiE,DPhiE)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:1),DS(1:N,0:1)
      double precision, intent(out) ::   PhiE(2:Nord),DPhiE(1:N,2:Nord)
      integer ::                                              minI,maxI
c
c  ...local parameters
      minI = 2
      maxI = Nord
c
      if (N.lt.1) then
        write(*,7001) N
 7001   format('AncPhiE: N = ',i2)
      endif
c
c  ...these are precisely the homogenized Legendre polynomials
      call HomILegendre(S,DS,Nord,Idec,N, PhiE,DPhiE)
c
      end subroutine AncPhiE
c
c----------------------------------------------------------------------
c
c     routine name      - AncEE
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute edge Hcurl ancillary functions and
c                         their curls
c
c     arguments:
c
c     in:
c             S         - (s0,s1) affine coordinates associated to edge
c             DS        - derivatives of S in R^N
c             Nord      - polynomial order
c             Idec      - Binary flag:
c                         = FALSE  s0+s1 != 1
c                         = TRUE   s0+s1  = 1
c             N         - spatial dimension
c
c     out:
c             EE        - edge Hcurl ancillary functions
c             CurlEE    - curls of edge Hcurl ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncEE(S,DS,Nord,Idec,N, EE,CurlEE)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:1),DS(1:N,0:1)
      double precision, intent(out) ::                 EE(1:N,0:Nord-1),
     .                                         CurlEE(1:2*N-3,0:Nord-1)
      integer ::                                      minI,maxI,Ncurl,i
      double precision ::    homP(0:Nord-1),whiE(1:N),curlwhiE(1:2*N-3)
c
c  ...local parameters
      minI = 0
      maxI = Nord-1
      Ncurl = 2*N-3
c
      if (N.lt.2) then
        write(*,7001) N
 7001   format('AncEE: N = ',i2)
      endif
c
c  ...extract homogenized Legendre polyomials first
      call HomLegendre(S,maxI, homP)
c
c  ...simplified case
      if (Idec) then
        do i=minI,maxI
          EE(1:N,i) = homP(i)*DS(1:N,1)
        enddo
c    ...no need to compute Whitney function or curl
        CurlEE(1:Ncurl,minI:maxI) = 0.d0
c
c  ...in general
      else
c    ...lowest order Whitney function and its curl
        whiE = S(0)*DS(1:N,1)-S(1)*DS(1:N,0)
        call cross(N,DS(1:N,0),DS(1:N,1), curlwhiE)
c    ...now construct the higher order elements
        do i=minI,maxI
          EE(1:N,i) = homP(i)*whiE
          CurlEE(1:Ncurl,i) = (i+2)*homP(i)*curlwhiE
        enddo
      endif
c
      end subroutine AncEE
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                         QUADRILATERAL FACES
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c
c     routine name      - AncPhiQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute quadrilateral face H1 ancillary
c                         functions and their gradients
c
c     arguments:
c
c     in:
c             ST       - affine coordinates associated to face
c                        2x2 matrix [s0,s1;t0,t1]
c             DST      - gradients of ST
c             Nord     - (NordS,NordT) vector polynomial order
c             Idec     - (IdecS,IdecT) vector binary flag:
c                        IdecS = FALSE if s0+s1 != 1
c                        IdecS = TRUE  if s0+s1  = 1, same with IdecT
c             N        - spatial dimension
c
c     out:
c             PhiQuad  - quad H1 ancillary functions
c             DPhiQuad - gradients of quad H1 ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncPhiQuad(ST,DST,Nord,Idec,N, PhiQuad,DPhiQuad)
c
      implicit none
      logical,          intent(in)  ::                          Idec(2)
      integer,          intent(in)  ::                        Nord(2),N
      double precision, intent(in)  ::     ST(1:2,0:1),DST(1:N,1:2,0:1)
      double precision, intent(out) ::     PhiQuad(2:Nord(1),2:Nord(2)),
     .                                DPhiQuad(1:N,2:Nord(1),2:Nord(2))
      integer ::                                minI,maxI,minJ,maxJ,i,j
      double precision ::        phiES(2:Nord(1)),DphiES(1:N,2:Nord(1)),
     .                           phiET(2:Nord(2)),DphiET(1:N,2:Nord(2))
c
c  ...local parameters
      minI = 2; maxI = Nord(1)
      minJ = 2; maxJ = Nord(2)
c
      if (N.lt.2) then
        write(*,7001) N
 7001   format('AncPhiQuad: N = ',i2)
      endif
c
c  ...get PhiE for each coordinate pair
      call AncPhiE(ST(1,0:1),DST(1:N,1,0:1),Nord(1),Idec(1),N,
     .          phiES,DphiES)
      call AncPhiE(ST(2,0:1),DST(1:N,2,0:1),Nord(2),Idec(2),N,
     .          phiET,DphiET)
c
c  ...the final result is the product of the two phiE
      do j=minJ,maxJ
        do i=minI,maxI
          PhiQuad(i,j) = phiES(i)*phiET(j)
          DphiQuad(1:N,i,j) = phiES(i)*DphiET(1:N,j)
     .                      + phiET(j)*DphiES(1:N,i)
        enddo
      enddo
c
      end subroutine AncPhiQuad
c
c----------------------------------------------------------------------
c
c     routine name      - AncEQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute quadrilateral face Hcurl ancillary
c                         functions and their curls
c
c     arguments:
c
c     in:
c             ST       - affine coordinates associated to face
c                        2x2 matrix [s0,s1;t0,t1]
c             DST      - gradients of ST
c             Nord     - (NordS,NordT) vector polynomial order
c             Idec     - (IdecS,IdecT) vector binary flag:
c                        IdecS = FALSE if s0+s1 != 1
c                        IdecS = TRUE  if s0+s1  = 1, same with IdecT
c             N        - spatial dimension
c
c     out:
c             EQuad     - quad Hcurl ancillary functions
c             CurlEQuad - curls of quad Hcurl ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncEQuad(ST,DST,Nord,Idec,N, EQuad,CurlEQuad)
c
      implicit none
      logical,          intent(in)  ::                          Idec(2)
      integer,          intent(in)  ::                        Nord(2),N
      double precision, intent(in)  ::     ST(1:2,0:1),DST(1:N,1:2,0:1)
      double precision, intent(out) :: EQuad(1:N,0:Nord(1)-1,2:Nord(2)),
     .                         CurlEQuad(1:2*N-3,0:Nord(1)-1,2:Nord(2))
      integer ::                          minI,maxI,minJ,maxJ,Ncurl,i,j
      double precision ::         S(0:1),DS(1:N,0:1),T(0:1),DT(1:N,0:1),
     .                EES(1:N,0:Nord(1)-1),curlEES(1:2*N-3,0:Nord(1)-1),
     .       phiET(2:Nord(2)),DphiET(1:N,2:Nord(2)),DphiETxEES(1:2*N-3)
c
c  ...local parameters
      minI = 0; maxI = Nord(1)-1
      minJ = 2; maxJ = Nord(2)
      Ncurl = 2*N-3
c
      if (N.lt.2) then
        write(*,7001) N
 7001   format('AncEQuad: N = ',i2)
      endif
c
      S = ST(1,0:1); DS = DST(1:N,1,0:1)
      T = ST(2,0:1); DT = DST(1:N,2,0:1)
c
      call AncEE(S,DS,Nord(1),Idec(1),N, EES,curlEES)
      call AncphiE(T,DT,Nord(2),Idec(2),N, phiET,DphiET)
c
      do j=minJ,maxJ
        do i=minI,maxI
          EQuad(1:N,i,j) = EES(1:N,i)*phiET(j)
c
          call cross(N,DphiET(1:N,j),EES(1:N,i), DphiETxEES)
c
          CurlEQuad(1:Ncurl,i,j) = curlEES(1:Ncurl,i)*phiET(j)
     .                           + DphiETxEES(1:Ncurl)
        enddo
      enddo

      end subroutine AncEQuad
c
c----------------------------------------------------------------------
c
c     routine name      - AncVQuad
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute quadrilateral face Hdiv ancillary
c                         functions and their divergences
c
c     arguments:
c
c     in:
c             ST       - affine coordinates associated to face
c                        2x2 matrix [s0,s1;t0,t1]
c             DST      - gradients of ST
c             Nord     - (NordS,NordT) vector polynomial order
c             Idec     - (IdecS,IdecT) vector binary flag:
c                        IdecS = FALSE if s0+s1 != 1
c                        IdecS = TRUE  if s0+s1  = 1, same with IdecT
c             N        - spatial dimension
c
c     out:
c             VQuad    - quad Hdiv ancillary functions
c             DivVQuad - divs of quad Hdiv ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncVQuad(ST,DST,Nord,Idec,N, VQuad,DivVQuad)
c
      implicit none
      logical,          intent(in)  ::                          Idec(2)
      integer,          intent(in)  ::                        Nord(2),N
      double precision, intent(in)  ::     ST(1:2,0:1),DST(1:N,1:2,0:1)
      double precision, intent(out) ::
     .                               VQuad(1:N,0:Nord(1)-1,0:Nord(2)-1),
     .                                DivVQuad(0:Nord(1)-1,0:Nord(2)-1)
      integer ::                          minI,maxI,minJ,maxJ,Ncurl,i,j
      double precision ::         S(0:1),T(0:1),DS(1:N,0:1),DT(1:N,0:1),
     .          EES(1:N,0:Nord(1)-1),curlEES(1:2*N-3,0:Nord(1)-1),prod1,
     .          EET(1:N,0:Nord(2)-1),curlEET(1:2*N-3,0:Nord(2)-1),prod2
c
c  ...local parameters
      minI = 0; maxI = Nord(1)-1
      minJ = 0; maxJ = Nord(2)-1
      Ncurl = 2*N-3
c
      if (N.lt.3) then
        write(*,7001) N
 7001   format('AncVQuad: N = ',i2)
      endif
c
      S = ST(1,0:1); DS = DST(1:N,1,0:1)
      T = ST(2,0:1); DT = DST(1:N,2,0:1)

      call AncEE(S,DS,Nord(1),Idec(1),N, EES,curlEES)
      call AncEE(T,DT,Nord(2),Idec(2),N, EET,curlEET)
c
c      ...slight speedup when Idec=(.TRUE.,.TRUE.)
      if (Idec(1).and.Idec(2)) then
        do j=minJ,maxJ
          do i=minI,maxI
            call cross(N,EES(1:N,i),EET(1:N,j), VQuad(1:N,i,j))
          enddo
        enddo
        DivVQuad(minI:maxI,minJ:maxJ) = 0.d0
      else
        do j=minJ,maxJ
          do i=minI,maxI
            call cross(N,EES(1:N,i),EET(1:N,j), VQuad(1:N,i,j))
c
            call dot_product(EET(1:N,j),curlEES(1:N,i), prod1)
            call dot_product(EES(1:N,i),curlEET(1:N,j), prod2)
c
            DivVQuad(i,j) = prod1-prod2
          enddo
        enddo
      endif
c
      end subroutine AncVQuad
c
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c                           TRIANGULAR FACES
c
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c
c----------------------------------------------------------------------
c
c     routine name      - AncPhiTri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute triangle face H1 ancillary
c                         functions and their gradients
c
c     arguments:
c
c     in:
c             S        - (s0,s1,s2) affine coordinates associated to
c                        triangle face
c             DS       - derivatives of S0,S1,S2
c             Nord     - polynomial order
c             Idec     - Binary flag:
c                        = FALSE s0+s1+s2 != 1
c                        = TRUE  s0+s1+s2  = 1
c             N        - spatial dimension
c
c     out:
c             PhiTri   - triangle H1 ancillary functions
c             DPhiTri  - grads of triangle H1 ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncPhiTri(S,DS,Nord,Idec,N, PhiTri,DPhiTri)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:2),DS(1:N,0:2)
      double precision, intent(out) ::        PhiTri(2:Nord-1,1:Nord-2),
     .                                   DPhiTri(1:N,2:Nord-1,1:Nord-2)
      logical ::                                                  IdecE
      integer ::       minI,maxI,minJ,maxJ,minIJ,maxIJ,minalpha,i,j,nij
      double precision ::                          sL(0:1),DsL(1:N,0:1),
     .     phiE(2:Nord-1),DphiE(1:N,2:Nord-1),homLal(2:Nord-1,1:Nord-2),
     .                                   DhomLal(1:N,2:Nord-1,1:Nord-2)
c
c  ...local parameters
      minI = 2; maxI = Nord-1
      minJ = 1; maxJ = Nord-2
      minIJ = minI+minJ; maxIJ = Nord
      minalpha = 2*minI
      IdecE = .FALSE.
c
      if (N.lt.2) then
        write(*,7001) N
 7001   format('AncPhiTri: N = ',i2)
      endif
c
c  ...get PhiE - this is never a simplified case (IdecE=0)
      call AncPhiE(S(0:1),DS(1:N,0:1),Nord-minJ,IdecE,N, phiE,DphiE)
c
c  ...get homogenized Jacobi polynomials, homLal, and gradients
      sL(0) = S(0)+S(1); sL(1) = S(2)
      DsL(1:N,0) = DS(1:N,0)+DS(1:N,1)
      DsL(1:N,1) = DS(1:N,2)
      call HomIJacobi(sL,DsL,maxJ,minalpha,Idec,N, homLal,DhomLal)
c
c  ...simply complete the required information
      do nij=minIJ,maxIJ
        do i=minI,nij-minJ
          j=nij-i
          PhiTri(i,j) = phiE(i)*homLal(i,j)
          DPhiTri(1:N,i,j) = homLal(i,j)*DphiE(1:N,i)
     .                        + phiE(i)*DhomLal(1:N,i,j)
        enddo
      enddo
c
      end subroutine AncPhiTri
c
c----------------------------------------------------------------------
c
c     routine name      - AncETri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute triangle face Hcurl ancillary
c                         functions and their curls
c
c     arguments:
c
c     in:
c             S        - (s0,s1,s2) affine coordinates associated to
c                        triangle face
c             DS       - derivatives of S0,S1,S2
c             Nord     - polynomial order
c             Idec     - Binary flag:
c                        = FALSE s0+s1+s2 != 1
c                        = TRUE  s0+s1+s2  = 1
c             N        - spatial dimension
c
c     out:
c             ETri     - triangle Hcurl ancillary functions
c             CurlETri - curls of triangle Hcurl ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncETri(S,DS,Nord,Idec,N, ETri,CurlETri)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:2),DS(1:N,0:2)
      double precision, intent(out) ::      ETri(1:N,0:Nord-2,1:Nord-1),
     .                              CurlETri(1:2*N-3,0:Nord-2,1:Nord-1)
      logical ::                                                  IdecE
      integer :: minI,maxI,minJ,maxJ,minIJ,maxIJ,minalpha,Ncurl,i,j,nij
      double precision ::     EE(1:N,0:Nord-2),curlEE(1:2*N-3,0:Nord-2),
     .                   sL(0:1),DsL(1:N,0:1),homLal(0:Nord-2,1:Nord-1),
     .               DhomLal(1:N,0:Nord-2,1:Nord-1),DhomLalxEE(1:2*N-3)
c
c  ...local parameters
      minI = 0; maxI = Nord-2
      minJ = 1; maxJ = Nord-1
      minIJ = minI+minJ; maxIJ = Nord-1
      minalpha = 2*minI+1
      Ncurl = 2*N-3
      IdecE = .FALSE.
c
      if (N.lt.2) then
        write(*,7001) N
 7001   format('AncETri: N = ',i2)
      endif
c
c  ...get EE - this is never a simplified case (IdecE=0)
      call AncEE(S(0:1),DS(1:N,0:1),Nord-minJ,IdecE,N, EE,curlEE)
c
c  ...get homogenized Integrated Jacobi polynomials, homLal, and gradients
      sL(0) = S(0)+S(1); sL(1) = S(2)
      DsL(1:N,0) = DS(1:N,0)+DS(1:N,1)
      DsL(1:N,1) = DS(1:N,2)
      call HomIJacobi(sL,DsL,maxJ,minalpha,Idec,N, homLal,DhomLal)
c
c  ...simply complete the required information
      do nij=minIJ,maxIJ
        do i=minI,nij-minJ
          j=nij-i
            ETri(1:N,i,j) = EE(1:N,i)*homLal(i,j)
c
            call cross(N,DhomLal(1:N,i,j),EE(1:N,i), DhomLalxEE)
c
            CurlETri(1:Ncurl,i,j) = homLal(i,j)*curlEE(1:Ncurl,i)
     .                            + DhomLalxEE
        enddo
      enddo
c
      end subroutine AncETri
c
c----------------------------------------------------------------------
c
c     routine name      - AncVTri
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - compute triangle face Hcurl ancillary
c                         functions and their curls (family II)
c
c     arguments:
c
c     in:
c             S        - (s0,s1,s2) affine coordinates associated to
c                        triangle face
c             DS       - derivatives of S0,S1,S2
c             Nord     - polynomial order
c             Idec     - Binary flag:
c                        = FALSE s0+s1+s2 != 1
c                        = TRUE  s0+s1+s2  = 1
c             N        - spatial dimension
c
c     out:
c             VTri     - triangle Hdiv ancillary functions
c             DivVTri  - divs of triangle Hdiv ancillary functions
c
c----------------------------------------------------------------------
c
      subroutine AncVTri(S,DS,Nord,Idec,N, VTri,DivVTri)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:2),DS(1:N,0:2)
      double precision, intent(out) ::      VTri(1:N,0:Nord-1,0:Nord-1),
     .                                       DivVTri(0:Nord-1,0:Nord-1)
      integer ::       minI,maxI,minJ,maxJ,minIJ,maxIJ,minalpha,i,j,nij
      double precision ::      homP(0:Nord-1),homPal(0:Nord-1,0:Nord-1),
     .        DS0xDS1(N),DS1xDS2(N),DS2xDS0(N),V00(N),tripleprod,psiTri
c
c  ...local parameters
      minI = 0; maxI = Nord-1
      minJ = 0; maxJ = Nord-1
      minIJ = minI+minJ; maxIJ = Nord-1
      minalpha = 2*minI+1
c
      if (N.lt.3) then
        write(*,7001) N
 7001   format('AncVTri: N = ',i2)
      endif
c
c  ...get homogenized Legendre polynomials, homP
      call HomLegendre(S(0:1),Nord-1-minJ, homP)
c
c  ...get homogenized Jacobi polynomials, homPal
      call HomJacobi((/S(0)+S(1),S(2)/),maxJ,minalpha, homPal)
c
c  ...simplified case
      if (Idec) then
c    ...construct V00
        call cross(N,DS(1:N,1),DS(1:N,2), V00)
c    ...loop
        do nij=minIJ,maxIJ
          do i=minI,nij-minJ
            j=nij-i
            VTri(1:N,i,j) = homP(i)*homPal(i,j)*V00(1:N)
          enddo
        enddo
c
        DivVTri = 0.d0
c
c  ...general case
      else
c    ...construct V00
        call cross(N,DS(1:N,0),DS(1:N,1), DS0xDS1)
        call cross(N,DS(1:N,1),DS(1:N,2), DS1xDS2)
        call cross(N,DS(1:N,2),DS(1:N,0), DS2xDS0)
        V00 = S(0)*DS1xDS2+S(1)*DS2xDS0+S(2)*DS0xDS1
c    ...loop
        do nij=minIJ,maxIJ
          do i=minI,nij-minJ
            j=nij-i
            psiTri = homP(i)*homPal(i,j)
c
            VTri(1:N,i,j) = psiTri*V00
            DivVTri(i,j)  = (nij+3)*psiTri
          enddo
        enddo
c
        call dot_product(DS(1:N,0),DS1xDS2, tripleprod)
c
        DivVTri = DivVTri*tripleprod
      endif
c
      end subroutine AncVTri
c











c Routines:
c  - BlendSegV
c  - BlendQuadV
c  - BlendProjectQuadE
c  - BlendTriV
c  - ProjectTriE
c  - BlendHexaV
c  - BlendProjectHexaE
c  - BlendProjectHexaF
c  - BlendTetV
c  - ProjectTetE
c  - ProjectTetF
c  - BlendPrisV
c  - BlendProjectPrisME
c  - BlendProjectPrisQE
c  - BlendProjectPrisTF
c  - ProjectPrisQF
c  - BlendPyraV
c  - BlendProjectPyraME
c  - ProjectPyraTE
c  - ProjectPyraQF
c  - BlendProjectPyraTF
c  - ProjectPyraLamTF
c----------------------------------------------------------------------
c  b=blending p=projecting V=vertex E=edge F=face M=mixed T=tri Q=quad
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c  Data consistent with module element_data:
c     numbering of topological entities - vertices, edges, faces
c     local orientations of edges and faces
c----------------------------------------------------------------------
      subroutine BlendSegV(Mu,DMu, MubV,DMubV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Mu(0:1),DMu(0:1)
      double precision, intent(out) :: MubV(1:2),DMubV(1:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c         V=((0),(1))=>(v0,v1)
c
      N=1
c
c  ...2 vertices, each with one blending function
c
c  ...v=1 --> v0=(0)
      v=1
      MubV(v) = Mu(0); DMubV(v) = DMu(0)
c  ...v=2 --> v1=(1)
      v=2
      MubV(v) = Mu(1); DMubV(v) = DMu(1)
c
      end subroutine BlendSegV
c----------------------------------------------------------------------
      subroutine BlendQuadV(Mu,DMu, MubV,DMubV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Mu(1:2,0:1),DMu(1:2,1:2,0:1)
      double precision, intent(out) :: MubV(1:4,1:2),DMubV(1:4,1:2,1:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c         V=((0,0),(1,0),(1,1),(0,1))=>(v1,v2,v3,v4)
c
      N=2
c
c  ...4 vertices, each with two blending functions
c
c  ...v=1 --> v1=(0,0)
      v=1
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
c  ...v=2 --> v2=(1,0)
      v=2
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
c  ...v=3 --> v3=(1,1)
      v=3
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
c  ...v=4 --> v4=(0,1)
      v=4
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
c
      end subroutine BlendQuadV
c----------------------------------------------------------------------
      subroutine BlendProjectQuadE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecE
      double precision, intent(in)  :: Mu(1:2,0:1),DMu(1:2,1:2,0:1)
      double precision, intent(out) :: MubE(1:4),DMubE(1:4,1:2)
      double precision, intent(out) :: MupE(1:4,0:1),DMupE(1:4,1:2,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c         V=((0,0),(1,0),(1,1),(0,1))=>(v1,v2,v3,v4)
c          E=>((v1->v2),(v2->v3),(v4->v3),(v1->v4))
c
      N=2
c
c  ...4 edges, each with a blending function and a locally oriented
c     pair representing a projection
c
c  ...e=1 --> edge12 with local orientation v1->v2
      e=1
      MubE(e) = Mu(2,0); DMubE(e,1:N) = DMu(1:N,2,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=2 --> edge23 with local orientation v2->v3
      e=2
      MubE(e) = Mu(1,1); DMubE(e,1:N) = DMu(1:N,1,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1);
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1);
c  ...e=3 --> edge34 with local orientation v4->v3
      e=3
      MubE(e) = Mu(2,1); DMubE(e,1:N) = DMu(1:N,2,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=4 --> edge41 with local orientation v1->v4
      e=4
      MubE(e) = Mu(1,0); DMubE(e,1:N) = DMu(1:N,1,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1)
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1)
c
c  ...projected coordinates are Mu, so IdecE=true for all edges
      IdecE = .TRUE.
c
      end subroutine BlendProjectQuadE
c----------------------------------------------------------------------
      subroutine BlendTriV(Nu,DNu, NubV,DNubV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Nu(0:2),DNu(1:2,0:2)
      double precision, intent(out) :: NubV(1:3),DNubV(1:3,1:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c                V=((0,0),(1,0),(0,1))=>(v0,v1,v2)
c
      N=2
c
c  ...3 vertices, each with one blending function
c
c  ...v=1 --> v0=(0,0)
      v=1
      NubV(v) = Nu(0); DNubV(v,1:N) = DNu(1:N,0)
c  ...v=2 --> v1=(1,0)
      v=2
      NubV(v) = Nu(1); DNubV(v,1:N) = DNu(1:N,1)
c  ...v=3 --> v2=(0,1)
      v=3
      NubV(v) = Nu(2); DNubV(v,1:N) = DNu(1:N,2)
c
      end subroutine BlendTriV
c----------------------------------------------------------------------
      subroutine ProjectTriE(Nu,DNu, NupE,DNupE,IdecE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecE
      double precision, intent(in)  :: Nu(0:2),DNu(1:2,0:2)
      double precision, intent(out) :: NupE(1:3,0:1),DNupE(1:3,1:2,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c                V=((0,0),(1,0),(0,1))=>(v0,v1,v2)
c                 E=>((v0->v1),(v1->v2),(v0->v2))
c
      N=2
c
c  ...3 edges, each with a locally oriented pair representing
c     a projection
c
c  ...e=1 --> edge01 with local orientation v0->v1
      e=1
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(1)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,1)
c  ...e=2 --> edge12 with local orientation v1->v2
      e=2
      NupE(e,0) = Nu(1); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,1); DNupE(e,1:N,1) = DNu(1:N,2)
c  ...e=3 --> edge20 with local orientation v0->v2
      e=3
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,2)
c
c  ...projected coordinates are Nu, so IdecE=false for all edges
      IdecE = .FALSE.
c
      end subroutine ProjectTriE
c----------------------------------------------------------------------
      subroutine BlendHexaV(Mu,DMu, MubV,DMubV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision, intent(out) :: MubV(1:8,1:3),DMubV(1:8,1:3,1:3)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),
c           (0,0,1),(1,0,1),(1,1,1),(0,1,1))=>(v1,v2,v3,v4,v5,v6,v7,v8)
c
      N=3
c
c  ...8 vertices, each with three blending functions
c
c  ...v=1 --> v1=(0,0,0)
      v=1
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
      MubV(v,3) = Mu(3,0); DMubV(v,1:N,3) = DMu(1:N,3,0)
c  ...v=2 --> v2=(1,0,0)
      v=2
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
      MubV(v,3) = Mu(3,0); DMubV(v,1:N,3) = DMu(1:N,3,0)
c  ...v=3 --> v3=(1,1,0)
      v=3
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
      MubV(v,3) = Mu(3,0); DMubV(v,1:N,3) = DMu(1:N,3,0)
c  ...v=4 --> v4=(0,1,0)
      v=4
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
      MubV(v,3) = Mu(3,0); DMubV(v,1:N,3) = DMu(1:N,3,0)
c  ...v=5 --> v5=(0,0,1)
      v=5
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
      MubV(v,3) = Mu(3,1); DMubV(v,1:N,3) = DMu(1:N,3,1)
c  ...v=6 --> v6=(1,0,1)
      v=6
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,0); DMubV(v,1:N,2) = DMu(1:N,2,0)
      MubV(v,3) = Mu(3,1); DMubV(v,1:N,3) = DMu(1:N,3,1)
c  ...v=7 --> v7=(1,1,1)
      v=7
      MubV(v,1) = Mu(1,1); DMubV(v,1:N,1) = DMu(1:N,1,1)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
      MubV(v,3) = Mu(3,1); DMubV(v,1:N,3) = DMu(1:N,3,1)
c  ...v=8 --> v8=(0,1,1)
      v=8
      MubV(v,1) = Mu(1,0); DMubV(v,1:N,1) = DMu(1:N,1,0)
      MubV(v,2) = Mu(2,1); DMubV(v,1:N,2) = DMu(1:N,2,1)
      MubV(v,3) = Mu(3,1); DMubV(v,1:N,3) = DMu(1:N,3,1)
c
      end subroutine BlendHexaV
c----------------------------------------------------------------------
      subroutine BlendProjectHexaE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecE
      double precision, intent(in)  :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision, intent(out) :: MubE(1:12,1:2),
     .          DMubE(1:12,1:3,1:2),MupE(1:12,0:1),DMupE(1:12,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),
c           (0,0,1),(1,0,1),(1,1,1),(0,1,1))=>(v1,v2,v3,v4,v5,v6,v7,v8)
c      E=>((v1->v2),(v2->v3),(v4->v3),(v1->v4),(v5->v6),(v6->v7),
c            (v8->v7),(v5->v8),(v1->v5),(v2->v6),(v3->v7),(v4->v8))
c
      N=3
c
c  ...12 edges, each with two blending functions
c     and a locally oriented pair representing a projection
c
c  ...e=1 --> edge12 with local orientation v1->v2
      e=1
      MubE(e,1) = Mu(2,0); DMubE(e,1:N,1) = DMu(1:N,2,0)
      MubE(e,2) = Mu(3,0); DMubE(e,1:N,2) = DMu(1:N,3,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=2 --> edge23 with local orientation v2->v3
      e=2
      MubE(e,1) = Mu(1,1); DMubE(e,1:N,1) = DMu(1:N,1,1)
      MubE(e,2) = Mu(3,0); DMubE(e,1:N,2) = DMu(1:N,3,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1);
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1);
c  ...e=3 --> edge34 with local orientation v4->v3
      e=3
      MubE(e,1) = Mu(2,1); DMubE(e,1:N,1) = DMu(1:N,2,1)
      MubE(e,2) = Mu(3,0); DMubE(e,1:N,2) = DMu(1:N,3,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=4 --> edge41 with local orientation v1->v4
      e=4
      MubE(e,1) = Mu(1,0); DMubE(e,1:N,1) = DMu(1:N,1,0)
      MubE(e,2) = Mu(3,0); DMubE(e,1:N,2) = DMu(1:N,3,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1)
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1)
c  ...e=5 --> edge56 with local orientation v5->v6
      e=5
      MubE(e,1) = Mu(2,0); DMubE(e,1:N,1) = DMu(1:N,2,0)
      MubE(e,2) = Mu(3,1); DMubE(e,1:N,2) = DMu(1:N,3,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=6 --> edge67 with local orientation v6->v7
      e=6
      MubE(e,1) = Mu(1,1); DMubE(e,1:N,1) = DMu(1:N,1,1)
      MubE(e,2) = Mu(3,1); DMubE(e,1:N,2) = DMu(1:N,3,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1);
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1);
c  ...e=7 --> edge78 with local orientation v8->v7
      e=7
      MubE(e,1) = Mu(2,1); DMubE(e,1:N,1) = DMu(1:N,2,1)
      MubE(e,2) = Mu(3,1); DMubE(e,1:N,2) = DMu(1:N,3,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(1,0); MupE(e,1) = Mu(1,1)
      DMupE(e,1:N,0) = DMu(1:N,1,0); DMupE(e,1:N,1) = DMu(1:N,1,1)
c  ...e=8 --> edge85 with local orientation v5->v8
      e=8
      MubE(e,1) = Mu(1,0); DMubE(e,1:N,1) = DMu(1:N,1,0)
      MubE(e,2) = Mu(3,1); DMubE(e,1:N,2) = DMu(1:N,3,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(2,0); MupE(e,1) = Mu(2,1)
      DMupE(e,1:N,0) = DMu(1:N,2,0); DMupE(e,1:N,1) = DMu(1:N,2,1)
c  ...e=9 --> edge15 with local orientation v1->v5
      e=9
      MubE(e,1) = Mu(1,0); DMubE(e,1:N,1) = DMu(1:N,1,0)
      MubE(e,2) = Mu(2,0); DMubE(e,1:N,2) = DMu(1:N,2,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(3,0); MupE(e,1) = Mu(3,1)
      DMupE(e,1:N,0) = DMu(1:N,3,0); DMupE(e,1:N,1) = DMu(1:N,3,1)
c  ...e=10 --> edge26 with local orientation v2->v6
      e=10
      MubE(e,1) = Mu(1,1); DMubE(e,1:N,1) = DMu(1:N,1,1)
      MubE(e,2) = Mu(2,0); DMubE(e,1:N,2) = DMu(1:N,2,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(3,0); MupE(e,1) = Mu(3,1)
      DMupE(e,1:N,0) = DMu(1:N,3,0); DMupE(e,1:N,1) = DMu(1:N,3,1)
c  ...e=11 --> edge37 with local orientation v3->v7
      e=11
      MubE(e,1) = Mu(1,1); DMubE(e,1:N,1) = DMu(1:N,1,1)
      MubE(e,2) = Mu(2,1); DMubE(e,1:N,2) = DMu(1:N,2,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(3,0); MupE(e,1) = Mu(3,1)
      DMupE(e,1:N,0) = DMu(1:N,3,0); DMupE(e,1:N,1) = DMu(1:N,3,1)
c  ...e=12 --> edge48 with local orientation v4->v8
      e=12
      MubE(e,1) = Mu(1,0); DMubE(e,1:N,1) = DMu(1:N,1,0)
      MubE(e,2) = Mu(2,1); DMubE(e,1:N,2) = DMu(1:N,2,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(3,0); MupE(e,1) = Mu(3,1)
      DMupE(e,1:N,0) = DMu(1:N,3,0); DMupE(e,1:N,1) = DMu(1:N,3,1)
c
c  ...projected coordinates are Mu, so IdecE=true for all edges
      IdecE = .TRUE.
c
      end subroutine BlendProjectHexaE
c----------------------------------------------------------------------
      subroutine BlendProjectHexaF(Mu,DMu, MubF,DMubF,MupF,DMupF,IdecF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecF(1:2)
      double precision, intent(in)  :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision, intent(out) :: MubF(1:6),DMubF(1:6,1:3)
      double precision, intent(out) :: MupF(1:6,1:2,0:1),
     .                                           DMupF(1:6,1:3,1:2,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),
c           (0,0,1),(1,0,1),(1,1,1),(0,1,1))=>(v1,v2,v3,v4,v5,v6,v7,v8)
c      F=>((v1->v2->v3->v4),(v5->v6->v7->v8),(v1->v2->v6->v5)
c            (v2->v3->v7->v6),(v4->v3->v7->v8),(v1->v4->v8->v5))
c
      N=3
c
c  ...6 faces, each with one blending function
c     and a locally oriented quadruple representing a projection
c
c  ...f=1 --> face1234 with local orientation v1->v2->v3->v4
      f=1
      MubF(f) = Mu(3,0); DMubF(f,1:N) = DMu(1:N,3,0)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(1,0); MupF(f,1,1) = Mu(1,1)
      MupF(f,2,0) = Mu(2,0); MupF(f,2,1) = Mu(2,1)
      DMupF(f,1:N,1,0) = DMu(1:N,1,0); DMupF(f,1:N,1,1) = DMu(1:N,1,1)
      DMupF(f,1:N,2,0) = DMu(1:N,2,0); DMupF(f,1:N,2,1) = DMu(1:N,2,1)
c  ...f=2 --> face5678 with local orientation v5->v6->v7->v8
      f=2
      MubF(f) = Mu(3,1); DMubF(f,1:N) = DMu(1:N,3,1)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(1,0); MupF(f,1,1) = Mu(1,1)
      MupF(f,2,0) = Mu(2,0); MupF(f,2,1) = Mu(2,1)
      DMupF(f,1:N,1,0) = DMu(1:N,1,0); DMupF(f,1:N,1,1) = DMu(1:N,1,1)
      DMupF(f,1:N,2,0) = DMu(1:N,2,0); DMupF(f,1:N,2,1) = DMu(1:N,2,1)
c  ...f=3 --> face1265 with local orientation v1->v2->v6->v5
      f=3
      MubF(f) = Mu(2,0); DMubF(f,1:N) = DMu(1:N,2,0)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(1,0); MupF(f,1,1) = Mu(1,1)
      MupF(f,2,0) = Mu(3,0); MupF(f,2,1) = Mu(3,1)
      DMupF(f,1:N,1,0) = DMu(1:N,1,0); DMupF(f,1:N,1,1) = DMu(1:N,1,1)
      DMupF(f,1:N,2,0) = DMu(1:N,3,0); DMupF(f,1:N,2,1) = DMu(1:N,3,1)
c  ...f=4 --> face2376 with local orientation v2->v3->v7->v6
      f=4
      MubF(f) = Mu(1,1); DMubF(f,1:N) = DMu(1:N,1,1)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(2,0); MupF(f,1,1) = Mu(2,1)
      MupF(f,2,0) = Mu(3,0); MupF(f,2,1) = Mu(3,1)
      DMupF(f,1:N,1,0) = DMu(1:N,2,0); DMupF(f,1:N,1,1) = DMu(1:N,2,1)
      DMupF(f,1:N,2,0) = DMu(1:N,3,0); DMupF(f,1:N,2,1) = DMu(1:N,3,1)
c  ...f=5 --> face4378 with local orientation v4->v3->v7->v8
      f=5
      MubF(f) = Mu(2,1); DMubF(f,1:N) = DMu(1:N,2,1)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(1,0); MupF(f,1,1) = Mu(1,1)
      MupF(f,2,0) = Mu(3,0); MupF(f,2,1) = Mu(3,1)
      DMupF(f,1:N,1,0) = DMu(1:N,1,0); DMupF(f,1:N,1,1) = DMu(1:N,1,1)
      DMupF(f,1:N,2,0) = DMu(1:N,3,0); DMupF(f,1:N,2,1) = DMu(1:N,3,1)
c  ...f=6 --> face1485 with local orientation v1->v4->v8->v5
      f=6
      MubF(f) = Mu(1,0); DMubF(f,1:N) = DMu(1:N,1,0)
c     ...locally oriented quadruple representing projection
      MupF(f,1,0) = Mu(2,0); MupF(f,1,1) = Mu(2,1)
      MupF(f,2,0) = Mu(3,0); MupF(f,2,1) = Mu(3,1)
      DMupF(f,1:N,1,0) = DMu(1:N,2,0); DMupF(f,1:N,1,1) = DMu(1:N,2,1)
      DMupF(f,1:N,2,0) = DMu(1:N,3,0); DMupF(f,1:N,2,1) = DMu(1:N,3,1)
c
c  ...projected coordinates are Mu and Mu, so IdecF=(true,true) for
c     all faces
      IdecF(1) = .TRUE.; IdecF(2) = .TRUE.
c
      end subroutine BlendProjectHexaF
c----------------------------------------------------------------------
      subroutine BlendTetV(Lam,DLam, LambV,DLambV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Lam(0:3),DLam(1:3,0:3)
      double precision, intent(out) :: LambV(1:4),DLambV(1:4,1:3)
c
c  ...Info from module element_data - coordinates,connectivities:
c           V=((0,0,0),(1,0,0),(0,1,0),(0,0,1))=>(v0,v1,v2,v3)
c
      N=3
c
c  ...4 vertices, each with one blending function
c
c  ...v=1 --> v0=(0,0,0)
      v=1
      LambV(v) = Lam(0); DLambV(v,1:N) = DLam(1:N,0)
c  ...v=2 --> v1=(1,0,0)
      v=2
      LambV(v) = Lam(1); DLambV(v,1:N) = DLam(1:N,1)
c  ...v=3 --> v2=(0,1,0)
      v=3
      LambV(v) = Lam(2); DLambV(v,1:N) = DLam(1:N,2)
c  ...v=4 --> v3=(0,0,1)
      v=4
      LambV(v) = Lam(3); DLambV(v,1:N) = DLam(1:N,3)
c
      end subroutine BlendTetV
c----------------------------------------------------------------------
      subroutine ProjectTetE(Lam,DLam, LampE,DLampE,IdecE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecE
      double precision, intent(in)  :: Lam(0:3),DLam(1:3,0:3)
      double precision, intent(out) :: LampE(1:6,0:1),
     .                                             DLampE(1:6,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c           V=((0,0,0),(1,0,0),(0,1,0),(0,0,1))=>(v0,v1,v2,v3)
c         E=>((v0->v1),(v1->v2),(v0->v2),(v0->v3),(v1->v3),(v2->v3))
c
      N=3
c
c  ...6 edges, each with a locally oriented pair representing
c     a projection
c
c  ...e=1 --> edge01 with local orientation v0->v1
      e=1
      LampE(e,0) = Lam(0); LampE(e,1) = Lam(1)
      DLampE(e,1:N,0) = DLam(1:N,0); DLampE(e,1:N,1) = DLam(1:N,1)
c  ...e=2 --> edge12 with local orientation v1->v2
      e=2
      LampE(e,0) = Lam(1); LampE(e,1) = Lam(2)
      DLampE(e,1:N,0) = DLam(1:N,1); DLampE(e,1:N,1) = DLam(1:N,2)
c  ...e=3 --> edge20 with local orientation v0->v2
      e=3
      LampE(e,0) = Lam(0); LampE(e,1) = Lam(2)
      DLampE(e,1:N,0) = DLam(1:N,0); DLampE(e,1:N,1) = DLam(1:N,2)
c  ...e=4 --> edge03 with local orientation v0->v3
      e=4
      LampE(e,0) = Lam(0); LampE(e,1) = Lam(3)
      DLampE(e,1:N,0) = DLam(1:N,0); DLampE(e,1:N,1) = DLam(1:N,3)
c  ...e=5 --> edge13 with local orientation v1->v3
      e=5
      LampE(e,0) = Lam(1); LampE(e,1) = Lam(3)
      DLampE(e,1:N,0) = DLam(1:N,1); DLampE(e,1:N,1) = DLam(1:N,3)
c  ...e=6 --> edge23 with local orientation v2->v3
      e=6
      LampE(e,0) = Lam(2); LampE(e,1) = Lam(3)
      DLampE(e,1:N,0) = DLam(1:N,2); DLampE(e,1:N,1) = DLam(1:N,3)
c
c  ...projected coordinates are Lam, so IdecE=false for all edges
      IdecE = .FALSE.
c
      end subroutine ProjectTetE
c----------------------------------------------------------------------
      subroutine ProjectTetF(Lam,DLam, LampF,DLampF,IdecF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecF
      double precision, intent(in)  :: Lam(0:3),DLam(1:3,0:3)
      double precision, intent(out) :: LampF(1:4,0:2),
     .                                             DLampF(1:4,1:3,0:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c           V=((0,0,0),(1,0,0),(0,1,0),(0,0,1))=>(v0,v1,v2,v3)
c        F=>((v0->v1->v2),(v0->v1->v3),(v1->v2->v3),(v0->v2->v3))
c
      N=3
c
c  ...4 faces, each with a locally oriented triplet representing
c     a projection
c
c  ...f=1 --> face012 with local orientation v0->v1->v2
      f=1
      LampF(f,0) = Lam(0); LampF(f,1) = Lam(1); LampF(f,2) = Lam(2)
      DLampF(f,1:N,0) = DLam(1:N,0); DLampF(f,1:N,1) = DLam(1:N,1);
                                         DLampF(f,1:N,2) = DLam(1:N,2)
c  ...f=2 --> face013 with local orientation v0->v1->v3
      f=2
      LampF(f,0) = Lam(0); LampF(f,1) = Lam(1); LampF(f,2) = Lam(3)
      DLampF(f,1:N,0) = DLam(1:N,0); DLampF(f,1:N,1) = DLam(1:N,1);
                                         DLampF(f,1:N,2) = DLam(1:N,3)
c  ...f=3 --> face123 with local orientation v1->v2->v3
      f=3
      LampF(f,0) = Lam(1); LampF(f,1) = Lam(2); LampF(f,2) = Lam(3)
      DLampF(f,1:N,0) = DLam(1:N,1); DLampF(f,1:N,1) = DLam(1:N,2);
                                         DLampF(f,1:N,2) = DLam(1:N,3)
c  ...f=4 --> face023 with local orientation v0->v2->v3
      f=4
      LampF(f,0) = Lam(0); LampF(f,1) = Lam(2); LampF(f,2) = Lam(3)
      DLampF(f,1:N,0) = DLam(1:N,0); DLampF(f,1:N,1) = DLam(1:N,2);
                                         DLampF(f,1:N,2) = DLam(1:N,3)
c
c  ...projected coordinates are Lam, so IdecF=false for all faces
      IdecF = .FALSE.
c
      end subroutine ProjectTetF
c----------------------------------------------------------------------
      subroutine BlendPrisV(Mu,DMu,Nu,DNu, MubV,DMubV,NubV,DNubV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(in)  :: Nu(0:2),DNu(1:3,0:2)
      double precision, intent(out) :: MubV(1:6),DMubV(1:6,1:3)
      double precision, intent(out) :: NubV(1:6),DNubV(1:6,1:3)
c
c  ...Info from module element_data - coordinates,connectivities:
c        V=((0,0,0),(1,0,0),(0,1,0),
c                    (0,0,1),(1,0,1),(0,1,1))=>(v0,v1,v2,v3,v4,v5)
c
      N=3
c
c  ...6 vertices, each with two blending functions (one mu, one nu)
c
c  ...v=1 --> v0=(0,0,0)
      v=1
      MubV(v) = Mu(0); DMubV(v,1:N) = DMu(1:N,0)
      NubV(v) = Nu(0); DNubV(v,1:N) = DNu(1:N,0)
c  ...v=2 --> v1=(1,0,0)
      v=2
      MubV(v) = Mu(0); DMubV(v,1:N) = DMu(1:N,0)
      NubV(v) = Nu(1); DNubV(v,1:N) = DNu(1:N,1)
c  ...v=3 --> v2=(0,1,0)
      v=3
      MubV(v) = Mu(0); DMubV(v,1:N) = DMu(1:N,0)
      NubV(v) = Nu(2); DNubV(v,1:N) = DNu(1:N,2)
c  ...v=4 --> v3=(0,0,1)
      v=4
      MubV(v) = Mu(1); DMubV(v,1:N) = DMu(1:N,1)
      NubV(v) = Nu(0); DNubV(v,1:N) = DNu(1:N,0)
c  ...v=5 --> v4=(1,0,1)
      v=5
      MubV(v) = Mu(1); DMubV(v,1:N) = DMu(1:N,1)
      NubV(v) = Nu(1); DNubV(v,1:N) = DNu(1:N,1)
c  ...v=6 --> v5=(0,1,1)
      v=6
      MubV(v) = Mu(1); DMubV(v,1:N) = DMu(1:N,1)
      NubV(v) = Nu(2); DNubV(v,1:N) = DNu(1:N,2)
c
      end subroutine BlendPrisV
c----------------------------------------------------------------------
      subroutine BlendProjectPrisME(Mu,DMu,Nu,DNu,
     .                                    MubE,DMubE,NupE,DNupE,IdecME)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecME
      double precision, intent(in)  :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(in)  :: Nu(0:2),DNu(1:3,0:2)
      double precision, intent(out) :: MubE(1:6),DMubE(1:6,1:3)
      double precision, intent(out) :: NupE(1:6,0:1),DNupE(1:6,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c        V=((0,0,0),(1,0,0),(0,1,0),
c                    (0,0,1),(1,0,1),(0,1,1))=>(v0,v1,v2,v3,v4,v5)
c      E_part1=>((v0->v1),(v1->v2),(v0->v2),(v3->v4),(v4->v5),(v3->v5))
c
      N=3
c
c  ...6 mixed edges, each with a blending mu function and a locally
c     oriented pair (of nu) representing a projection
c
c  ...e=1 --> edge01 with local orientation v0->v1
      e=1
      MubE(e) = Mu(0); DMubE(e,1:N) = DMu(1:N,0)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(1)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,1)
c  ...e=2 --> edge12 with local orientation v1->v2
      e=2
      MubE(e) = Mu(0); DMubE(e,1:N) = DMu(1:N,0)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(1); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,1); DNupE(e,1:N,1) = DNu(1:N,2)
c  ...e=3 --> edge20 with local orientation v0->v2
      e=3
      MubE(e) = Mu(0); DMubE(e,1:N) = DMu(1:N,0)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,2)
c  ...e=4 --> edge34 with local orientation v3->v4
      e=4
      MubE(e) = Mu(1); DMubE(e,1:N) = DMu(1:N,1)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(1)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,1)
c  ...e=5 --> edge45 with local orientation v4->v5
      e=5
      MubE(e) = Mu(1); DMubE(e,1:N) = DMu(1:N,1)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(1); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,1); DNupE(e,1:N,1) = DNu(1:N,2)
c  ...e=6 --> edge53 with local orientation v3->v5
      e=6
      MubE(e) = Mu(1); DMubE(e,1:N) = DMu(1:N,1)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(0); NupE(e,1) = Nu(2)
      DNupE(e,1:N,0) = DNu(1:N,0); DNupE(e,1:N,1) = DNu(1:N,2)
c
c  ...projected coordinates are Nu, so IdecME=false for all edges
      IdecME = .FALSE.
c
      end subroutine BlendProjectPrisME
c----------------------------------------------------------------------
      subroutine BlendProjectPrisQE(Mu,DMu,Nu,DNu,
     .                                    NubE,DNubE,MupE,DMupE,IdecQE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecQE
      double precision, intent(in)  :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(in)  :: Nu(0:2),DNu(1:3,0:2)
      double precision, intent(out) :: NubE(1:3),DNubE(1:3,1:3)
      double precision, intent(out) :: MupE(1:3,0:1),DMupE(1:3,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c        V=((0,0,0),(1,0,0),(0,1,0),
c                    (0,0,1),(1,0,1),(0,1,1))=>(v0,v1,v2,v3,v4,v5)
c                 E_part2=>((v0->v3),(v1->v4),(v2->v5))
c
      N=3
c
c  ...3 quad edges, each with a blending nu function and a locally
c     oriented pair (of mu) representing a projection
c
c  ...e=1 --> edge03 with local orientation v0->v3
      e=1
      NubE(e) = Nu(0); DNubE(e,1:N) = DNu(1:N,0)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(0); MupE(e,1) = Mu(1)
      DMupE(e,1:N,0) = DMu(1:N,0); DMupE(e,1:N,1) = DMu(1:N,1)
c  ...e=2 --> edge14 with local orientation v1->v4
      e=2
      NubE(e) = Nu(1); DNubE(e,1:N) = DNu(1:N,1)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(0); MupE(e,1) = Mu(1)
      DMupE(e,1:N,0) = DMu(1:N,0); DMupE(e,1:N,1) = DMu(1:N,1)
c  ...e=3 --> edge25 with local orientation v2->v5
      e=3
      NubE(e) = Nu(2); DNubE(e,1:N) = DNu(1:N,2)
c     ...locally oriented pair representing projection
      MupE(e,0) = Mu(0); MupE(e,1) = Mu(1)
      DMupE(e,1:N,0) = DMu(1:N,0); DMupE(e,1:N,1) = DMu(1:N,1)
c
c  ...projected coordinates are Mu, so IdecQE=true for all edges
      IdecQE = .TRUE.
c
      end subroutine BlendProjectPrisQE
c----------------------------------------------------------------------
      subroutine BlendProjectPrisTF(Mu,DMu,Nu,DNu,
     .                                    MubF,DMubF,NupF,DNupF,IdecTF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecTF
      double precision, intent(in)  :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(in)  :: Nu(0:2),DNu(1:3,0:2)
      double precision, intent(out) :: MubF(1:2),DMubF(1:2,1:3)
      double precision, intent(out) :: NupF(1:2,0:2),DNupF(1:2,1:3,0:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c        V=((0,0,0),(1,0,0),(0,1,0),
c                    (0,0,1),(1,0,1),(0,1,1))=>(v0,v1,v2,v3,v4,v5)
c                F_part1=>((v0->v1->v2),(v3->v4->v5)
c
      N=3
c
c  ...2 triangle faces, each with a blending mu function and a locally
c     oriented triplet (of nu) representing a projection
c
c  ...f=1 --> face012 with local orientation v0->v1->v2
      f=1
      MubF(f) = Mu(0); DMubF(f,1:N) = DMu(1:N,0)
c     ...locally oriented triplet representing projection
      NupF(f,0) = Nu(0); NupF(f,1) = Nu(1); NupF(f,2) = Nu(2)
      DNupF(f,1:N,0) = DNu(1:N,0); DNupF(f,1:N,1) = DNu(1:N,1);
                                         DNupF(f,1:N,2) = DNu(1:N,2)
c  ...f=2 --> face345 with local orientation v3->v4->v5
      f=2
      MubF(f) = Mu(1); DMubF(f,1:N) = DMu(1:N,1)
c     ...locally oriented triplet representing projection
      NupF(f,0) = Nu(0); NupF(f,1) = Nu(1); NupF(f,2) = Nu(2)
      DNupF(f,1:N,0) = DNu(1:N,0); DNupF(f,1:N,1) = DNu(1:N,1);
                                         DNupF(f,1:N,2) = DNu(1:N,2)
c
c  ...projected coordinates are Nu, so IdecTF=true for all faces
      IdecTF = .TRUE.
c
      end subroutine BlendProjectPrisTF
c----------------------------------------------------------------------
      subroutine ProjectPrisQF(Mu,DMu,Nu,DNu, STpF,DSTpF,IdecQF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecQF(1:3,1:2)
      double precision, intent(in)  :: Mu(0:1),DMu(1:3,0:1)
      double precision, intent(in)  :: Nu(0:2),DNu(1:3,0:2)
      double precision, intent(out) :: STpF(1:3,1:2,0:1),
     .                                           DSTpF(1:3,1:3,1:2,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c        V=((0,0,0),(1,0,0),(0,1,0),
c                    (0,0,1),(1,0,1),(0,1,1))=>(v0,v1,v2,v3,v4,v5)
c      F_part2=>((v0->v1->v4->v3),(v1->v2->v5->v4),(v0->v2->v5->v3))
c
      N=3
c
c  ...3 quad faces, each with a locally oriented quadruple representing
c     a projection
c  ...simplification flags depend on the local quad face orientations
c
c  ...f=1 --> face0143 with local orientation v0->v1->v4->v3
      f=1
c     ...locally oriented quadruple representing projection
      STpF(f,1,0) = Nu(0); STpF(f,1,1) = Nu(1)
      STpF(f,2,0) = Mu(0); STpF(f,2,1) = Mu(1)
      DSTpF(f,1:N,1,0) = DNu(1:N,0); DSTpF(f,1:N,1,1) = DNu(1:N,1)
      DSTpF(f,1:N,2,0) = DMu(1:N,0); DSTpF(f,1:N,2,1) = DMu(1:N,1)
c     ...simplification flags: projection (Nu;Mu)=>(false,true)
      IdecQF(f,1) = .FALSE.; IdecQF(f,2) = .TRUE.
c  ...f=2 --> face1254 with local orientation v1->v2->v5->v4
      f=2
c     ...locally oriented quadruple representing projection
      STpF(f,1,0) = Nu(1); STpF(f,1,1) = Nu(2)
      STpF(f,2,0) = Mu(0); STpF(f,2,1) = Mu(1)
      DSTpF(f,1:N,1,0) = DNu(1:N,1); DSTpF(f,1:N,1,1) = DNu(1:N,2)
      DSTpF(f,1:N,2,0) = DMu(1:N,0); DSTpF(f,1:N,2,1) = DMu(1:N,1)
c     ...simplification flags: projection (Nu;Mu)=>(false,true)
      IdecQF(f,1) = .FALSE.; IdecQF(f,2) = .TRUE.
c  ...f=3 --> face0253 with local orientation v0->v2->v5->v3
      f=3
c     ...locally oriented quadruple representing projection
      STpF(f,1,0) = Nu(0); STpF(f,1,1) = Nu(2)
      STpF(f,2,0) = Mu(0); STpF(f,2,1) = Mu(1)
      DSTpF(f,1:N,1,0) = DNu(1:N,0); DSTpF(f,1:N,1,1) = DNu(1:N,2)
      DSTpF(f,1:N,2,0) = DMu(1:N,0); DSTpF(f,1:N,2,1) = DMu(1:N,1)
c     ...simplification flags: projection (Nu;Mu)=>(false,true)
      IdecQF(f,1) = .FALSE.; IdecQF(f,2) = .TRUE.
c
      end subroutine ProjectPrisQF
c----------------------------------------------------------------------
      subroutine BlendPyraV(Lam,DLam, LambV,DLambV)
c
      implicit none
      integer :: N,v
      double precision, intent(in)  :: Lam(1:5),DLam(1:3,1:5)
      double precision, intent(out) :: LambV(1:5),DLambV(1:5,1:3)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c
      N=3
c
c  ...5 vertices, each with one blending function
c
c  ...v=1 --> v1=(0,0,0)
      v=1
      LambV(v) = Lam(1); DLambV(v,1:N) = DLam(1:N,1)
c  ...v=2 --> v2=(1,0,0)
      v=2
      LambV(v) = Lam(2); DLambV(v,1:N) = DLam(1:N,2)
c  ...v=3 --> v3=(1,1,0)
      v=3
      LambV(v) = Lam(3); DLambV(v,1:N) = DLam(1:N,3)
c  ...v=4 --> v4=(0,1,0)
      v=4
      LambV(v) = Lam(4); DLambV(v,1:N) = DLam(1:N,4)
c  ...v=5 --> v5=(0,0,1)
      v=5
      LambV(v) = Lam(5); DLambV(v,1:N) = DLam(1:N,5)
c
      end subroutine BlendPyraV
c----------------------------------------------------------------------
      subroutine BlendProjectPyraME(Mu,DMu,Nu,DNu,
     .                                    MubE,DMubE,NupE,DNupE,IdecME)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecME
      double precision, intent(in)  :: Mu(1:2,0:1),DMu(1:3,1:2,0:1)
      double precision, intent(in)  :: Nu(1:2,0:2),DNu(1:3,1:2,0:2)
      double precision, intent(out) :: MubE(1:4),DMubE(1:4,1:3)
      double precision, intent(out) :: NupE(1:4,0:1),DNupE(1:4,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c             E_part1=>((v1->v2),(v2->v3),(v4->v3),(v1->v4))
c
      N=3
c
c  ...4 edges, each with a blending function (mu) and a locally
c     oriented pair (nu) representing a projection
c
c  ...e=1 --> edge12 with local orientation v1->v2
      e=1
      MubE(e) = Mu(2,0); DMubE(e,1:N) = DMu(1:N,2,0)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(1,0); NupE(e,1) = Nu(1,1)
      DNupE(e,1:N,0) = DNu(1:N,1,0); DNupE(e,1:N,1) = DNu(1:N,1,1)
c  ...e=2 --> edge23 with local orientation v2->v3
      e=2
      MubE(e) = Mu(1,1); DMubE(e,1:N) = DMu(1:N,1,1)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(2,0); NupE(e,1) = Nu(2,1)
      DNupE(e,1:N,0) = DNu(1:N,2,0); DNupE(e,1:N,1) = DNu(1:N,2,1)
c  ...e=3 --> edge34 with local orientation v4->v3
      e=3
      MubE(e) = Mu(2,1); DMubE(e,1:N) = DMu(1:N,2,1)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(1,0); NupE(e,1) = Nu(1,1)
      DNupE(e,1:N,0) = DNu(1:N,1,0); DNupE(e,1:N,1) = DNu(1:N,1,1)
c  ...e=4 --> edge41 with local orientation v1->v4
      e=4
      MubE(e) = Mu(1,0); DMubE(e,1:N) = DMu(1:N,1,0)
c     ...locally oriented pair representing projection
      NupE(e,0) = Nu(2,0); NupE(e,1) = Nu(2,1)
      DNupE(e,1:N,0) = DNu(1:N,2,0); DNupE(e,1:N,1) = DNu(1:N,2,1)
c
c  ...projected coordinates are Nu, so IdecME=false for all edges
      IdecME = .FALSE.
c
      end subroutine BlendProjectPyraME
c----------------------------------------------------------------------
      subroutine ProjectPyraTE(Lam,DLam, LampE,DLampE,IdecTE)
c
      implicit none
      integer :: N,e
      logical, intent(out) :: IdecTE
      double precision, intent(in)  :: Lam(1:5),DLam(1:3,1:5)
      double precision, intent(out) :: LampE(1:4,0:1),
     .                                             DLampE(1:4,1:3,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c             E_part2=>((v1->v5),(v2->v5),(v3->v5),(v4->v5))
c
      N=3
c
c  ...4 edges, each with a locally oriented pair (lam) representing
c     a projection
c
c  ...e=1 --> edge15 with local orientation v1->v5
      e=1
      LampE(e,0) = Lam(1); LampE(e,1) = Lam(5)
      DLampE(e,1:N,0) = DLam(1:N,1); DLampE(e,1:N,1) = DLam(1:N,5)
c  ...e=2 --> edge25 with local orientation v2->v5
      e=2
      LampE(e,0) = Lam(2); LampE(e,1) = Lam(5)
      DLampE(e,1:N,0) = DLam(1:N,2); DLampE(e,1:N,1) = DLam(1:N,5)
c  ...e=3 --> edge35 with local orientation v3->v5
      e=3
      LampE(e,0) = Lam(3); LampE(e,1) = Lam(5)
      DLampE(e,1:N,0) = DLam(1:N,3); DLampE(e,1:N,1) = DLam(1:N,5)
c  ...e=4 --> edge45 with local orientation v4->v5
      e=4
      LampE(e,0) = Lam(4); LampE(e,1) = Lam(5)
      DLampE(e,1:N,0) = DLam(1:N,4); DLampE(e,1:N,1) = DLam(1:N,5)
c
c  ...projected coordinates are Lam, so IdecTE=false for all edges
      IdecTE = .FALSE.
c
      end subroutine ProjectPyraTE
c----------------------------------------------------------------------
      subroutine ProjectPyraQF(Mu,DMu, MupF,DMupF,IdecQF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecQF(1:2)
      double precision, intent(in)  :: Mu(1:2,0:1),DMu(1:3,1:2,0:1)
      double precision, intent(out) :: MupF(1:2,0:1),DMupF(1:3,1:2,0:1)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c             F_part1=>((v1->v2->v3->v4))
c
      N=3
c
c  ...1 quadrilateral face with  a locally oriented quadruple
c     representing a projection
c
c  ...face1234 with local orientation v1->v2->v3->v4
c     ...locally oriented quadruple representing projection
      MupF(1,0) = Mu(1,0); MupF(1,1) = Mu(1,1)
      MupF(2,0) = Mu(2,0); MupF(2,1) = Mu(2,1)
      DMupF(1:N,1,0) = DMu(1:N,1,0); DMupF(1:N,1,1) = DMu(1:N,1,1)
      DMupF(1:N,2,0) = DMu(1:N,2,0); DMupF(1:N,2,1) = DMu(1:N,2,1)
c
c  ...projected coordinates are (Mu;Mu), so IdecQF=(true,true) for
c     the face
      IdecQF(1) = .TRUE.; IdecQF(2) = .TRUE.
c
      end subroutine ProjectPyraQF
c----------------------------------------------------------------------
      subroutine BlendProjectPyraTF(Mu,DMu,Nu,DNu,
     .                                    MubF,DMubF,NupF,DNupF,IdecTF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecTF
      double precision, intent(in)  :: Mu(1:2,0:1),DMu(1:3,1:2,0:1)
      double precision, intent(in)  :: Nu(1:2,0:2),DNu(1:3,1:2,0:2)
      double precision, intent(out) :: MubF(1:4),DMubF(1:4,1:3)
      double precision, intent(out) :: NupF(1:4,0:2),DNupF(1:4,1:3,0:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c      F_part2=>((v1->v2->v5),(v2->v3->v5),(v4->v3->v5),(v1->v4->v5))
c
      N=3
c
c  ...4 triangle faces, each with a blending function (mu) and a
c      locally oriented triplet (nu) representing a projection
c
c  ...f=1 --> face125 with local orientation v1->v2->v5
      f=1
      MubF(f) = Mu(2,0); DMubF(f,1:N) = DMu(1:N,2,0)
c     ...locally oriented pair representing projection
      NupF(f,0) = Nu(1,0); NupF(f,1) = Nu(1,1); NupF(f,2) = Nu(1,2)
      DNupF(f,1:N,0) = DNu(1:N,1,0); DNupF(f,1:N,1) = DNu(1:N,1,1);
                                          DNupF(f,1:N,2) = DNu(1:N,1,2)
c  ...f=2 --> face235 with local orientation v2->v3->v5
      f=2
      MubF(f) = Mu(1,1); DMubF(f,1:N) = DMu(1:N,1,1)
c     ...locally oriented pair representing projection
      NupF(f,0) = Nu(2,0); NupF(f,1) = Nu(2,1); NupF(f,2) = Nu(2,2)
      DNupF(f,1:N,0) = DNu(1:N,2,0); DNupF(f,1:N,1) = DNu(1:N,2,1);
                                          DNupF(f,1:N,2) = DNu(1:N,2,2)
c  ...f=3 --> face345 with local orientation v4->v3->v5
      f=3
      MubF(f) = Mu(2,1); DMubF(f,1:N) = DMu(1:N,2,1)
c     ...locally oriented pair representing projection
      NupF(f,0) = Nu(1,0); NupF(f,1) = Nu(1,1); NupF(f,2) = Nu(1,2)
      DNupF(f,1:N,0) = DNu(1:N,1,0); DNupF(f,1:N,1) = DNu(1:N,1,1);
                                          DNupF(f,1:N,2) = DNu(1:N,1,2)
c  ...f=4 --> face415 with local orientation v1->v4->v5
      f=4
      MubF(f) = Mu(1,0); DMubF(f,1:N) = DMu(1:N,1,0)
c     ...locally oriented pair representing projection
      NupF(f,0) = Nu(2,0); NupF(f,1) = Nu(2,1); NupF(f,2) = Nu(2,2)
      DNupF(f,1:N,0) = DNu(1:N,2,0); DNupF(f,1:N,1) = DNu(1:N,2,1);
                                          DNupF(f,1:N,2) = DNu(1:N,2,2)
c
c  ...projected coordinates are Nu, so IdecTF=true for all faces
      IdecTF = .TRUE.
c
      end subroutine BlendProjectPyraTF
c----------------------------------------------------------------------

      subroutine ProjectPyraLamTF(Lam,DLam, LampF,DLampF,IdecTF)
c
      implicit none
      integer :: N,f
      logical, intent(out) :: IdecTF
      double precision, intent(in)  :: Lam(5),DLam(1:3,5)
      double precision, intent(out) :: LampF(4,0:2),DLampF(4,3,0:2)
c
c  ...Info from module element_data - coordinates,connectivities:
c      V=((0,0,0),(1,0,0),(1,1,0),(0,1,0),(0,0,1))=>(v1,v2,v3,v4,v5)
c      F_part2=>((v1->v2->v5),(v2->v3->v5),(v4->v3->v5),(v1->v4->v5))
c
      N=3
c
c  ...f=1 --> face125 with local orientation v1->v2->v5
      f=1
c     ...locally oriented pair representing projection
      LampF(f,0) = Lam(1); LampF(f,1) = Lam(2); LampF(f,2) = Lam(5)
      DLampF(f,1:N,0) = DLam(1:N,1); DLampF(f,1:N,1) = DLam(1:N,2);
                                          DLampF(f,1:N,2) = DLam(1:N,5)
c  ...f=2 --> face235 with local orientation v2->v3->v5
      f=2
c     ...locally oriented pair representing projection
      LampF(f,0) = Lam(2); LampF(f,1) = Lam(3); LampF(f,2) = Lam(5)
      DLampF(f,1:N,0) = DLam(1:N,2); DLampF(f,1:N,1) = DLam(1:N,3);
                                          DLampF(f,1:N,2) = DLam(1:N,5)
c  ...f=3 --> face345 with local orientation v4->v3->v5
      f=3
c     ...locally oriented pair representing projection
      LampF(f,0) = Lam(4); LampF(f,1) = Lam(3); LampF(f,2) = Lam(5)
      DLampF(f,1:N,0) = DLam(1:N,4); DLampF(f,1:N,1) = DLam(1:N,3);
                                          DLampF(f,1:N,2) = DLam(1:N,5)
c  ...f=4 --> face415 with local orientation v1->v4->v5
      f=4
c     ...locally oriented pair representing projection
      LampF(f,0) = Lam(1); LampF(f,1) = Lam(4); LampF(f,2) = Lam(5)
      DLampF(f,1:N,0) = DLam(1:N,1); DLampF(f,1:N,1) = DLam(1:N,4);
                                          DLampF(f,1:N,2) = DLam(1:N,5)
c
c  ...projected coordinates are Lam, so IdecTF=false for all faces
      IdecTF = .FALSE.
c
      end subroutine ProjectPyraLamTF







c Routines:
c  - OrientE
c  - OrientQuad
c  - OrientTri
c----------------------------------------------------------------------
c Routines representing the local to global transformations of edges,
c triangle faces and quadrilateral faces
c----------------------------------------------------------------------
      subroutine OrientE(S,DS,Nori,N, GS,GDS)
c
      implicit none
      integer, intent(in) :: Nori, N
      integer :: Or(0:1,0:1)
      double precision, intent(in)  :: S(0:1),DS(1:N,0:1)
      double precision, intent(out) :: GS(0:1),GDS(1:N,0:1)
c
c     Or(1) - Is the global axis aligned with the (parallel) local one?
c
c     GS(0:1)=S(Or(Nori,0:1))
c
c  ...Nori=0 => (s0,s1)->(s0,s1)
      Or(0,0) = 0; Or(0,1) = 1
c  ...Nori=1 => (s0,s1)->(s1,s0)
      Or(1,0) = 1; Or(1,1) = 0
c
c  ...Local-to-global transformation
      GS(0) = S(Or(Nori,0));           GS(1) = S(Or(Nori,1))
      GDS(1:N,0) = DS(1:N,Or(Nori,0)); GDS(1:N,1) = DS(1:N,Or(Nori,1))
c
      end subroutine OrientE
c----------------------------------------------------------------------
      subroutine OrientQuad(ST,DST,Nori,Idec,N, GST,GDST,GIdec)
c
      implicit none
      integer, intent(in) :: Nori, N
      integer :: OrPa(0:7,1:2),OrGS(0:7,0:1),OrGT(0:7,0:1)
      logical, intent(in)  :: Idec(2)
      logical, intent(out) :: GIdec(2)
      double precision, intent(in)  :: ST(1:2,0:1),DST(1:N,1:2,0:1)
      double precision, intent(out) :: GST(1:2,0:1),GDST(1:N,1:2,0:1)
c
c     OrPa - Order of the pairs S and T (swapping)
c     OrGS(1) - Is the global S axis aligned with the (parallel) local?
c     OrGT(1) - Is the global T axis aligned with the (parallel) local?
c
c     GST(1,0:1)=GS(0:1)=ST(OrPa(Nori,1),OrGS(Nori,0:1))
c     GST(2,0:1)=GT(0:1)=ST(OrPa(Nori,2),OrGT(Nori,0:1))
c
c  ...Nori=0 => ((s0,s1),(t0,t1))->((s0,s1),(t0,t1))
      OrPa(0,1) = 1; OrPa(0,2) = 2 
      OrGS(0,0) = 0; OrGS(0,1) = 1
      OrGT(0,0) = 0; OrGT(0,1) = 1
c  ...Nori=1 => ((s0,s1),(t0,t1))->((t0,t1),(s1,s0))
      OrPa(1,1) = 2; OrPa(1,2) = 1 
      OrGS(1,0) = 0; OrGS(1,1) = 1
      OrGT(1,0) = 1; OrGT(1,1) = 0
c  ...Nori=2 => ((s0,s1),(t0,t1))->((s1,s0),(t1,t0))
      OrPa(2,1) = 1; OrPa(2,2) = 2 
      OrGS(2,0) = 1; OrGS(2,1) = 0
      OrGT(2,0) = 1; OrGT(2,1) = 0
c  ...Nori=3 => ((s0,s1),(t0,t1))->((t1,t0),(s0,s1))
      OrPa(3,1) = 2; OrPa(3,2) = 1 
      OrGS(3,0) = 1; OrGS(3,1) = 0
      OrGT(3,0) = 0; OrGT(3,1) = 1
c  ...Nori=4 => ((s0,s1),(t0,t1))->((t0,t1),(s0,s1))
      OrPa(4,1) = 2; OrPa(4,2) = 1 
      OrGS(4,0) = 0; OrGS(4,1) = 1
      OrGT(4,0) = 0; OrGT(4,1) = 1
c  ...Nori=5 => ((s0,s1),(t0,t1))->((s1,s0),(t0,t1))
      OrPa(5,1) = 1; OrPa(5,2) = 2 
      OrGS(5,0) = 1; OrGS(5,1) = 0
      OrGT(5,0) = 0; OrGT(5,1) = 1
c  ...Nori=6 => ((s0,s1),(t0,t1))->((t1,t0),(s1,s0))
      OrPa(6,1) = 2; OrPa(6,2) = 1 
      OrGS(6,0) = 1; OrGS(6,1) = 0
      OrGT(6,0) = 1; OrGT(6,1) = 0
c  ...Nori=7 => ((s0,s1),(t0,t1))->((s0,s1),(t1,t0))
      OrPa(7,1) = 1; OrPa(7,2) = 2 
      OrGS(7,0) = 0; OrGS(7,1) = 1
      OrGT(7,0) = 1; OrGT(7,1) = 0
c
c     GST=[GST(1,0),GST(1,1); GST(2,0),GST(2,1)]
c  ...Local-to-global transformation
      GST(1,0) = ST(OrPa(Nori,1),OrGS(Nori,0))
      GST(1,1) = ST(OrPa(Nori,1),OrGS(Nori,1))
      GST(2,0) = ST(OrPa(Nori,2),OrGT(Nori,0))
      GST(2,1) = ST(OrPa(Nori,2),OrGT(Nori,1))
c
      GDST(1:N,1,0) = DST(1:N,OrPa(Nori,1),OrGS(Nori,0))
      GDST(1:N,1,1) = DST(1:N,OrPa(Nori,1),OrGS(Nori,1))
      GDST(1:N,2,0) = DST(1:N,OrPa(Nori,2),OrGT(Nori,0))
      GDST(1:N,2,1) = DST(1:N,OrPa(Nori,2),OrGT(Nori,1))
c
      GIdec(1) = Idec(OrPa(Nori,1)); GIdec(2) = Idec(OrPa(Nori,2))
c
      end subroutine OrientQuad
c
c----------------------------------------------------------------------
      subroutine OrientTri(S,DS,Nori,N, GS,GDS)
c
      implicit none
      integer, intent(in) :: Nori, N
      integer :: Or(0:5,0:2)
      double precision, intent(in)  :: S(0:2),DS(1:N,0:2)
      double precision, intent(out) :: GS(0:2),GDS(1:N,0:2)
c
c     GS(0:2)=S(Or(Nori,0:2))
c
c  ...Nori=0 => (s0,s1,s2)->(s0,s1,s2)
      Or(0,0) = 0; Or(0,1) = 1; Or(0,2) = 2
c  ...Nori=1 => (s0,s1,s2)->(s1,s2,s0)
      Or(1,0) = 1; Or(1,1) = 2; Or(1,2) = 0
c  ...Nori=2 => (s0,s1,s2)->(s2,s0,s1)
      Or(2,0) = 2; Or(2,1) = 0; Or(2,2) = 1
c  ...Nori=3 => (s0,s1,s2)->(s0,s2,s1)
      Or(3,0) = 0; Or(3,1) = 2; Or(3,2) = 1
c  ...Nori=4 => (s0,s1,s2)->(s1,s0,s2)
      Or(4,0) = 1; Or(4,1) = 0; Or(4,2) = 2
c  ...Nori=5 => (s0,s1,s2)->(s2,s1,s0)
      Or(5,0) = 2; Or(5,1) = 1; Or(5,2) = 0
c
c  ...Local-to-global transformation
      GS(0) = S(Or(Nori,0)) 
      GS(1) = S(Or(Nori,1))
      GS(2) = S(Or(Nori,2))
c
      GDS(1:N,0) = DS(1:N,Or(Nori,0))
      GDS(1:N,1) = DS(1:N,Or(Nori,1))
      GDS(1:N,2) = DS(1:N,Or(Nori,2))
c
      end subroutine OrientTri







c Routines:
c  - PolyLegendre
c  - PolyILegendre
c  - PolyJacobi
c  - PolyIJacobi
c  - HomLegendre
c  - HomILegendre
c  - HomJacobi
c  - HomIJacobi
c
c----------------------------------------------------------------------
c
c     routine name      - PolyLegendre
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of shifted scaled
c                         Legendre polynomials
c
c     arguments:
c
c     in:
c             X         - coordinate from [0,1]
c             T         - scaling parameter
c             Nord      - polynomial order
c
c     out:
c             P         - polynomial values
c
c----------------------------------------------------------------------
c
      subroutine PolyLegendre(X,T,Nord, P)
c
      implicit none
      integer,          intent(in)  ::                             Nord
      double precision, intent(in)  ::                              X,T
      double precision, intent(out) ::                        P(0:Nord)
      integer ::                                               i,iprint
      double precision ::                                          tt,y
c
      iprint=0
c
c  ...i stands for the order of the polynomial, stored in P(i)
c  ...lowest order case (order 0)
      P(0) = 1.d0
c  ...first order case (order 1) if necessary
      if (Nord.ge.1) then
        y = 2.d0*X - T
        P(1) = y
      endif
c  ...higher order if necessary - use recurrence formula
      if (Nord.ge.2) then
        tt = T**2
        do i=2,Nord
          P(i) = (2*i-1)*y*P(i-1) - (i-1)*tt*P(i-2)
          P(i) = P(i)/i
        enddo
      endif
c
c  ...catching problems (debugging)
      if (iprint.eq.1) then
        write(*,7002) Nord, X,T
 7002   format('PolyLegendre: Nord = ',i2,' X,T = ',2F8.3)
        do i=0,Nord
          write(*,7003) i,P(i)
 7003     format('i = ',i2,' P = ',e25.15)
        enddo
c        call pause
      endif
c
      end subroutine PolyLegendre
c
c----------------------------------------------------------------------
c
c     routine name      - PolyILegendre
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of shifted scaled
c                         integrated Legendre polynomials and their
c                         derivatives starting with p=2
c
c     arguments:
c
c     in:
c             X         - coordinate from [0,1]
c             T         - scaling parameter
c             Nord      - polynomial order
c             Idec      - decision flag to compute:
c                       = FALSE polynomials with x and t derivatives
c                       = TRUE  polynomials with x derivatives only
c
c     out:
c             L         - polynomial values
c             P         - derivatives in x
c             R         - derivatives in t
c
c----------------------------------------------------------------------
c
      subroutine PolyILegendre(X,T,Nord,Idec, L,P,R)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                             Nord
      double precision, intent(in)  ::                              X,T
      double precision, intent(out) ::    L(2:Nord),P(Nord-1),R(Nord-1)
      integer ::                                         i,ifact,iprint
      double precision ::                            ptemp(0:Nord),tt,y
c
      iprint=0
c
c  ...calling Legendre for required information
      call PolyLegendre(X,T,Nord, ptemp)
      P = ptemp(1:Nord-1)
c
c  ...Integrated polynomial of order i is stored in L(i)
      tt = T**2
c
c  ...simplified case: no need to compute R
      if (Idec) then
        do i=2,Nord
          ifact = 4*i-2
          L(i) = (ptemp(i) - tt*ptemp(i-2))/ifact
        enddo
c
c  ...general case: compute R
      else
        do i=2,Nord
          ifact = 4*i-2
          L(i) = (ptemp(i) - tt*ptemp(i-2))/ifact
          R(i-1) = -(ptemp(i-1)+T*ptemp(i-2))/2
        enddo
      endif
c
c  ...catching problems (debugging)
      if (iprint.eq.1) then
        write(*,7002) Idec,Nord, X,T
 7002   format('PolyILegendre: Idec = ',i1,' Nord = ',i2,
     .         ' X,T = ',2F8.3)
        do i=2,Nord
          select case(Idec)
          case(.TRUE.)
            write(*,7003) i,L(i),P(i)
 7003       format('i = ',i2,' L,P = ',2e25.15)
          case default
            write(*,7004) i,L(i),P(i),R(i)
 7004       format('i = ',i2,' L,P,R, = ',3e25.15)
          end select
        enddo
c        call pause
      endif
c
      end subroutine PolyILegendre
c
c
c----------------------------------------------------------------------
c
c     routine name      - PolyJacobi
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of shifted scaled
c                         Jacobi polynomials P^\alpha_i. Result is a
c                         'half' of a  matrix with each row
c                         associated to a fixed alpha. Alpha grows
c                         by 2 in each row.
c
c     arguments:
c
c     in:
c             X         - coordinate from [0,1]
c             T         - scaling parameter
c             Nord      - max polynomial order
c             Minalpha  - first row value of alpha (integer)
c
c     out:
c             P         - polynomial values
c
c----------------------------------------------------------------------
c
      subroutine PolyJacobi(X,T,Nord,Minalpha, P)
c
      implicit none
      integer,          intent(in)  ::                    Nord,Minalpha
      double precision, intent(in)  ::                              X,T
      double precision, intent(out) ::                 P(0:Nord,0:Nord)
      integer :: minI,maxI,i,ni,a,aa,al,ai,bi,ci,di,iprint,alpha(0:Nord)
      double precision ::                                          y,tt
c
c  ...clearly (minI,maxI)=(0,Nord), but the syntax is written as it is
c     because it reflects how the indexing is called from outside
      minI = 0; maxI = minI+Nord
c
c  ...in our work Minalpha>=1
      iprint = 0
      if (Minalpha.lt.1) then
        write(*,7001) Minalpha
 7001   format('PolyJacobi: Minalpha = ',i3)
c        stop 1
      endif
c
c  ...create vector alpha first
      do a=minI,maxI
         alpha(a) = Minalpha+2*(a-minI)
      enddo
c
c  ...initiate first column (order 0)
      P(minI:maxI,0) = 1.d0
c  ...initiate second column (order 1) if necessary
      if (Nord.ge.1) then
        y = 2.d0*X - T
        P(minI:maxI-1,1) = y+alpha(minI:maxI-1)*X
      endif
c  ...fill the last columns if necessary
      if (Nord.ge.2) then
        tt = T**2
        ni = -1
        do a=minI,maxI-2
          al=alpha(a)
          aa = al**2
          ni=ni+1
c      ...use recursion in order, i, to compute P^alpha_i for i>=2
          do i=2,Nord-ni
            ai = 2*i*(i+al)*(2*i+al-2)
            bi = 2*i+al-1
            ci = (2*i+al)*(2*i+al-2)
            di = 2*(i+al-1)*(i-1)*(2*i+al)
c
            P(a,i) = bi*(ci*y+aa*T)*P(a,i-1)-di*tt*P(a,i-2)
            P(a,i) = P(a,i)/ai
          enddo
        enddo
      endif
c
c  ...catching problems (debugging)
      if (iprint.eq.1) then
        write(*,7003) Nord, X,T
 7003   format('PolyJacobi: Nord = ',i2,' X,T = ',2F8.3)
        do a=minI,maxI
          write(*,7004) a,P(a,0:Nord)
 7004     format(' P(',i2,',0:Nord) = ',10e12.5)
        enddo
c        call pause
      endif
c
      end subroutine PolyJacobi
c
c----------------------------------------------------------------------
c
c     routine name      - PolyIJacobi
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of integrated
c                         shifted scaled Jacobi polynomials and
c                         their derivatives starting with p=1
c                         Result is 'half' of a  matrix
c                         with each row  associated to a fixed alpha.
c                         Alpha grows by 2 in each row.
c
c     arguments:
c
c     in:
c             X         - coordinate from [0,1]
c             T         - scaling parameter
c             Nord      - max polynomial order
c             Minalpha  - first row value of alpha (integer)
c             Idec      - decision flag to compute:
c                       = FALSE polynomials with x and t derivatives
c                       = TRUE  polynomials with x derivatives only
c
c     out:
c             L        - polynomial values
c             P        - derivatives in x (Jacobi polynomials)
c             R        - derivatives in t
c
c----------------------------------------------------------------------
c
      subroutine PolyIJacobi(X,T,Nord,Minalpha,Idec, L,P,R)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                    Nord,Minalpha
      double precision, intent(in)  ::                              X,T
      double precision, intent(out) ::                 L(1:Nord,1:Nord),
     .                            P(1:Nord,0:Nord-1),R(1:Nord,0:Nord-1)
      integer ::             minI,maxI,i,ni,a,al,tia,tiam1,tiam2,iprint,
     .                                                    alpha(1:Nord)
      double precision ::            ai,bi,ci,tt,ptemp(1:Nord+1,0:Nord)
c
      iprint=0
c
c  ...clearly (minI,maxI)=(1,Nord), but the syntax is written as it is
c     because it reflects how the indexing is called from outside
      minI = 1; maxI = minI+Nord-1
c
c  ...in our work Minalpha>=1
      if (Minalpha.lt.1) then
        write(*,7001) Minalpha
 7001   format('PolyIJacobi: Minalpha = ',i3)
c        stop 1
      endif
c
c  ...calling Jacobi for required information
      call PolyJacobi(X,T,Nord,Minalpha, ptemp)
c  ...define P. Note that even though P is defined at all entries,
c     because of the way Jacobi computes ptemp, only the necessary entries,
c     and those on the first subdiagonal (which are never used later)
c     are actually accurate.
      P = ptemp(minI:maxI,0:Nord-1)
c
c  ...create vector alpha first
      do a=minI,maxI
         alpha(a) = Minalpha+2*(a-minI)
      enddo
c
c  ...initiate first column (order 1 in L)
      L(minI:maxI,1) = X
c
c  ...simplified case, do not compute R
      if (Idec) then
c  ...fill the last columns if necessary
        if (Nord.ge.2) then
          tt = T**2
          ni = -1
          do a=minI,maxI-1
            al=alpha(a)
            ni = ni+1
            do i=2,Nord-ni
              tia = i+i+al
              tiam1 = tia-1
              tiam2 = tia-2
              ai = dble(i+al)/(tiam1*tia)
              bi = dble(al)/(tiam2*tia)
              ci = (i-1.d0)/(tiam2*tiam1)
c
              L(a,i) = ai*ptemp(a,i)+bi*T*ptemp(a,i-1)
     .              -ci*tt*ptemp(a,i-2)
c              P(a,i-1) =  ptemp(a,i-1)
            enddo
          enddo
        endif
c
c  ...general case; compute R
      else
      R(minI:maxI,0) = 0.d0
c  ...fill the last columns if necessary
        if (Nord.ge.2) then
          tt = T**2
          ni = -1
          do a=minI,maxI-1
            al=alpha(a)
            ni = ni+1
            do i=2,Nord-ni
              tia = i+i+al
              tiam1 = tia-1
              tiam2 = tia-2
              ai = dble(i+al)/(tiam1*tia)
              bi = dble(al)/(tiam2*tia)
              ci = (i-1.d0)/(tiam2*tiam1)
c
              L(a,i) = ai*ptemp(a,i)+bi*T*ptemp(a,i-1)
     .              -ci*tt*ptemp(a,i-2)
c              P(a,i-1) =  ptemp(a,i-1)
              R(a,i-1) = -(i-1)*(ptemp(a,i-1)+T*ptemp(a,i-2))
              R(a,i-1) = R(a,i-1)/tiam2
            enddo
          enddo
        endif
      endif
c
c  ...catching problems (debugging)
      if (iprint.eq.1) then
        write(*,7003) minI,Nord, X,T
 7003   format('PolyIJacobi: minI = ',i2,
     .         ' Nord = ',i2,' X,T = ',2F8.3)
        do a=minI,maxI
          al = alpha(a)
          write(*,7004) a,al,L(a,1:Nord)
 7004     format('a = ',i1,' alpha = ',i2,
     .         ' L(a,1:Nord)   = ',10e12.5)
        enddo
        write(*,*) '  '
        do a=minI,maxI
          al = alpha(a)
          write(*,7005) a,al,P(a,0:Nord-1)
 7005     format('a = ',i1,' alpha = ',i2,
     .         ' P(a,0:Nord-1) = ',10e12.5)
        enddo
        if (.NOT.Idec) then
          write(*,*) '  '
          do a=minI,maxI
            al = alpha(a)
            write(*,7006) a,al,R(a,0:Nord-1)
 7006       format('a = ',i1,' alpha = ',i2,
     .             ' R(a,0:Nord-1) = ',10e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine PolyIJacobi
c
c----------------------------------------------------------------------
c
c     routine name      - HomLegendre
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of homogenized
c                         Legendre polynomials
c
c     arguments:
c
c     in:
c             S         - affine(like) coordinates
c             Nord      - polynomial order
c
c     out:
c             HomP      - polynomial values
c
c----------------------------------------------------------------------
c
      subroutine HomLegendre(S,Nord, HomP)
c
      implicit none
      integer,          intent(in)  ::                             Nord
      double precision, intent(in)  ::                           S(0:1)
      double precision, intent(out) ::                     HomP(0:Nord)
c
c  ...simply the definition of homogenized polynomials
      call PolyLegendre(S(1),S(0)+S(1),Nord, HomP)
c
      end subroutine HomLegendre
c
c
c----------------------------------------------------------------------
c
c     routine name      - HomILegendre
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of homogenized
c                         integrated Legendre polynomials and their
c                         gradient (wrt to affine like coordinates)
c
c     arguments:
c
c     in:
c             S         - (s0,s1) affine(like) coordinates
c             DS        - gradients of S (in R^N)
c             Nord      - polynomial order
c             Idec      - decision flag to compute:
c                         = FALSE s0+s1 != 1 -> general case
c                         = TRUE  s0+s1  = 1 -> simple case
c             N         - number of spatial dimensions (R^N)
c
c     out:
c             HomL        - polynomial values
c             DHomL       - gradients of L in R^N
c
c----------------------------------------------------------------------
c
      subroutine HomILegendre(S,DS,Nord,Idec,N, HomL,DHomL)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                           Nord,N
      double precision, intent(in)  ::               S(0:1),DS(1:N,0:1)
      double precision, intent(out) ::   HomL(2:Nord),DHomL(1:N,2:Nord)
      integer ::                                                      i
      double precision ::       homP(1:Nord-1),homR(1:Nord-1),DS01(1:N)
c
c  ...Idec is the flag to compute x AND t derivatives
c  ...If sum of S equal 1 -> Idec=.TRUE.
      if (Idec) then
        call PolyILegendre(S(1),1.d0,Nord,Idec, HomL,homP,homR)
        do i=2,Nord
          DHomL(1:N,i) = homP(i-1)*DS(1:N,1)
        enddo
c
c  ...If sum of S different from 1 -> Idec=.FALSE.
      else
        call PolyILegendre(S(1),S(0)+S(1),Nord,Idec, HomL,homP,homR)
        DS01 = DS(1:N,0)+DS(1:N,1)
        do i=2,Nord
          DHomL(1:N,i) = homP(i-1)*DS(1:N,1)+homR(i-1)*DS01
        enddo
      endif
c
      end subroutine HomILegendre
c
c
c----------------------------------------------------------------------
c
c     routine name      - HomJacobi
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of homogenized
c                         Jacobi polynomials P^\alpha_i. Result is a
c                         'half' of a  matrix with each row
c                         associated to a fixed alpha. Alpha grows
c                         by 2 in each row.
c
c     arguments:
c
c     in:
c             S         - affine(like) coordinates
c             Nord      - max polynomial order
c             Minalpha  - first row value of alpha (integer)
c
c     out:
c             HomP      - polynomial values
c
c----------------------------------------------------------------------
c
      subroutine HomJacobi(S,Nord,Minalpha, HomP)
c
      implicit none
      integer,          intent(in)  ::                    Nord,Minalpha
      double precision, intent(in)  ::                           S(0:1)
      double precision, intent(out) ::              HomP(0:Nord,0:Nord)
      integer ::                                              minI,maxI
c
c  ...clearly (minI,maxI)=(0,Nord), but the syntax is written as it is
c     because it reflects how the indexing is called from outside
      minI = 0; MaxI = MinI+Nord
c
c  ...simply the definition of homogenized polynomials
      call PolyJacobi(S(1),S(0)+S(1),Nord,Minalpha, HomP)
c
      end subroutine HomJacobi
c
c
c----------------------------------------------------------------------
c
c     routine name      - HomIJacobi
c
c----------------------------------------------------------------------
c
c     latest revision:  - Oct 14
c
c     purpose:          - routine returns values of integrated
c                         homogenized Jacobi polynomials and
c                         their gradients.
c                         Result is 'half' of a  matrix
c                         with each row  associated to a fixed alpha.
c                         Alpha grows by 2 in each row.
c
c     arguments:
c
c     in:
c             S         - (s0,s1) affine(like) coordinates
c             DS        - gradients of S (in R^N)
c             Nord      - max polynomial order
c             Minalpha  - first row value of alpha (integer)
c             Idec      - decision flag to compute:
c                         = FALSE s0+s1 != 1 -> general case
c                         = TRUE  s0+s1  = 1 -> simple case
c             N         - number of spatial dimensions (R^N)
c
c     out:
c             HomL      - polynomial values
c             DHomL     - derivatives in x (Jacobi polynomials)
c
c----------------------------------------------------------------------
c
      subroutine HomIJacobi(S,DS,Nord,Minalpha,Idec,N, HomL,DHomL)
c
      implicit none
      logical,          intent(in)  ::                             Idec
      integer,          intent(in)  ::                  Nord,Minalpha,N
      double precision, intent(in)  ::               S(0:1),DS(1:N,0:1)
      double precision, intent(out) ::              HomL(1:Nord,1:Nord),
     .                                         DHomL(1:N,1:Nord,1:Nord)
      integer ::                                       minI,maxI,a,i,ni
      double precision ::   homP(1:Nord,0:Nord-1),homR(1:Nord,0:Nord-1),
     .                                                          DS01(N)
c
c  ...clearly (minI,maxI)=(1,Nord), but the syntax is written as it is
c     because it reflects how the indexing is called from outside
      minI = 1; maxI = minI+Nord-1
c
c  ...Idec is the flag to compute x AND t derivatives
c  ...If sum of S equal 1 -> Idec=.TRUE.
      if (Idec) then
        call PolyIJacobi(S(1),1.d0,Nord,Minalpha,Idec, HomL,homP,homR)
        ni = -1
        do a=minI,maxI
          ni = ni+1
          do i=1,Nord-ni
            DHomL(1:N,a,i) = homP(a,i-1)*DS(1:N,1)
          enddo
        enddo
c
c  ...If sum of S different from 1 -> Idec=.FALSE.
      else
        call PolyIJacobi(S(1),S(0)+S(1),Nord,Minalpha,Idec,
     .                                                 HomL,homP,homR)
        ni = -1
        DS01 = DS(1:N,0)+DS(1:N,1)
        do a=minI,maxI
          ni = ni+1
          do i=1,Nord-ni
            DHomL(1:N,a,i) = homP(a,i-1)*DS(1:N,1)+homR(a,i-1)*DS01
          enddo
        enddo
      endif
c
      end subroutine HomIJacobi
c







c Routines:
c  - shape1DHSeg
c  - shape1DQSeg
c
c----------------------------------------------------------------------
c
c     routine name      - shape1DHSeg
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of 1D Segment H1
c                         shape functions
c
c     arguments:
c
c     in:
c       Xi              - master segment coordinate
c       Nord            - polynomial order for the nodes (H1 sense)
c       Nsize           - relevant sizes of local arrays
c
c     out:
c       NrdofH          - number of dof
c       ShapH           - values of the shape functions
c       GradH           - gradient of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1DHSeg(Xi,Nord,Nsize, NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in ) :: Nord,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: iprint,N,m,v,ndofE,minI,maxI,i
      logical :: IdecE
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapH(Nsize(2)),GradH(Nsize(2))
      double precision :: Mu(0:1),DMu(0:1),MubV(2),DMubV(2)
      double precision :: phiE(2:Nsize(1)),DphiE(2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=1
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineSegment(Xi, Mu,DMu)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendSegV(Mu,DMu, MubV,DMubV)
      do v=1,2
        m=m+1
c
        ShapH(m) = MubV(v)
        GradH(m) = DMubV(v)
      enddo
c
c  ...BUBBLE FUNCTIONS
      ndofE = Nord-1
      if (ndofE.gt.0) then
c    ...local parameters
        minI  = 2
        maxI  = Nord
        IdecE = .TRUE.
c    ...construct the shape functions
        call AncPhiE(Mu,DMu,Nord,IdecE,N,
     .                                phiE(minI:maxI),DphiE(minI:maxI))
        do i=minI,maxI
          m=m+1
c
          ShapH(m) = phiE(i)
          GradH(m) = DphiE(i)
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi,Nord
 7001   format('shape1DHSeg: Xi = ',f8.3,/,
     .         'Norder  = ',i2)
c
        write(*,*) 'VERTEX SHAPE FUNCTIONS = '
        do v=1,2
          m=v
          write(*,7002) m,ShapH(m),GradH(m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,e12.5)
        enddo
        if (ndofE.gt.0) then
          write(*,*) 'BUBBLE FUNCTIONS = '
          do i=1,ndofE
            m=m+1
            write(*,7002) m,ShapH(m),GradH(m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape1DHSeg
c
c
c----------------------------------------------------------------------
c
c     routine name      - shape1DQSeg
c
c----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Aor 17
c
c     purpose:          - routine returns values of 1D Segment L2
c                         shape functions
c
c     arguments:
c
c     in:
c       Xi              - master segment coordinate
c       Nord            - polynomial order for the nodes (H1 sense)
c       Nsize           - relevant sizes of local arrays
c
c     out:
c       NrdofQ          - number of dof
c       ShapQ           - values of the shape functions
c
c----------------------------------------------------------------------
c
      subroutine shape1DQSeg(Xi,Nord,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in ) :: Nord,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: iprint,N,m,ndofE,minI,maxI,i
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Mu(0:1),DMu(0:1),homP(0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=1
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineSegment(Xi, Mu,DMu)
c
c  ...EDGE FUNCTIONS
      ndofE = Nord
      if (ndofE.gt.0) then
c    ...local parameters
        minI = 0
        maxI = Nord-1
c    ...construct the shape functions
        call HomLegendre(Mu,maxI, homP(minI:maxI))
        do i=minI,maxI
          m=m+1
c
          ShapQ(m) = homP(i)
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.eq.1) then
        write(*,7001) Xi,Nord
 7001   format('shape1DQSeg: Xi = ',f8.3,/,
     .         'Norder  = ',i2)
c
        if (ndofE.gt.0) then
          write(*,*) 'EDGE FUNCTIONS = '
          do m=1,ndofE
            write(*,7002) m,ShapQ(m)
 7002       format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape1DQSeg
c






c----------------------------------------------------------------------
c
c   routine name       - decod
c
c----------------------------------------------------------------------
c
c   latest revision    - Aug 07
c
c   purpose            - routine decodes an integer into a sequence
c                        of digits organized from left to right
c
c   arguments :
c     in:
c               Nick   - a nickname to be decoded
c               Mod    - system number
c               N      - number of the digits stored in the nickname
c     out:
c               Narray - the decoded digits
c
c----------------------------------------------------------------------
c
      subroutine decod(Nick,Mod,N, Narray)
c
      implicit none
c
      integer,             intent(in)    :: Nick,Mod,N
      integer,dimension(N),intent(inout) :: Narray
c
c  ...local variables      
      integer :: i,nick1,nick2
c
      nick1 = Nick    
      do i=1,N-1
        nick2 = nick1/Mod
        Narray(N+1-i) = nick1 - nick2*Mod
        nick1 = nick2
      enddo
      Narray(1)=nick1
c
c
      end subroutine decod
c






c----------------------------------------------------------------------
c
c   routine name       - encod
c
c----------------------------------------------------------------------
c
c   computer           - machine independent
c
c   latest revision    - Aug 07
c
c   purpose            - routine encodes a sequence of digits
c                        into a nickname from left to right
c
c   arguments :
c     in:
c               Narray - digits to be encoded
c               Mod    - system number
c               N      - number of the digits stored in the nickname
c     out:
c               Nick   - the nickname 
c
c   required  routines - 
c
c----------------------------------------------------------------------
c
      subroutine encod(Narray,Mod,N, Nick)
c
      dimension Narray(N)
c
      Nick=Narray(1)    
      do i=2,N
        Nick = Nick*Mod + Narray(i)
      enddo
c
c
      end
c
c










c Routines:
c  - shape3DHHexa
c  - shape3DEHexa
c  - shape3DVHexa
c  - shape3DQHexa
c--------------------------------------------------------------------
c
c     routine name      - shape3DHHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron element
c                         H1 shape functions and their derivatives
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHHexa(Xi,Nord,NoriE,NoriF,Nsize, 
     .                                              NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(19),NoriE(12),NoriF(6),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: i,j,k,m,v,e,f,N,ndofE,nordF(2),ndofF
      integer :: nordB(3),ndofB,iprint
      logical :: IdecE,IdecF(2),GIdecF(2),IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
      double precision :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision :: MubV(1:8,1:3),DMubV(1:8,1:3,1:3)
      double precision :: MubE(1:12,1:2),DMubE(1:12,1:3,1:2)
      double precision :: MupE(1:12,0:1),DMupE(1:12,1:3,0:1)
      double precision :: GMupE(0:1),GDMupE(1:3,0:1)
      double precision :: MubF(1:6),DMubF(1:6,1:3)
      double precision :: MupF(1:6,1:2,0:1),DMupF(1:6,1:3,1:2,0:1)
      double precision :: GMupF(1:2,0:1),GDMupF(1:3,1:2,0:1)
      double precision :: phiE(2:Nsize(1)),DphiE(1:3,2:Nsize(1))
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(1:3,2:Nsize(1),2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates
      call AffineHexahedron(Xi, Mu,DMu)
c
c  ...First the vertices
c  ...call the blending functions
      call BlendHexaV(Mu,DMu, MubV,DMubV)
      do v=1,8
        m=m+1
        ShapH(m) = MubV(v,1)*MubV(v,2)*MubV(v,3)
        GradH(1:N,m) = MubV(v,1)*MubV(v,2)*DMubV(v,1:N,3)
     .               + MubV(v,1)*DMubV(v,1:N,2)*MubV(v,3)
     .               + DMubV(v,1:N,1)*MubV(v,2)*MubV(v,3)
      enddo
c
c  ...Second the edges
c  ...call the blending and projections
      call BlendProjectHexaE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
      do e=1,12
        ndofE=Nord(e)-1
        if (ndofE.gt.0) then        
c      ...orient first
          call OrientE(MupE(e,0:1),DMupE(e,1:N,0:1),NoriE(e),N, 
     .                                                 GMupE,GDMupE)
c      ...construct the shape functions
          call AncPhiE(GMupE,GDMupE,Nord(e),IdecE,N, 
     .                         phiE(2:Nord(e)),DphiE(1:N,2:Nord(e)))
          do i=2,Nord(e)
            m=m+1
            ShapH(m) = MubE(e,1)*MubE(e,2)*phiE(i)
            GradH(1:N,m) = MubE(e,1)*MubE(e,2)*DphiE(1:N,i)
     .                   + MubE(e,1)*DMubE(e,1:N,2)*phiE(i)
     .                   + DMubE(e,1:N,1)*MubE(e,2)*phiE(i)
          enddo
        endif
      enddo
c
c  ...Third the faces
c  ...call the blending and projections
      call BlendProjectHexaF(Mu,DMu, MubF,DMubF,MupF,DMupF,IdecF)
      do f=1,6
        call decod(Nord(12+f),MODORDER,2, nordF)
        ndofF = (nordF(1)-1)*(nordF(2)-1)
        if (ndofF.gt.0) then        
c      ...orient first
          call OrientQuad(MupF(f,1:2,0:1),DMupF(f,1:N,1:2,0:1),
     .                         NoriF(f),IdecF,N, GMupF,GDMupF,GIdecF)
c      ...orders already take into account the orientations, so
c      ...no need for swapping nordF
c      ...now construct the shape functions
          call AncPhiQuad(GMupF,GDMupF,nordF,GIdecF,N, 
     .                          phiQuad(2:nordF(1),2:nordF(2)),
     .                           DphiQuad(1:N,2:nordF(1),2:nordF(2)))
          do j=2,nordF(2)
            do i=2,nordF(1)
              m=m+1
              ShapH(m) = MubF(f)*phiQuad(i,j)
              GradH(1:N,m) = MubF(f)*DphiQuad(1:N,i,j)
     .                     + DMubF(f,1:N)*phiQuad(i,j)
            enddo
          enddo
        endif
      enddo
c
c  ...Finally the bubbles
c  ...find order
      call decod(Nord(19),MODORDER,3, nordB)
      ndofB = (nordB(1)-1)*(nordB(2)-1)*(nordB(3)-1)
      IdecB(1) = .TRUE.; IdecB(2) = .TRUE.; IdecB(3) = .TRUE.
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...call phiQuad and phiE - no need to orient
        call AncPhiQuad(Mu(1:2,0:1),DMu(1:N,1:2,0:1),nordB(1:2),
     .                 IdecB(1:2),N, phiQuad(2:nordB(1),2:nordB(2)),
     .                            DphiQuad(1:N,2:nordB(1),2:nordB(2)))
        call AncPhiE(Mu(3,0:1),DMu(1:N,3,0:1),nordB(3),IdecB(3),N, 
     .                        phiE(2:nordB(3)),DphiE(1:N,2:nordB(3)))
        do k=2,nordB(3)
          do j=2,nordB(2)
            do i=2,nordB(1)
              m=m+1
              ShapH(m) = phiQuad(i,j)*phiE(k)
              GradH(1:N,m) = phiQuad(i,j)*DphiE(1:N,k)
     .                     + DphiQuad(1:N,i,j)*phiE(k)
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(1:19),NoriE(1:12),NoriF(1:6),NrdofH
 7001   format('shape3DHHexa: Xi = ',3f8.3,/,
     .         'Norder = ',3(4i2,2x),2i3,2x,4i3,3x,i4,/,
     .         'orient = ',3(4i2,2x),2i3,2x,4i3,/,'NrdofH = ',i3)
        write(*,7010)
 7010   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,8
          m=v
          write(*,7002) m,ShapH(m),GradH(1:3,m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,3e12.5)
        enddo
        do e=1,12
          ndofE = Nord(e)-1
          if (ndofE.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do f=1,6
          call decod(Nord(12+f),MODORDER,2, nordF)
          ndofF = (nordF(1)-1)*(nordF(2)-1)
          if (ndofF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            do j=1,ndofF
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapH(m),GradH(1:3,m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DHHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron element
c                         H(curl) shape functions and their derivatives
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - cur lof the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEHexa(Xi,Nord,NoriE,NoriF,Nsize,
     .                                              NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(19),NoriE(12),NoriF(6),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: i,j,k,ig,jg,kg,m,e,f,fam,a,b,c,ab(2),abc(3),N,iprint
      integer :: ndofE,nordF(2),ndofF(0:1),minF(2),maxF(2),ij(2)
      integer :: nordB(3),ndofB(0:2),minB(3),maxB(3),ijk(3)
      logical :: IdecE,IdecF(2),GIdecF(2),IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(1:3,Nsize(2))
      double precision, intent(out) :: CurlE(1:3,Nsize(2))
      double precision :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision :: MubE(1:12,1:2),DMubE(1:12,1:3,1:2)
      double precision :: MupE(1:12,0:1),DMupE(1:12,1:3,0:1)
      double precision :: GMupE(0:1),GDMupE(1:3,0:1)
      double precision :: MubF(1:6),DMubF(1:6,1:3)
      double precision :: MupF(1:6,1:2,0:1),DMupF(1:6,1:3,1:2,0:1)
      double precision :: GMupF(1:2,0:1),GDMupF(1:3,1:2,0:1)
      double precision :: EE(1:3,0:Nsize(1)-1),curlEE(1:3,0:Nsize(1)-1)
      double precision :: EQuad(1:3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: curlEQuad(1:3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: phiE(2:Nsize(1)),DphiE(1:3,2:Nsize(1))
      double precision :: DTemp(1:3),CTemp(1:3)
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates
      call AffineHexahedron(Xi, Mu,DMu)
c
c  ...First the edges
c  ...call the blending and projections
      call BlendProjectHexaE(Mu,DMu, MubE,DMubE,MupE,DMupE,IdecE)
      do e=1,12
        ndofE=Nord(e)
        if (ndofE.gt.0) then        
c      ...orient first
          call OrientE(MupE(e,0:1),DMupE(e,1:N,0:1),NoriE(e),N, 
     .                                                 GMupE,GDMupE)
c      ...construct the shape functions
          call AncEE(GMupE,GDMupE,Nord(e),IdecE,N, 
     .                    EE(1:N,0:Nord(e)-1),curlEE(1:N,0:Nord(e)-1))
          do i=0,Nord(e)-1
            m=m+1
            DTemp = MubE(e,1)*DMubE(e,1:N,2)+DMubE(e,1:N,1)*MubE(e,2)
            call cross(N,DTemp,EE(1:N,i), CTemp)
            ShapE(1:N,m) = MubE(e,1)*MubE(e,2)*EE(1:N,i)
            CurlE(1:N,m) = CTemp
          enddo
        endif
      enddo
c
c  ...Second the faces
c  ...call the blending and projections
      call BlendProjectHexaF(Mu,DMu, MubF,DMubF,MupF,DMupF,IdecF)
      do f=1,6
c    ...find order
c    ...these already account for orientations
        call decod(Nord(12+f),MODORDER,2, nordF)
c    ...orient the variables first (except the order)
        call OrientQuad(MupF(f,1:2,0:1),DMupF(f,1:N,1:2,0:1),
     .                         NoriF(f),IdecF,N, GMupF,GDMupF,GIdecF)
c    ...loop over the two families
        do fam=0,1
c      ...get the (global) face axis indexing for the family (a,b)
c      ...fam=0->(1,2), fam=1->(2,1)
          ab = cshift((/1,2/),fam); 
          a = ab(1); b = ab(2)
c      ...degrees of freedom (dof) for this family
          ndofF(fam) = nordF(a)*(nordF(b)-1)
c      ...now construct the shape functions if necessary
          if (ndofF(fam).gt.0) then
            call AncEQuad(GMupF(ab,0:1),GDMupF(1:N,ab,0:1),
     .                       nordF(ab),GIdecF(ab),N, 
     .                        EQuad(1:N,0:nordF(a)-1,2:nordF(b)),
     .                         curlEQuad(1:N,0:nordF(a)-1,2:nordF(b)))
c        ...the following manipulations are necessary due to
c        ...some conventions in the code: the outer loop always is
c        ...numbered wrt the second global face axis
            minF(1) = 0; minF(2) = 2
            maxF(1) = nordF(a)-1; maxF(2) = nordF(b)
            minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
            do jg=minF(2),maxF(2)
              do ig=minF(1),maxF(1)
                ij = cshift((/ig,jg/),fam); 
                i = ij(1); j = ij(2)
                m=m+1
                call cross(N,DMubF(f,1:N),EQuad(1:N,i,j), CTemp)
                ShapE(1:N,m) = MubF(f)*EQuad(1:N,i,j)
                CurlE(1:N,m) = MubF(f)*curlEQuad(1:N,i,j)+CTemp
              enddo
            enddo
          endif
        enddo
      enddo
c
c  ...Finally the bubbles
c  ...find order
      call decod(Nord(19),MODORDER,3, nordB)
      IdecB(1) = .TRUE.; IdecB(2) = .TRUE.; IdecB(3) = .TRUE.
c  ...loop over the three families
      do fam=0,2
c    ...get the interior axis indexing for the family (a,b,c)
c    ...fam=0->(1,2,3), fam=1->(2,3,1), fam=2->(3,1,2)
        abc = cshift((/1,2,3/),fam); 
        a = abc(1); b = abc(2); c = abc(3); ab(1) = a; ab(2) = b
c    ...degrees of freedom (dof) for this family
        ndofB(fam) = nordB(a)*(nordB(b)-1)*(nordB(c)-1)
c    ...create the bubbles for this family if necessary
        if (ndofB(fam).gt.0) then
c      ...call EQuad and phiE with appropriate indexing
          call AncEQuad(Mu(ab,0:1),DMu(1:N,ab,0:1),
     .                                nordB(ab),IdecB(ab),N,
     .                     EQuad(1:N,0:nordB(a)-1,2:nordB(b)),
     .                   curlEQuad(1:N,0:nordB(a)-1,2:nordB(b)))
          call AncPhiE(Mu(c,0:1),DMu(1:N,c,0:1),nordB(c),IdecB(c),N, 
     .                        phiE(2:nordB(c)),DphiE(1:N,2:nordB(c)))
c      ...the following manipulations are necessary due to
c      ...some conventions in the code: the outer loop always wrt the 
c      ...third axis, the inner loop wrt to the first axis.
          minB(1) = 0; minB(2) = 2; minB(3) = 2
          maxB(1) = nordB(a)-1; maxB(2) = nordB(b); maxB(3) = nordB(c)
          minB = cshift(minB,-fam); maxB = cshift(maxB,-fam)
          do kg=minB(3),maxB(3)
            do jg=minB(2),maxB(2)
              do ig=minB(1),maxB(1) 
                ijk = cshift((/ig,jg,kg/),fam); 
                i = ijk(1); j = ijk(2); k = ijk(3)
                m=m+1
                call cross(N,DphiE(1:N,k),EQuad(1:N,i,j), CTemp)
                ShapE(1:N,m) = EQuad(1:N,i,j)*phiE(k)
                CurlE(1:N,m) = phiE(k)*curlEQuad(1:N,i,j)+CTemp
              enddo
            enddo
          enddo
        endif
      enddo
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(1:19),
     .                NoriE(1:12),NoriF(1:6),NrdofE
 7001   format('shape3DEHexa: Xi = ',3f8.3,/,
     .         'Norder = ',3(4i2,2x),2i3,2x,4i3,3x,i4,/,
     .         'orient = ',3(4i2,2x),2i3,2x,4i3,/,'NrdofE = ',i3)
        m=0
        do e=1,12
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7003) m,ShapE(1:N,m),CurlE(1:N,m)
 7003         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        do f=1,6
          call decod(Nord(12+f),MODORDER,2, nordF)
          ndofF(0) = nordF(1)*(nordF(2)-1)
          ndofF(1) = (nordF(1)-1)*nordF(2)
          if ((ndofF(0)+ndofF(1)).gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            do j=1,ndofF(0)+ndofF(1)
              m=m+1
              write(*,7003) m,ShapE(1:N,m),CurlE(1:N,m)
            enddo
          endif
        enddo
        if ((ndofB(0)+ndofB(1)+ndofB(2)).gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          do j=1,ndofB(0)+ndofB(1)+ndofB(2)
            m=m+1
            write(*,7003) m,ShapE(1:N,m),CurlE(1:N,m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DEHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron element
c                         H(div) shape functions and their divergences
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVHexa(Xi,Nord,NoriF,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(19),NoriF(6),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: i,j,k,ig,jg,kg,m,f,fam,a,b,c,ab(2),abc(3),N,iprint
      integer :: nordF(2),ndofF
      integer :: nordB(3),ndofB(0:2),minB(3),maxB(3),ijk(3)
      logical :: IdecF(2),GIdecF(2),IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(1:3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision :: MubF(1:6),DMubF(1:6,1:3)
      double precision :: MupF(1:6,1:2,0:1),DMupF(1:6,1:3,1:2,0:1)
      double precision :: GMupF(1:2,0:1),GDMupF(1:3,1:2,0:1)
      double precision :: VQuad(1:3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: divVQuad(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: phiE(2:Nsize(1)),DphiE(1:3,2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates
      call AffineHexahedron(Xi, Mu,DMu)
c
c  ...First the faces
c  ...call the blending and projections
      call BlendProjectHexaF(Mu,DMu, MubF,DMubF,MupF,DMupF,IdecF)
      do f=1,6
c    ...find order
c    ...these already account for orientations
        call decod(Nord(12+f),MODORDER,2, nordF)
c    ...orient the variables first (except the order)
        call OrientQuad(MupF(f,1:2,0:1),DMupF(f,1:N,1:2,0:1),
     .                         NoriF(f),IdecF,N, GMupF,GDMupF,GIdecF)
        ndofF = nordF(1)*nordF(2)
c    ...now construct the shape functions if necessary
        if (ndofF.gt.0) then
          call AncVQuad(GMupF,GDMupF,nordF,GIdecF,N, 
     .                   VQuad(1:N,0:nordF(1)-1,0:nordF(2)-1),
     .                       divVQuad(0:nordF(1)-1,0:nordF(2)-1))
          do j=0,nordF(2)-1
            do i=0,nordF(1)-1
              m=m+1
              ShapV(1:N,m) = MubF(f)*VQuad(1:N,i,j)
              call dot_product(DMubF(f,1:N),VQuad(1:N,i,j), DivV(m))
            enddo
          enddo
        endif
      enddo
c
c  ...Finally the bubbles
c  ...find order
      call decod(Nord(19),MODORDER,3, nordB)
      IdecB(1) = .TRUE.; IdecB(2) = .TRUE.; IdecB(3) = .TRUE.
c  ...loop over the three families
      do fam=0,2
c    ...get the interior axis indexing for the family (a,b,c)
c    ...fam=0->(1,2,3), fam=1->(2,3,1), fam=2->(3,1,2)
        abc = cshift((/1,2,3/),fam); 
        a = abc(1); b = abc(2); c = abc(3); ab(1) = a; ab(2) = b
c    ...degrees of freedom (dof) for this family
        ndofB(fam) = nordB(a)*nordB(b)*(nordB(c)-1)
c    ...create the bubbles for this family if necessary
        if (ndofB(fam).gt.0) then
c      ...call VQuad and phiE with appropriate indexing
          call AncVQuad(Mu(ab,0:1),DMu(1:N,ab,0:1),
     .                                nordB(ab),IdecB(ab),N,
     .                   VQuad(1:N,0:nordB(a)-1,0:nordB(b)-1),
     .                         divVQuad(0:nordB(a)-1,0:nordB(b)-1))
          call AncPhiE(Mu(c,0:1),DMu(1:N,c,0:1),nordB(c),IdecB(c),N, 
     .                        phiE(2:nordB(c)),DphiE(1:N,2:nordB(c)))
c      ...the following manipulations are necessary due to
c      ...some conventions in the code: the outer loop always wrt the 
c      ...third axis, the inner loop wrt to the first axis.
          minB(1) = 0; minB(2) = 0; minB(3) = 2
          maxB(1) = nordB(a)-1; maxB(2) = nordB(b)-1; maxB(3) = nordB(c)
          minB = cshift(minB,-fam); maxB = cshift(maxB,-fam)
          do kg=minB(3),maxB(3)
            do jg=minB(2),maxB(2)
              do ig=minB(1),maxB(1)
                ijk = cshift((/ig,jg,kg/),fam); 
                i = ijk(1); j = ijk(2); k = ijk(3)
                m=m+1
                ShapV(1:N,m) = phiE(k)*VQuad(1:N,i,j)
                call dot_product(DphiE(1:N,k),VQuad(1:N,i,j), DivV(m))
              enddo
            enddo
          enddo
        endif
      enddo
c
c  ...give total degrees of freedom
      NrdofV = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(13:19),NoriF(1:6),NrdofV
 7001   format('shape3DVHexa: Xi = ',3f8.3,/,
     .         'Norder = ',2i3,2x,4i3,3x,i4,/,
     .         'orient = ',2i3,2x,4i3,/,'NrdofV = ',i3)
        m=0
        do f=1,6
          call decod(Nord(12+f),MODORDER,2, nordF)
          ndofF = nordF(1)*nordF(2)
          if (ndofF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            do j=1,ndofF
              m=m+1
              write(*,7003) m,ShapV(1:N,m),DivV(m)
 7003         format('k = ',i3,' ShapV, DivV = ',3e12.5,3x,e12.5)
            enddo
          endif
        enddo
        if ((ndofB(0)+ndofB(1)+ndofB(2)).gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          do j=1,ndofB(0)+ndofB(1)+ndofB(2)
            m=m+1
            write(*,7003) m,ShapV(1:N,m),DivV(m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DVHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron
c                         element L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQHexa(Xi,Nord,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(19),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: i,j,k,m,N,nordB(3),ndofB,iprint
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Mu(1:3,0:1),DMu(1:3,1:3,0:1)
      double precision :: homP(1:3,0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates
      call AffineHexahedron(Xi, Mu,DMu)
c
c  ...There are only bubbles
c  ...find order
      call decod(Nord(19),MODORDER,3, nordB)
      ndofB = nordB(1)*nordB(2)*nordB(3)
c  ...if necessary, create bubbles - always necessary if p,q,r>=1
      if (ndofB.gt.0) then
c    ...call Legendre polynomials - no need to orient
        call HomLegendre(Mu(1,0:1),nordB(1)-1, homP(1,0:nordB(1)-1))
        call HomLegendre(Mu(2,0:1),nordB(2)-1, homP(2,0:nordB(2)-1))
        call HomLegendre(Mu(3,0:1),nordB(3)-1, homP(3,0:nordB(3)-1))
        do k=0,nordB(3)-1
          do j=0,nordB(2)-1
            do i=0,nordB(1)-1
              m=m+1
              ShapQ(m) = homP(1,i)*homP(2,j)*homP(3,k)
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(19),NrdofQ
 7001   format('shap3Q_bric: Xi = ',3f8.3,' Nord = ',i3,/,
     .               'NrdofQ = ',i3)
        do m=1,NrdofQ
          write(*,7002) m,ShapQ(m)
 7002     format('k = ',i3,' ShapQ, = ',e12.5)
        enddo
c        call pause
      endif
c
      end subroutine shape3DQHexa






c Routines:
c  - shape3DHPris
c  - shape3DEPris
c  - shape3DVPris
c  - shape3DQPris
c--------------------------------------------------------------------
c
c     routine name      - shape3DHPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D triangular prism
c                         element H1 shape functions and their derivatives
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHPris(X,Nord,NoriE,NoriF,Nsize, 
     .                                              NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(15),NoriE(9),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: iprint,N,m,v,e,f,i,j,k,nij,nordME,ndofME,nordQE,ndofQE
      integer :: nordTF,ndofTF,nordQF(2),ndofQF,nordB(2),ndofB
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ
      logical :: IdecME,IdecQE,IdecTF,IdecQF(3,2),GIdecQF(2),IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
      double precision :: Mu(0:1),DMu(3,0:1)
      double precision :: NU(0:2),DNu(3,0:2)
      double precision :: MubV(6),DMubV(6,3),NubV(6),DNubV(6,3)
      double precision :: MubME(6),DMubME(6,3)
      double precision :: NupME(6,0:1),DNupME(6,3,0:1)
      double precision :: GNupME(0:1),GDNupME(3,0:1)
      double precision :: NubQE(3),DNubQE(3,3)
      double precision :: MupQE(3,0:1),DMupQE(3,3,0:1)
      double precision :: GMupQE(0:1),GDMupQE(3,0:1)
      double precision :: MubTF(2),DMubTF(2,3)
      double precision :: NupTF(2,0:2),DNupTF(2,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: STpQF(3,2,0:1),DSTpQF(3,3,2,0:1)
      double precision :: GSTpQF(2,0:1),GDSTpQF(3,2,0:1)
      double precision :: phiE(2:Nsize(1)),DphiE(3,2:Nsize(1))
      double precision :: phiTri(2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DphiTri(3,2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(3,2:Nsize(1),2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePrism(X, Mu,DMu,Nu,DNu)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendPrisV(Mu,DMu,Nu,DNu, MubV,DMubV,NubV,DNubV)
      do v=1,6
        m=m+1
        ShapH(m) = NubV(v)*MubV(v)
        GradH(1:N,m) = DNubV(v,1:N)*MubV(v)
     .               + NubV(v)*DMubV(v,1:N)
      enddo
c
c  ...EDGE SHAPE FUNCTIONS
c  ...mixed edges
      call BlendProjectPrisME(Mu,DMu,Nu,DNu,
     .                                 MubME,DMubME,NupME,DNupME,IdecME)
c  ...loop over edges
      do e=1,6
c    ...local parameters
        nordME = Nord(e)
        ndofME = nordME-1
        if (ndofME.gt.0) then
c      ...local parameters (again)
          minI = 2
          maxI = nordME
c      ...orient first
          call OrientE(NupME(e,0:1),DNupME(e,1:N,0:1),NoriE(e),N,
     .                                                   GNupME,GDNupME)
c      ...construct the shape functions
          call AncPhiE(GNupME,GDNupME,nordME,IdecME,N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
            ShapH(m) = phiE(i)*MubME(e)
            GradH(1:N,m) = DphiE(1:N,i)*MubME(e)
     .                   + phiE(i)*DMubME(e,1:N)
          enddo
        endif
      enddo
c  ...quadrilateral edges
      call BlendProjectPrisQE(Mu,DMu,Nu,DNu,
     .                                 NubQE,DNubQE,MupQE,DMupQE,IdecQE)
c  ...loop over edges
      do e=1,3
c    ...local parameters
        nordQE = Nord(6+e)
        ndofQE = nordQE-1
        if (ndofQE.gt.0) then
c      ...local parameters (again)
          minI = 2
          maxI = nordQE
c      ...orient first
          call OrientE(MupQE(e,0:1),DMupQE(e,1:N,0:1),NoriE(6+e),N,
     .                                                   GMupQE,GDMupQE)
c      ...construct the shape functions
          call AncPhiE(GMupQE,GDMupQE,nordQE,IdecQE,N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
            ShapH(m) = phiE(i)*NubQE(e)
            GradH(1:N,m) = DphiE(1:N,i)*NubQE(e)
     .                   + phiE(i)*DNubQE(e,1:N)
          enddo
        endif
      enddo
c
c  ...FACE SHAPE FUNCTIONS
c  ...triangle faces
      call BlendProjectPrisTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
c  ...loop over faces
      do f=1,2
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = (nordTF-1)*(nordTF-2)/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI = 2
          minJ = 1
          minIJ = minI+minJ
          maxIJ = nordTF
          maxI = maxIJ-minJ
          maxJ = maxIJ-minI
c      ...orient
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f),N,
     .                                                   GNupTF,GDNupTF)
c      ...construct the shape functions
          call AncPhiTri(GNupTF,GDNupTF,NordTF,IdecTF,N,
     .                                      phiTri(minI:maxI,minJ:maxJ),
     .                                 DphiTri(1:N,minI:maxI,minJ:maxJ))
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapH(m) = phiTri(i,j)*MubTF(f)
              GradH(1:N,m) = DphiTri(1:N,i,j)*MubTF(f)
     .                     + phiTri(i,j)*DMubTF(f,1:N)
            enddo
          enddo
        endif
      enddo
c  ...quadrilateral faces
      call ProjectPrisQF(Mu,DMu,Nu,DNu, STpQF,DSTpQF,IdecQF)
c  ...loop over faces
      do f=1,3
c    ...local parameters
        call decod(Nord(11+f),MODORDER,2, nordQF)
        ndofQF = (nordQF(1)-1)*(nordQF(2)-1)
        if (ndofQF.gt.0) then
c      ...local parameters (again)
          minI = 2
          minJ = 2
          maxI = nordQF(1)
          maxJ = nordQF(2)
c      ...orient
          call OrientQuad(STpQF(f,1:2,0:1),DSTpQF(f,1:N,1:2,0:1),
     .               NoriF(f+2),IdecQF(f,1:2),N, GSTpQF,GDSTpQF,GIdecQF)
c      ...construct the shape functions
          call AncPhiQuad(GSTpQF,GDSTpQF,nordQF,GIdecQF,N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
              ShapH(m) = phiQuad(i,j)
              GradH(1:N,m) = DphiQuad(1:N,i,j)
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      call decod(Nord(15),MODORDER,2, nordB)
      ndofB = (nordB(1)-1)*(nordB(1)-2)*(nordB(2)-1)/2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecTF
        IdecB(2) = IdecQE
        minI = 2
        minJ = 1
        minK = 2
        minIJ = minI+minJ
        maxIJ = nordB(1)
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
        maxK = nordB(2)
c    ...call phiTri and phiE - no need to orient
        call AncPhiTri(Nu,DNu,nordB(1),IdecB(1),N,
     .                                      phiTri(minI:maxI,minJ:maxJ),
     .                                 DphiTri(1:N,minI:maxI,minJ:maxJ))
        call AncPhiE(Mu,DMu,nordB(2),IdecB(2),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
        do k=minK,maxK
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapH(m) = phiTri(i,j)*phiE(k)
              GradH(1:N,m) = DphiTri(1:N,i,j)*phiE(k)
     .                     + phiTri(i,j)*DphiE(1:N,k)
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(1:15),NoriE(1:9),NoriF(1:5),NrdofH
 7001   format('shape3DHPris: Xi = ',3f8.3,/,
     .         'Norder = ',3i3,1x,3i3,2x,3i3,3x,2i3,2x,3i3,1x,i3,/,
     .         'orient = ',3i3,1x,3i3,2x,3i3,3x,2i3,2x,3i3,/,
     .         'NrdofH = ',i3)
        write(*,7010)
 7010   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,6
          m=v
          write(*,7002) m,ShapH(m),GradH(1:3,m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,3e12.5)
        enddo
        do e=1,6
          ndofME = Nord(e)-1
          if (ndofME.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR MIXED EDGE = ',i2)
            do j=1,ndofME
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do e=1,3
          ndofQE = Nord(6+e)-1
          if (ndofQE.gt.0) then
            write(*,7012) e
 7012       format('SHAPE FUNCTIONS FOR QUAD EDGE = ',i2)
            do j=1,ndofQE
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do f=1,2
          nordTF = Nord(9+f)
          ndofTF = (nordTF-1)*(nordTF-2)/2
          if (ndofTF.gt.0) then
            write(*,7013) f
 7013       format('SHAPE FUNCTIONS FOR TRIANGLE FACE = ',i2)
            do j=1,ndofTF
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do f=1,3
          call decod(Nord(11+f),MODORDER,2, nordQF)
          ndofQF = (nordQF(1)-1)*(nordQF(2)-1)
          if (ndofQF.gt.0) then
            write(*,7014) f
 7014       format('SHAPE FUNCTIONS FOR QUAD FACE = ',i2)
            do j=1,ndofQF
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        call decod(Nord(15),MODORDER,2, nordB)
        ndofB = (nordB(1)-1)*(nordB(1)-2)*(nordB(2)-1)/2
        if (ndofB.gt.0) then
          write(*,7015)
 7015     format('BUBBLES = ')
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapH(m),GradH(1:3,m)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DHPris

c--------------------------------------------------------------------
c
c     routine name      - shape3EPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D triangular prism
c                         element H(curl) shape functions and their
c                         derivatives
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------

      subroutine shape3DEPris(X,Nord,NoriE,NoriF,Nsize,
     .                                              NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(15),NoriE(9),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: iprint,N,m,e,f,i,j,k,nij,nordME,ndofME,nordQE,ndofQE
      integer :: nordTF,ndofTF,nordQF(2),ndofQF,nordB(2),ndofB
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ
      integer :: famctr,fam,a,b,ab(2),abc(3),ij(2),ig,jg,minF(2),maxF(2)
      logical :: IdecME,IdecQE,IdecTF,IdecQF(3,2),GIdecQF(2),IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapE(3,Nsize(2))
      double precision, intent(out) :: CurlE(3,Nsize(2))
      double precision :: Mu(0:1),DMu(3,0:1)
      double precision :: NU(0:2),DNu(3,0:2)
      double precision :: MubME(6),DMubME(6,3)
      double precision :: NupME(6,0:1),DNupME(6,3,0:1)
      double precision :: GNupME(0:1),GDNupME(3,0:1)
      double precision :: NubQE(3),DNubQE(3,3)
      double precision :: MupQE(3,0:1),DMupQE(3,3,0:1)
      double precision :: GMupQE(0:1),GDMupQE(3,0:1)
      double precision :: MubTF(2),DMubTF(2,3)
      double precision :: NupTF(2,0:2),DNupTF(2,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: STpQF(3,2,0:1),DSTpQF(3,3,2,0:1)
      double precision :: GSTpQF(2,0:1),GDSTpQF(3,2,0:1)
      double precision :: EE(3,0:Nsize(1)-1),CurlEE(3,0:Nsize(1)-1)
      double precision :: ETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: CurlETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: EQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: CurlEQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: PhiE(2:Nsize(1)),DPhiE(3,2:Nsize(1))
      double precision :: PhiTri(2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DPhiTri(3,2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DMubMExEE(3),DMubTFxETri(3),DPhiExETri(3)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePrism(X, Mu,DMu,Nu,DNu)
c
c  ...EDGE SHAPE FUNCTIONS
c  ...MIXED EDGES
      call BlendProjectPrisME(Mu,DMu,Nu,DNu,
     .                                 MubME,DMubME,NupME,DNupME,IdecME)
c  ...loop over edges
      do e=1,6
c    ...local parameters
        nordME = Nord(e)
        ndofME = nordME
        if (ndofME.gt.0) then
c      ...local parameters (again)
          minI = 0
          maxI = nordME-1
c      ...orient first
          call OrientE(NupME(e,0:1),DNupME(e,1:N,0:1),NoriE(e),N,
     .                                                   GNupME,GDNupME)
c      ...construct the shape functions
          call AncEE(GNupME,GDNupME,nordME,IdecME,N,
     .                          EE(1:N,minI:maxI),CurlEE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = MubME(e)*EE(1:N,i)
            call cross(3,DMubME(e,1:N),EE(1:N,i), DMubMExEE)
            CurlE(1:N,m) = MubME(e)*CurlEE(1:N,i)
     .                   + DMubMExEE
          enddo
        endif
      enddo
c  ...QUADRILATERAL EDGES
      call BlendProjectPrisQE(Mu,DMu,Nu,DNu,
     .                                 NubQE,DNubQE,MupQE,DMupQE,IdecQE)
c  ...loop over edges
      do e=1,3
c    ...local parameters
        nordQE = Nord(6+e)
        ndofQE = nordQE
        if (ndofQE.gt.0) then
c      ...local parameters (again)
          minI = 0
          maxI = nordQE-1
c      ...orient first
          call OrientE(MupQE(e,0:1),DMupQE(e,1:N,0:1),NoriE(6+e),N,
     .                                                   GMupQE,GDMupQE)
c      ...construct the shape functions (CurlEE should be returned as all 0)
          call AncEE(GMupQE,GDMupQE,nordQE,IdecQE,N,
     .                          EE(1:N,minI:maxI),CurlEE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = NubQE(e)*EE(1:3,i)
            call cross(3,DNubQE(e,1:N),EE(1:N,i), CurlE(1:N,m))
          enddo
        endif
      enddo
c
c  ...FACE SHAPE FUNCTIONS
c  ...triangle faces
      call BlendProjectPrisTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
c  ...loop over faces
      do f=1,2
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = nordTF*(nordTF-1)/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI  = 0
          minJ  = 1
          minIJ = minI+minJ
          maxIJ = nordTF-1
          maxI  = maxIJ-minJ
          maxJ  = maxIJ-minI
c      ...orient
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f),N,
     .                                                   GNupTF,GDNupTF)
c      ...loop over families
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            abc = cshift((/0,1,2/),fam)
c        ...construct the shape functions
            call AncETri(GNupTF(abc),GDNupTF(1:N,abc),nordTF,IdecTF,N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+2
c
                ShapE(1:N,m) = ETri(1:N,i,j)*MubTF(f)
c
                call cross(3,DMubTF(f,1:N),ETri(1:N,i,j), DMubTFxETri)
                CurlE(1:N,m) = MubTF(f)*CurlETri(1:N,i,j)
     .                       + DMubTFxETri
              enddo
            enddo
          enddo
        endif
      enddo
c  ...quadrilateral faces
      call ProjectPrisQF(Mu,DMu,Nu,DNu, STpQF,DSTpQF,IdecQF)
c  ...loop over faces
      do f=1,3
c    ...local parameters
        call decod(Nord(11+f),MODORDER,2, nordQF)
c    ...orient
        call OrientQuad(STpQF(f,1:2,0:1),DSTpQF(f,1:N,1:2,0:1),
     .               NoriF(2+f),IdecQF(f,1:2),N, GSTpQF,GDSTpQF,GIdecQF)
c    ...loop over families
        do fam=0,1
          ab = cshift((/1,2/),fam);
          a = ab(1); b = ab(2)
          ndofQF = nordQF(a)*(nordQF(b)-1)
          if (ndofQF.gt.0) then
c        ...local parameters (again)
            minF(1) = 0
            minF(2) = 2
            maxF(1) = nordQF(a)-1
            maxF(2) = nordQF(b)
c        ...construct the shape functions
            call AncEQuad(GSTpQF(ab,0:1),GDSTpQF(1:N,ab,0:1),
     .                    nordQF(ab),GIdecQF(ab),N,
     .                       EQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)),
     .                   CurlEQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)))
c        ...in the code the outer loop always is
c        ...numbered wrt the second global face axis
            minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
            do jg=minF(2),maxF(2)
              do ig=minF(1),maxF(1)
                ij = cshift((/ig,jg/),fam)
                i = ij(1); j = ij(2)
                m=m+1
c
                ShapE(1:N,m) = EQuad(1:N,i,j)
                CurlE(1:N,m) = CurlEQuad(1:N,i,j)
              enddo
            enddo
          endif
        enddo
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...Families 1 and 2 (Triangle type)
c  ...local parameters
      call decod(Nord(15),MODORDER,2, nordB)
      ndofB = nordB(1)*(nordB(1)-1)*(nordB(2)-1)/2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecTF
        IdecB(2) = IdecQE
        minI  = 0
        minJ  = 1
        minK  = 2
        minIJ = minI+minJ
        maxIJ = nordB(1)-1
        maxI  = maxIJ-minJ
        maxJ  = maxIJ-minI
        maxK  = nordB(2)
c    ...loop over families
        famctr=m
        do fam=0,1
          m=famctr+fam-1
          abc = cshift((/0,1,2/),fam)
c      ...now construct the shape functions (no need to orient)
          call AncETri(Nu(abc),DNu(1:N,abc),nordB(1),IdecB(1),N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
          call AncPhiE(Mu,DMu,nordB(2),IdecB(2),N,
     .                             PhiE(minK:maxK),DPhiE(1:N,minK:maxK))
          do k=minK,maxK
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+2
c
                ShapE(1:N,m) = ETri(1:N,i,j)*PhiE(k)
c
                call cross(N,DPhiE(1:N,k),ETri(1:N,i,j), DPhiExETri)
                CurlE(1:N,m) = PhiE(k)*CurlETri(1:N,i,j)
     .                       + DPhiExETri
              enddo
            enddo
          enddo
        enddo
      endif
c  ...Family 3 (Quadrilateral type)
c  ...local parameters
      ndofB = (nordB(1)-1)*(nordB(1)-2)*nordB(2)/2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecTF
        IdecB(2) = IdecQE
        minI  = 2
        minJ  = 1
        minK  = 0
        minIJ = minI+minJ
        maxIJ = nordB(1)
        maxI  = maxIJ-minJ
        maxJ  = maxIJ-minI
        maxK  = nordB(2)-1
c    ...now construct the shape functions (no need to orient)
        call AncphiTri(Nu,DNu,nordB(1),IdecB(1),N,
     .                                      PhiTri(minI:maxI,minJ:maxJ),
     .                                 DPhiTri(1:N,minI:maxI,minJ:maxJ))
        call AncEE(Mu,DMu,nordB(2),IdecB(2),N,
     .                          EE(1:N,minK:maxK),CurlEE(1:N,minK:maxK))
        do k=minK,maxK
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapE(1:N,m) = PhiTri(i,j)*EE(1:N,k)
              call cross(3,DPhiTri(1:N,i,j),EE(1:N,k), CurlE(1:N,m))
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(1:15),NoriE(1:9),NoriF(1:5),NrdofE
 7001   format('shape3DEPris: Xi = ',3f8.3,/,
     .         'Norder = ',3i3,1x,3i3,2x,3i3,3x,2i3,2x,3i3,1x,i3,/,
     .         'orient = ',3i3,1x,3i3,2x,3i3,3x,2i3,2x,3i3,/,
     .         'NrdofH = ',i3)
        m=0
        do e=1,6
          nordME = Nord(e)
          ndofME = nordME
          if (ndofME.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR MIXED EDGE = ',i2)
            do j=1,ndofME
              m=m+1
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
 7002         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        do e=1,3
          nordQE = Nord(6+e)
          ndofQE = nordQE
          if (ndofQE.gt.0) then
            write(*,7012) e
 7012       format('SHAPE FUNCTIONS FOR QUAD EDGE = ',i2)
            do j=1,ndofQE
              m=m+1
              write(*,7003) m,ShapE(1:N,m),CurlE(1:N,m)
 7003         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        do f=1,2
          nordTF = Nord(9+f)
          ndofTF = nordTF*(nordTF-1)/2
          if (ndofTF.gt.0) then
            write(*,7013) f
 7013       format('SHAPE FUNCTIONS FOR TRIANGLE FACE = ',i2)
            famctr=m
            do fam=0,1
              m=famctr+fam-1
              write(*,7004) fam
 7004         format('family = ',i2)
              do j=1,ndofTF
                m=m+2
                write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
              enddo
            enddo
          endif
        enddo
        do f=1,3
          call decod(Nord(11+f),MODORDER,2, nordQF)
          ndofQF = nordQF(a)*(nordQF(b)-1)
          if (ndofQF.gt.0) then
            write(*,7014) f
 7014       format('SHAPE FUNCTIONS FOR QUAD FACE = ',i2)
            do fam=0,1
              write(*,7004) fam
              do j=1,ndofQF
                m=m+1
                write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
              enddo
            enddo
          endif
        enddo
        call decod(Nord(15),MODORDER,2, nordB)
        ndofB = nordB(1)*(nordB(1)-1)*(nordB(2)-1)/2
        if (ndofB.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR TRI-TYPE BUBBLES'
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            write(*,7004) fam
            do j=1,ndofB
              m=m+2
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
            enddo
          enddo
        endif
        ndofB = (nordB(1)-1)*(nordB(1)-2)*nordB(2)/2
        if (ndofB.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUAD-TYPE BUBBLES'
          write(*,7004) 2
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DEPris
c
c
c-----------------------------------------------------------------------
c
c     routine name      - shape3DVPris
c
c-----------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of 3D Prism element
c                         H(div) shape functions and their divergences
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVPris(X,Nord,NoriF,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(15),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: iprint,N,m,f,i,j,k,nij
      integer :: nordTF,ndofTF,nordQF(2),ndofQF,nordB(2),ndofB
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ
      integer :: famctr,fam,abc(3)
      logical :: IdecTF,IdecQF(3,2),GIdecQF(2),IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapV(3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: Mu(0:1),DMu(3,0:1)
      double precision :: NU(0:2),DNu(3,0:2)
      double precision :: MubTF(2),DMubTF(2,3)
      double precision :: NupTF(2,0:2),DNupTF(2,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: STpQF(3,2,0:1),DSTpQF(3,3,2,0:1)
      double precision :: GSTpQF(2,0:1),GDSTpQF(3,2,0:1)
      double precision :: VTri(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVTri(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: VQuad(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVQuad(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: ETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: CurlETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: EE(3,0:Nsize(1)-1),CurlEE(3,0:Nsize(1)-1)
      double precision :: PhiE(2:Nsize(1)),DPhiE(3,2:Nsize(1))
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePrism(X, Mu,DMu,Nu,DNu)
c
c  ...FACE SHAPE FUNCTIONS
c  ...triangle faces
      call BlendProjectPrisTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
      do f=1,2
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = (nordTF+1)*nordTF/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI  = 0
          minJ  = 0
          minIJ = minI+minJ
          maxIJ = nordTF-1
          maxI  = maxIJ-minJ
          maxJ  = maxIJ-minI
c      ...orient
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f),N,
     .                                                   GNupTF,GDNupTF)
c      ...construct the shape functions (DivVTri should be 0)
          call AncVTri(GNupTF,GDNupTF,nordTF,IdecTF,N,
     .                                    VTri(1:N,minI:maxI,minJ:maxJ),
     .                                     DivVTri(minI:maxI,minJ:maxJ))
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapV(1:N,m) = MubTF(f)*VTri(1:N,i,j)
              call dot_product(DMubTF(f,1:N),VTri(1:N,i,j), DivV(m))
            enddo
          enddo
        endif
      enddo
c  ...quadrilateral faces
      call ProjectPrisQF(Mu,DMu,Nu,DNu, STpQF,DSTpQF,IdecQF)
c  ...loop over faces
      do f=1,3
c    ...local parameters
        call decod(Nord(11+f),MODORDER,2, nordQF)
        ndofQF = nordQF(1)*nordQF(2)
        if (ndofQF.gt.0) then
c      ...local parameters (again)
          minI = 0
          minJ = 0
          maxI = nordQF(1)-1
          maxJ = nordQF(2)-1
c      ...orient
          call OrientQuad(STpQF(f,1:2,0:1),DSTpQF(f,1:N,1:2,0:1),
     .               NoriF(2+f),IdecQF(f,1:2),N, GSTpQF,GDSTpQF,GIdecQF)
c      ...construct the shape functions
          call AncVQuad(GSTpQF,GDSTpQF,nordQF,GIdecQF,N,
     .                                   VQuad(1:N,minI:maxI,minJ:maxJ),
     .                                    DivVQuad(minI:maxI,minJ:maxJ))
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
c
              ShapV(1:N,m) = VQuad(1:N,i,j)
              DivV(m) = DivVQuad(i,j)
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...Families 1 and 2 (Triangle type)
c  ...local parameters
      call decod(Nord(15),MODORDER,2, nordB)
      ndofB = nordB(1)*(nordB(1)-1)*nordB(2)/2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecTF
        IdecB(2) = .TRUE.
        minI  = 0
        minJ  = 1
        minK  = 0
        minIJ = minI+minJ
        maxIJ = nordB(1)-1
        maxI  = maxIJ-minJ
        maxJ  = maxIJ-minI
        maxK  = nordB(2)-1
c    ...loop over families
        famctr=m
        do fam=0,1
          m=famctr+fam-1
          abc = cshift((/0,1,2/),fam)
c      ...now construct the shape functions (no need to orient)
          call AncETri(Nu(abc),DNu(1:N,abc),nordB(1)-minK,IdecB(1),N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
          call AncEE(Mu,DMu,nordB(2),IdecB(2),N,
     .                          EE(1:N,minK:maxK),CurlEE(1:N,minK:maxK))
          do k=minK,maxK
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+2
c
                call cross(3,ETri(1:N,i,j),EE(1:N,k), ShapV(1:N,m))
                call dot_product(EE(1:N,k),CurlETri(1:N,i,j), DivV(m))
              enddo
            enddo
          enddo
        enddo
      endif
c  ...Family 3 (Quadrilateral type)
c  ...local parameters
      ndofB = (nordB(1)+1)*nordB(1)*(nordB(2)-1)/2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecTF
        IdecB(2) = .TRUE.
        minI  = 0
        minJ  = 0
        minK  = 2
        minIJ = minI+minJ
        maxIJ = nordB(1)-1
        maxI  = maxIJ-minJ
        maxJ  = maxIJ-minI
        maxK  = nordB(2)
c      ...construct the shape functions (DivVTri should be 0)
        call AncVTri(Nu,DNu,nordB(1),IdecB(1),N,
     .                                    VTri(1:N,minI:maxI,minJ:maxJ),
     .                                     DivVTri(minI:maxI,minJ:maxJ))
        call AncPhiE(Mu,DMu,nordB(2),IdecB(2),N,
     .                             PhiE(minK:maxK),DPhiE(1:N,minK:maxK))
        do k=minK,maxK
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapV(1:N,m) = PhiE(k)*VTri(1:N,i,j)
              call dot_product(DPhiE(1:N,k),VTri(1:N,i,j),  DivV(m))
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofV = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(1:15),NoriF(1:5),NrdofV
 7001   format('shape3DVPris: Xi = ',3f8.3,/,
     .         'Norder = ',3i3,1x,3i3,2x,3i3,3x,2i3,2x,3i3,1x,i3,/,
     .         'orient = ',2i3,2x,3i3,/,
     .         'NrdofH = ',i3)
        m=0
        do f=1,2
          nordTF = Nord(9+f)
          ndofTF = (nordTF+1)*nordTF/2
          if (ndofTF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR TRIANGLE FACE = ',i2)
            do j=1,ndofTF
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
 7002         format('k = ',i3,' ShapV, DivV = ',3e12.5,3x,e12.5)
            enddo
          endif
        enddo
        do f=1,3
          call decod(Nord(11+f),MODORDER,2, nordQF)
          ndofQF = nordQF(1)*nordQF(2)
          if (ndofQF.gt.0) then
            write(*,7013) f
 7013       format('SHAPE FUNCTIONS FOR QUAD FACE = ',i2)
            do j=1,ndofQF
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          endif
        enddo
        call decod(Nord(15),MODORDER,2, nordB)
        ndofB = nordB(1)*(nordB(1)-1)*nordB(2)/2
        if (ndofB.gt.0) then
          write(*,*) 'BUBBLES : '
          write(*,*) 'SHAPE FUNCTIONS FOR TRIANGLE-TYPE BUBBLES'
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            write(*,7003) fam
 7003       format('family ',i2)
            do j=1,ndofB
              m=m+2
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          enddo
        endif
        ndofB = (nordB(1)+1)*nordB(1)*(nordB(2)-1)/2
        if (ndofB.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUAD-TYPE BUBBLES'
          write(*,7003) 2
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapV(1:N,m),DivV(m)
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DVPris
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Nov 14, Apr 17
c
c     purpose:          - routine returns values of 3D Prism
c                         element L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQPris(X,Nord,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(15),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: i,j,k,nij,nijk,m,N,nordB(2),ndofB,iprint,minalpha
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Mu(0:1),DMu(3,0:1),Nu(0:2),DNu(3,0:2)
      double precision :: homP(0:Nsize(1)-1)
      double precision :: homPal(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: homPz(0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePrism(X, Mu,DMu,Nu,DNu)
c  ...local parameters
      call decod(Nord(15),MODORDER,2, nordB)
      ndofB = (nordB(1)+1)*nordB(1)*nordB(2)/2
      minI  = 0
      minJ  = 0
      minK  = 0
      minIJ = minI+minJ
      maxIJ = nordB(1)-1
      maxI  = maxIJ-minJ
      maxJ  = maxIJ-minI
      maxK  = nordB(2)-1
      minalpha = 2*minI+1
c
c  ...get homogenized Legendre polynomials, homP
      call HomLegendre(Nu(0:1),maxI, homP(minI:maxI))
c
c  ...get homogenized Jacobi polynomials, homPal
      call HomJacobi((/Nu(0)+Nu(1),Nu(2)/),maxIJ,minalpha,
     .                                      homPal(minI:maxI,minJ:maxJ))
c  ...get homogenized Legendre polynomials in z-drection, homPz
      call HomLegendre(Mu(0:1),maxK, homPz(minK:maxK))
c
c  ...construct shape functions
      do k=minK,maxK
        do nij=minIJ,maxIJ
          do i=minI,nij-minJ
            j=nij-i
            m=m+1
c
            ShapQ(m) = homP(i)*homPal(i,j)*homPz(k)
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(15)
 7001   format('shape3DQPris: Xi = ',3f8.3,/,
     .         'Norder = ',i2)
        call decod(Nord(15),MODORDER,2, nordB)
        ndofB = (nordB(1)+1)*nordB(1)*nordB(2)/2
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          m=0
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapQ(m)
7002     format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DQPris












c Routines:
c  - shape3DHPyra
c  - shape3DEPyra
c  - shape3DVPyra
c  - shape3DQPyra
c--------------------------------------------------------------------
c
c     routine name      - shape3DHPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Jan 15, Apr 17
c
c     purpose:          - routine returns values of 3D pyramid element
c                         H1 shape functions and their derivatives
c
c     arguments:
c
c     in:
c          Xi           - master pyramid coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHPyra(Xi,Nord,NoriE,NoriF,Nsize,
     .                                              NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(14),NoriE(8),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: iprint,N,m,v,e,f,i,j,k,nij,nordME,ndofME,nordTE,ndofTE
      integer :: nordQF(2),ndofQF,nordTF,ndofTF,nordB,ndofB
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ
      logical :: IdecME,IdecTE,IdecQF(2),GIdecQF(2),IdecTF,IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(3,Nsize(2))
      double precision :: Lam(5),DLam(3,5)
      double precision :: Mu(2,0:1),DMu(3,2,0:1)
      double precision :: Nu(2,0:2),DNu(3,2,0:2)
      double precision :: MuZ(0:1),DMuZ(3,0:1)
      double precision :: LambV(5),DLambV(5,3)
      double precision :: MubME(4),DMubME(4,3)
      double precision :: NupME(4,0:1),DNupME(4,3,0:1)
      double precision :: GNupME(0:1),GDNupME(3,0:1)
      double precision :: LampTE(4,0:1),DLampTE(4,3,0:1)
      double precision :: GLampTE(0:1),GDLampTE(3,0:1)
      double precision :: MupQF(2,0:1),DMupQF(3,2,0:1)
      double precision :: GMupQF(2,0:1),GDMupQF(3,2,0:1)
      double precision :: MubTF(4),DMubTF(4,3)
      double precision :: NupTF(4,0:2),DNupTF(4,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: phiE(2:Nsize(1)),DphiE(3,2:Nsize(1))
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(3,2:Nsize(1),2:Nsize(1))
      double precision :: phiTri(2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DphiTri(3,2:Nsize(1)-1,1:Nsize(1)-2)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePyramid(Xi, Lam,DLam,Mu,DMu,Nu,DNu,MuZ,DMuZ)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendPyraV(Lam,DLam, LambV,DLambV)
      do v=1,5
       m=m+1
       ShapH(m)     = LambV(v)
       GradH(1:N,m) = DLambV(v,1:N)
      enddo
c
c  ...MIXED EDGE SHAPE FUNCTIONS
      call BlendProjectPyraME(Mu,DMu,Nu,DNu,
     .                                 MubME,DMubME,NupME,DNupME,IdecME)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordME = Nord(e)
        ndofME = nordME-1
        if (ndofME.gt.0) then
c      ...local parameters (again)
          minI = 2
          maxI = nordME
c      ...orient first
          call OrientE(NupME(e,0:1),DNupME(e,1:N,0:1),NoriE(e),N,
     .                                                   GNupME,GDNupME)
c      ...construct the shape functions
          call AncPhiE(GNupME,GDNupME,nordME,IdecME,N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
            ShapH(m)     = MubME(e)*phiE(i)
            GradH(1:N,m) = DMubME(e,1:N)*phiE(i)
     .                   + MubME(e)*DphiE(1:N,i)
          enddo
        endif
      enddo
c
c  ...TRIANGLE EDGE SHAPE FUNCTIONS
      call ProjectPyraTE(Lam,DLam, LampTE,DLampTE,IdecTE)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordTE = Nord(e+4)
        ndofTE = nordTE-1
        if (ndofTE.gt.0) then
c      ...local parameters (again)
          minI = 2
          maxI = nordTE
c      ...orient first
          call OrientE(LampTE(e,0:1),DLampTE(e,1:N,0:1),NoriE(e+4),N,
     .                                                 GLampTE,GDLampTE)
c      ...construct the shape functions
          call AncPhiE(GLampTE,GDLampTE,nordTE,IdecTE,N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
            ShapH(m)     = phiE(i)
            GradH(1:N,m) = DphiE(1:N,i)
          enddo
        endif
      enddo
c
c  ...QUADRILATERAL FACE SHAPE FUNCTION
      call ProjectPyraQF(Mu,DMu, MupQF,DMupQF,IdecQF)
c  ...local parameters
      call decod(Nord(9),MODORDER,2, nordQF)
      ndofQF = (nordQF(1)-1)*(nordQF(2)-1)
      if (ndofQF.gt.0) then
c    ...local parameters (again)
        minI = 2
        minJ = 2
        maxI = nordQF(1)
        maxJ = nordQF(2)
c    ...orient first
        call OrientQuad(MupQF,DMupQF,NoriF(1),IdecQF,N,
     .                                           GMupQF,GDMupQF,GIdecQF)
c    ...construct the shape functions
        call AncPhiQuad(GMupQF,GDMupQF,nordQF,GIdecQF,N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
c
              ShapH(m)     = MuZ(0)*phiQuad(i,j)
              GradH(1:N,m) = DMuZ(1:N,0)*phiQuad(i,j)
     .                     + MuZ(0)*DphiQuad(1:N,i,j)
            enddo
          enddo
        endif
c
c  ...TRIANGULAR FACE SHAPE FUNCTIONS
      call BlendProjectPyraTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
c  ...loop over faces
      do f=1,4
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = (nordTF-1)*(nordTF-2)/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI = 2
          minJ = 1
          minIJ = minI+minJ
          maxIJ = nordTF
          maxI = maxIJ-minJ
          maxJ = maxIJ-minI
c      ...orient first
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f+1),N,
     .                                                   GNupTF,GDNupTF)
c      ...construct the shape functions
          call AncPhiTri(GNupTF,GDNupTF,nordTF,IdecTF,N,
     .                                      phiTri(minI:maxI,minJ:maxJ),
     .                                 DphiTri(1:N,minI:maxI,minJ:maxJ))
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+1
c
                ShapH(m)     = MubTF(f)*phiTri(i,j)
                GradH(1:N,m) = DMubTF(f,1:N)*phiTri(i,j)
     .                       + MubTF(f)*DphiTri(1:N,i,j)
              enddo
            enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      nordB = Nord(14)
      ndofB = (nordB-1)**3
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = IdecQF; IdecB(3) = .TRUE.
        minI = 2
        minJ = 2
        minK = 2
        maxI = nordB
        maxJ = nordB
        maxK = nordB
c    ...call phiQuad and phiE - no need to orient
        call AncPhiQuad(Mu,DMu,(/nordB,nordB/),IdecB(1:2),N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
        call AncPhiE(MuZ,DMuZ,nordB,IdecB(3),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
        do k=minK,maxK
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
c
              ShapH(m) = phiQuad(i,j)*phiE(k)
              GradH(1:N,m) = phiQuad(i,j)*DphiE(1:N,k)
     .                     + DphiQuad(1:N,i,j)*phiE(k)
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(1:14),NoriE(1:8),NoriF(1:5)
 7001   format('shape3DHPyra: Xi = ',3f8.3,/,
     .         'Norder = ',8i2,3x,5i2,3x,i2,/,
     .         'orient = ',8i2,3x,5i2)
        write(*,7010)
 7010   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,5
          m=v
          write(*,7002) m,ShapH(m),GradH(1:3,m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,3e12.5)
        enddo
        do e=1,4
          ndofME = Nord(e)-1
          if (ndofME.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR MIXED EDGE = ',i2)
            do j=1,ndofME
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do e=1,4
          ndofTE = Nord(e)-1
          if (ndofTE.gt.0) then
            write(*,7012) e
 7012       format('SHAPE FUNCTIONS FOR TRIANGLE EDGE = ',i2)
            do j=1,ndofTE
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        call decod(Nord(9),MODORDER,2, nordQF)
        ndofQF = (nordQF(1)-1)*(nordQF(2)-1)
        if (ndofQF.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUADRILATERAL FACE'
          do j=1,ndofQF
            m=m+1
            write(*,7002) m,ShapH(m),GradH(1:3,m)
          enddo
        endif
        do f=1,4
          nordTF = Nord(9+f)
          ndofTF = (nordTF-1)*(nordTF-2)/2
          if (ndofTF.gt.0) then
            write(*,7013) f
 7013       format('SHAPE FUNCTIONS FOR TRIANGLE FACE = ',i2)
            do j=1,ndofTF
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        nordB = Nord(14)
        ndofB = (nordB-1)**3
        if (ndofB.gt.0) then
          write(*,7015)
 7015     format('BUBBLES = ')
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapH(m),GradH(1:3,m)
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DHPyra
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Jan 15, Apr 17
c
c     purpose:          - routine returns values of 3D pyramid element
c                         H(curl) shape functions and their curls
c
c     arguments:
c
c     in:
c          Xi           - master pyramid coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEPyra(Xi,Nord,NoriE,NoriF,Nsize,
     .                                              NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(14),NoriE(8),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: iprint,N,m,v,e,f,i,j,k,nij,nordME,ndofME,nordTE,ndofTE
      integer :: nordQF(2),ndofQF,nordTF,ndofTF,nordB,ndofB,ab(2),a,b
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ,fam,famctr
      integer :: ij(2),ig,jg,minF(2),maxF(2),abc(3),ijmax
      logical :: IdecME,IdecTE,IdecQF(2),GIdecQF(2),IdecTF,IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(3,Nsize(2))
      double precision, intent(out) :: CurlE(3,Nsize(2))
      double precision :: Lam(5),DLam(3,5)
      double precision :: Mu(2,0:1),DMu(3,2,0:1)
      double precision :: Nu(2,0:2),DNu(3,2,0:2)
      double precision :: MuZ(0:1),DMuZ(3,0:1)
      double precision :: LambV(5),DLambV(5,3)
      double precision :: MubME(4),DMubME(4,3)
      double precision :: NupME(4,0:1),DNupME(4,3,0:1)
      double precision :: GNupME(0:1),GDNupME(3,0:1)
      double precision :: LampTE(4,0:1),DLampTE(4,3,0:1)
      double precision :: GLampTE(0:1),GDLampTE(3,0:1)
      double precision :: MupQF(2,0:1),DMupQF(3,2,0:1)
      double precision :: GMupQF(2,0:1),GDMupQF(3,2,0:1)
      double precision :: MubTF(4),DMubTF(4,3)
      double precision :: NupTF(4,0:2),DNupTF(4,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: EE(3,0:Nsize(1)-1),CurlEE(3,0:Nsize(1)-1)
      double precision :: EQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: CurlEQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: ETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: CurlETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: phiE(2:Nsize(1)),DphiE(3,2:Nsize(1))
      double precision :: phiE2(2:Nsize(1)),DphiE2(3,2:Nsize(1))
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(3,2:Nsize(1),2:Nsize(1))
      double precision :: DMubMExEE(3),DMuZxEQuad(3),DMubTFxETri(3)
      double precision :: tmp,vectmp(3),DphiQuadxDMuZ(3)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePyramid(Xi, Lam,DLam,Mu,DMu,Nu,DNu,MuZ,DMuZ)
c
c  ...MIXED EDGE SHAPE FUNCTIONS
      call BlendProjectPyraME(Mu,DMu,Nu,DNu,
     .                                 MubME,DMubME,NupME,DNupME,IdecME)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordME = Nord(e)
        ndofME = nordME
        if (ndofME.gt.0) then
c      ...local parameters (again)
          minI = 0
          maxI = nordME-1
c      ...orient first
          call OrientE(NupME(e,0:1),DNupME(e,1:N,0:1),NoriE(e),N,
     .                                                   GNupME,GDNupME)
c      ...construct the shape functions
          call AncEE(GNupME,GDNupME,nordME,IdecME,N,
     .                          EE(1:N,minI:maxI),CurlEE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = MubME(e)*EE(1:N,i)
            call cross(3,DMubME(e,1:N),EE(1:N,i), DMubMExEE)
            CurlE(1:N,m) = MubME(e)*CurlEE(1:N,i)
     .                   + DMubMExEE
          enddo
        endif
      enddo
c
c  ...TRIANGLE EDGE SHAPE FUNCTIONS
      call ProjectPyraTE(Lam,DLam, LampTE,DLampTE,IdecTE)
c  ...loop over edges
      do e=1,4
c    ...local parameters
        nordTE = Nord(e+4)
        ndofTE = nordTE
        if (ndofTE.gt.0) then
c      ...local parameters (again)
          minI = 0
          maxI = nordTE-1
c      ...orient first
          call OrientE(LampTE(e,0:1),DLampTE(e,1:N,0:1),NoriE(e+4),N,
     .                                                 GLampTE,GDLampTE)
c      ...construct the shape functions
          call AncEE(GLampTE,GDLampTE,nordTE,IdecTE,N,
     .                          EE(1:N,minI:maxI),CurlEE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = EE(1:N,i)
            CurlE(1:N,m) = CurlEE(1:N,i)
          enddo
        endif
      enddo
c
c  ...QUADRILATERAL FACE SHAPE FUNCTIONS
      call ProjectPyraQF(Mu,DMu, MupQF,DMupQF,IdecQF)
c  ...local parameters
      call decod(Nord(9),MODORDER,2, nordQF)
c  ...orient
      call OrientQuad(MupQF,DMupQF,NoriF(1),IdecQF,N,
     .                                           GMupQF,GDMupQF,GIdecQF)
c  ...loop over families
      do fam=0,1
        ab = cshift((/1,2/),fam);
        a = ab(1); b = ab(2)
        ndofQF = nordQF(a)*(nordQF(b)-1)
        if (ndofQF.gt.0) then
c      ...local parameters (again)
          minF(1) = 0
          minF(2) = 2
          maxF(1) = nordQF(a)-1
          maxF(2) = nordQF(b)
c      ...construct the shape functions
          call AncEQuad(GMupQF(ab,0:1),GDMupQF(1:N,ab,0:1),nordQF(ab),
     .                                                  GIdecQF(ab),N,
     .                       EQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)),
     .                   CurlEQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)))
c      ...in the code the outer loop always is
c      ...numbered wrt the second global face axis
          minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
          do jg=minF(2),maxF(2)
            do ig=minF(1),maxF(1)
              ij = cshift((/ig,jg/),fam)
              i = ij(1); j = ij(2)
              m=m+1
c
              ShapE(1:N,m) = EQuad(1:N,i,j)*MuZ(0)**2
              call cross(N,DMuZ(1:N,0),EQuad(1:N,i,j), DMuZxEQuad)
              CurlE(1:N,m) = CurlEQuad(1:N,i,j)*MuZ(0)**2
     .                     + 2*DMuZxEQuad*MuZ(0)
            enddo
          enddo
        endif
      enddo
c
c  ...TRIANGULAR FACE SHAPE FUNCTIONS
      call BlendProjectPyraTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
c  ...loop over faces
      do f=1,4
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = nordTF*(nordTF-1)/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI  = 0
          minJ  = 1
          minIJ = minI+minJ
          maxIJ = nordTF-1
          maxI  = maxIJ-minJ
          maxJ  = maxIJ-minI
c      ...orient first
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f+1),N,
     .                                                   GNupTF,GDNupTF)
c      ...loop over families
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            abc = cshift((/0,1,2/),fam)
c        ...construct the shape functions
            call AncETri(GNupTF(abc),GDNupTF(1:N,abc),nordTF,IdecTF,N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+2
c
                ShapE(1:N,m) = ETri(1:N,i,j)*MubTF(f)
                call cross(N,DMubTF(f,1:N),ETri(1:N,i,j), DMubTFxETri)
                CurlE(1:N,m) = MubTF(f)*CurlETri(1:N,i,j)
     .                       + DMubTFxETri
              enddo
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      nordB = Nord(14)
c  ...FAMILY 1 (gradients of H1 bubbles)
      ndofB = (nordB-1)**3
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.; IdecB(3) = .TRUE.
        minI = 2
        minJ = 2
        minK = 2
        maxI = nordB
        maxJ = nordB
        maxK = nordB
c    ...construct shape functions, no need to orient
        call AncPhiQuad(Mu,DMu,(/nordB,nordB/),IdecB(1:2),N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
        call AncPhiE(MuZ,DMuZ,nordB,IdecB(3),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
        do k=minK,maxK
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
c
              ShapE(1:N,m) = phiQuad(i,j)*DphiE(1:N,k)
     .                     + DphiQuad(1:N,i,j)*phiE(k)
              CurlE(1:N,m) = 0.d0
            enddo
          enddo
        enddo
      endif
c  ...FAMILY 2 AND 3 (induced from quad face functions)
      ndofB = nordB*(nordB-1)**2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters
        IdecB(1:2) = .TRUE.; IdecB(3) = .TRUE.
        minF(1) = 0
        minF(2) = 2
        minK    = 2
        maxF(1) = nordB-1
        maxF(2) = nordB
        maxK    = nordB
c    ...loop over families
        do fam=0,1
          ab = cshift((/1,2/),fam);
          a = ab(1); b = ab(2)
c    ...construct shape functions, no need to orient
          call AncEQuad(Mu(ab,0:1),DMu(1:N,ab,0:1),(/nordB,nordB/),
     .                                                    IdecB(ab),N,
     .                       EQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)),
     .                   CurlEQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)))
          call AncPhiE(MuZ,DMuZ,nordB,IdecB(3),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
c      ...in the code the outer loop always is
c      ...numbered wrt the second global face axis
          minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
          do k=minK,maxK
            do jg=minF(2),maxF(2)
              do ig=minF(1),maxF(1)
                ij = cshift((/ig,jg/),fam)
                i = ij(1); j = ij(2)
                m=m+1
c
                ShapE(1:N,m) = MuZ(0)*EQuad(1:N,i,j)*phiE(k)
                call cross(3,DMuZ(1:N,0)*phiE(k) + MuZ(0)*DphiE(1:N,k),
     .                                           EQuad(1:N,i,j), vectmp)
                CurlE(1:N,m) = MuZ(0)*CurlEQuad(1:N,i,j)*phiE(k)
     .                       + vectmp
              enddo
            enddo
          enddo
        enddo
      endif
c  ...FAMILY 4
      ndofB = (nordB-1)**2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.
        minI = 2
        minJ = 2
        maxI = nordB
        maxJ = nordB
c    ...construct shape functions, no need to orient
        call AncPhiQuad(Mu,DMu,(/nordB,nordB/),IdecB(1:2),N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
            ijmax = max(i,j)
c
            tmp = phiQuad(i,j)*MuZ(0)**(ijmax-1)
            ShapE(1:N,m) = tmp*DMuZ(1:N,1)
            call cross(N,DphiQuad(1:N,i,j),DMuZ(1:N,1), DphiQuadxDMuZ)
            CurlE(1:N,m) = DphiQuadxDMuZ*MuZ(0)**(ijmax-1)
          enddo
        enddo
      endif

c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001)Xi(1:3),Nord(1:14),NoriE(1:8),NoriF(1:5),NrdofE
 7001   format('shape3DEPyra: Xi = ',3f8.3,/,
     .         'Norder = ',4i3,1x,4i3,3x,i3,1x,4i3,3x,i3,/,
     .         'orient = ',4i3,1x,4i3,3x,i3,1x,4i3,/,
     .         'NrdofE = ',2i3)
        m=0
        do e=1,4
          nordME = Nord(e)
          ndofME = nordME
          if (ndofME.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR MIXED EDGE = ',i2)
            do j=1,ndofME
              m=m+1
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
 7002         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        do e=1,4
          nordTE = Nord(4+e)
          ndofTE = nordTE
          if (ndofTE.gt.0) then
            write(*,7012) e
 7012       format('SHAPE FUNCTIONS FOR TRIANGULAR EDGE = ',i2)
            do j=1,ndofTE
              m=m+1
              write(*,7003) m,ShapE(1:N,m),CurlE(1:N,m)
 7003         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        call decod(Nord(9),MODORDER,2, nordQF)
        ndofQF = nordQF(1)*(nordQF(2)-1)
        if (ndofQF.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUADRILATERAL FACE'
          do fam=0,1
            write(*,7004) fam
 7004       format('Family ',i2)
            do j=1,ndofQF
              m=m+1
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
            enddo
          enddo
        endif
        do f=1,4
          nordTF = Nord(9+f)
          ndofTF = nordTF*(nordTF-1)/2
          if (ndofTF.gt.0) then
            write(*,7014) f
 7014       format('SHAPE FUNCTIONS FOR TRIANGLAR FACE = ',i2)
            famctr=m
            do fam=0,1
              m=famctr+fam-1
              write(*,7004) fam
              do j=1,ndofTF
                m=m+2
                write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
              enddo
            enddo
          endif
        enddo
        nordB = Nord(14)
        ndofB = (nordB-1)**3
        if (ndofB.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR BUBBLES'
          write(*,*) 'Family 1'
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
          enddo
        endif
        ndofB = nordB*(nordB-1)**2
        if (ndofB.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUAD-TYPE BUBBLES'
          do fam=0,1
            write(*,7004) fam+2
            do j=1,ndofB
              m=m+1
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
            enddo
          enddo
        endif
        ndofB = (nordB-1)**2
        if (ndofB.gt.0) then
          write(*,*) 'Family 4'
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DEPyra
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Jan 15, Apr 17
c
c     purpose:          - routine returns values of 3D pyramid element
c                         H(div) shape functions and their divergences
c
c     arguments:
c
c     in:
c          Xi           - master pyramid coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVPyra(Xi,Nord,NoriF,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: Nord(14),NoriF(5),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: iprint,N,m,v,e,f,i,j,k,nij
      integer :: nordQF(2),ndofQF,nordTF,ndofTF,nordB,ndofB,ab(2),a,b
      integer :: minI,minJ,minK,minIJ,maxI,maxJ,maxK,maxIJ,fam
      integer :: ij(2),ig,jg,minF(2),maxF(2),abc(3),ijmax
      logical :: IdecME,IdecTE,IdecQF(2),GIdecQF(2),IdecTF,IdecLamTF
      logical :: IdecB(3)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: Lam(5),DLam(3,5)
      double precision :: Mu(2,0:1),DMu(3,2,0:1)
      double precision :: Nu(2,0:2),DNu(3,2,0:2)
      double precision :: MuZ(0:1),DMuZ(3,0:1)
      double precision :: MupQF(2,0:1),DMupQF(3,2,0:1)
      double precision :: GMupQF(2,0:1),GDMupQF(3,2,0:1)
      double precision :: MubTF(4),DMubTF(4,3)
      double precision :: NupTF(4,0:2),DNupTF(4,3,0:2)
      double precision :: LampTF(4,0:2),DLampTF(4,3,0:2)
      double precision :: GNupTF(0:2),GDNupTF(3,0:2)
      double precision :: GLampTF(0:2),GDLampTF(3,0:2)
      double precision :: VQuad(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVQuad(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: VTri(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVTri(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: VTri2(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVTri2(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: EQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: CurlEQuad(3,0:Nsize(1)-1,2:Nsize(1))
      double precision :: phiE(2:Nsize(1)),DphiE(3,2:Nsize(1))
      double precision :: phiE2(2:Nsize(1)),DphiE2(3,2:Nsize(1))
      double precision :: phiQuad(2:Nsize(1),2:Nsize(1))
      double precision :: DphiQuad(3,2:Nsize(1),2:Nsize(1))
      double precision :: tmp,tmp1,tmp2,tmp3
      double precision :: vectmp(3),vectmp1(3),vectmp2(3)
      double precision :: DMuZVQuad,DphiQuadxDMuZ(3)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePyramid(Xi, Lam,DLam,Mu,DMu,Nu,DNu,MuZ,DMuZ)
c
c  ...QUADRILATERAL FACE SHAPE FUNCTIONS
      call ProjectPyraQF(Mu,DMu, MupQF,DMupQF,IdecQF)
c  ...local parameters
      call decod(Nord(9),MODORDER,2, nordQF)
      ndofQF = nordQF(1)*nordQF(2)
      if (ndofQF.gt.0) then
        minI = 0
        minJ = 0
        maxI = NordQF(1)-1
        maxJ = NordQF(2)-1
c    ...orient
        call OrientQuad(MupQF,DMupQF,NoriF(1),IdecQF,N,
     .                                           GMupQF,GDMupQF,GIdecQF)
c    ...construct the shape functions
        call AncVQuad(GMupQF,GDMupQF,nordQF,GIdecQF,N,
     .                                   VQuad(1:N,minI:maxI,minJ:maxJ),
     .                                    DivVQuad(minI:maxI,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
c
            ShapV(1:N,m) = MuZ(0)**3*VQuad(1:N,i,j)
            call dot_product(DMuZ(1:N,0),VQuad(1:N,i,j), DMuZVQuad)
            DivV(m)      = MuZ(0)**3*DivVQuad(i,j)
     .                   + 3*MuZ(0)**2*DMuZVQuad
          enddo
        enddo
      endif
c
c  ...TRIANGULAR FACE SHAPE FUNCTIONS
      call BlendProjectPyraTF(Mu,DMu,Nu,DNu,
     .                                 MubTF,DMubTF,NupTF,DNupTF,IdecTF)
      call ProjectPyraLamTF(Lam,DLam, LampTF,DLampTF,IdecLamTF)
c  ...loop over faces
      do f=1,4
c    ...local parameters
        nordTF = Nord(9+f)
        ndofTF = (nordTF+1)*nordTF/2
        if (ndofTF.gt.0) then
c      ...local parameters (again)
          minI  = 0
          minJ  = 0
          minIJ = minI+minJ
          maxIJ = nordTF-1
          maxI  = maxIJ-minJ
          maxJ  = maxIJ-minI
c      ...orient first
          call OrientTri(NupTF(f,0:2),DNupTF(f,1:N,0:2),NoriF(f+1),N,
     .                                                   GNupTF,GDNupTF)
          call OrientTri(LampTF(f,0:2),DLampTF(f,1:N,0:2),NoriF(f+1),N,
     .                                                 GLampTF,GDLampTF)
c        ...construct the shape functions
          call AncVTri(GNupTF,GDNupTF,nordTF,IdecTF,N,
     .                                    VTri(1:N,minI:maxI,minJ:maxJ),
     .                                     DivVTri(minI:maxI,minJ:maxJ))
          call AncVTri(GLampTF,GDLampTF,nordTF,IdecLamTF,N,
     .                                   VTri2(1:N,minI:maxI,minJ:maxJ),
     .                                    DivVTri2(minI:maxI,minJ:maxJ))
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              vectmp1 = MubTF(f)*VTri(1:N,i,j)
              vectmp2 = VTri2(1:N,i,j)/MubTF(f)
              ShapV(1:N,m) = (vectmp1+vectmp2)/2
c
              tmp1 = MubTF(f)*DivVTri(i,j)
              tmp2 = DivVTri2(i,j)/MubTF(f)
              vectmp = VTri(1:N,i,j)-VTri2(1:N,i,j)/(MubTF(f)**2)
              call dot_product(DMubTF(f,1:N),vectmp, tmp3)
              DivV(m)      = (tmp1+tmp2+tmp3)/2
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
      nordB = Nord(14)
c  ...FAMILY 1 AND 2 (curl of families 2 and 3 from H(curl))
      ndofB = nordB*(nordB-1)**2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters
        IdecB(1:2) = .TRUE.; IdecB(3) = .TRUE.
        minF(1) = 0
        minF(2) = 2
        minK    = 2
        maxF(1) = nordB-1
        maxF(2) = nordB
        maxK    = nordB
c    ...loop over families
        do fam=0,1
          ab = cshift((/1,2/),fam);
          a = ab(1); b = ab(2)
c    ...construct shape functions, no need to orient
          call AncEQuad(Mu(ab,0:1),DMu(1:N,ab,0:1),(/nordB,nordB/),
     .                                                    IdecB(ab),N,
     .                       EQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)),
     .                   CurlEQuad(1:N,minF(1):maxF(1),minF(2):maxF(2)))
          call AncPhiE(MuZ,DMuZ,nordB,IdecB(3),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
c      ...in the code the outer loop always is
c      ...numbered wrt the second global face axis
          minF = cshift(minF,-fam); maxF = cshift(maxF,-fam)
          do k=minK,maxK
            do jg=minF(2),maxF(2)
              do ig=minF(1),maxF(1)
                ij = cshift((/ig,jg/),fam)
                i = ij(1); j = ij(2)
                m=m+1
c
                call cross(3,DMuZ(1:N,0)*phiE(k) + MuZ(0)*DphiE(1:N,k),
     .                                           EQuad(1:N,i,j), vectmp)
                ShapV(1:N,m) = MuZ(0)*CurlEQuad(1:N,i,j)*phiE(k)
     .                       + vectmp
                DivV(m)      = 0
              enddo
            enddo
          enddo
        enddo
      endif
c  ...FAMILY 3 (curl of family 4 from H(curl))
      ndofB = (nordB-1)**2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.; IdecB(3) = .TRUE.
        minI = 2
        minJ = 2
        maxI = nordB
        maxJ = nordB
c    ...construct shape functions, no need to orient
        call AncPhiQuad(Mu,DMu,(/nordB,nordB/),IdecB(1:2),N,
     .                                     phiQuad(minI:maxI,minJ:maxJ),
     .                                DphiQuad(1:N,minI:maxI,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
            ijmax = max(i,j)
c
            call cross(N,DphiQuad(1:N,i,j),DMuZ(1:N,1), DphiQuadxDMuZ)
            ShapV(1:N,m) = DphiQuadxDMuZ*MuZ(0)**(ijmax-1)
            DivV(m)      = 0
          enddo
        enddo
      endif
c  ...FAMILY 4 (induced from quad face functions)
      ndofB = nordB**2*(nordB-1)
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.
        minI = 0
        minJ = 0
        minK = 2
        maxI = nordB-1
        maxJ = nordB-1
        maxK = nordB
c    ...construct shape functions, no need to orient
        call AncVQuad(Mu,DMu,(/nordB,nordB/),IdecB(1:2),N,
     .                                   VQuad(1:N,minI:maxI,minJ:maxJ),
     .                                    DivVQuad(minI:maxI,minJ:maxJ))
        call AncPhiE(MuZ,DMuZ,nordB,IdecB(3),N,
     .                             phiE(minK:maxK),DphiE(1:N,minK:maxK))
        do k=minK,maxK
          do j=minJ,maxJ
            do i=minI,maxI
              m=m+1
c
              ShapV(1:N,m) = MuZ(0)**2*VQuad(1:N,i,j)*phiE(k)
              call dot_product(2*MuZ(0)*phiE(k)*DMuZ(1:N,0)
     .                     + MuZ(0)**2*DphiE(1:N,k),VQuad(1:N,i,j), tmp)
              DivV(m)      = MuZ(0)**2*DivVQuad(i,j)*phiE(k)
     .                     + tmp
            enddo
          enddo
        enddo
      endif
c  ...FAMILY 5
      ndofB = (nordB-1)**2
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.
        minI = 2
        minJ = 2
        maxI = nordB
        maxJ = nordB
c    ...construct shape functions, no need to orient
        call AncPhiE(Mu(1,0:1),DMu(1:N,1,0:1),nordB,IdecB(1),N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
        call AncPhiE(Mu(2,0:1),DMu(1:N,2,0:1),nordB,IdecB(2),N,
     .                           phiE2(minJ:maxJ),DphiE2(1:N,minJ:maxJ))
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
c
            call cross(N,DphiE(1:N,i),DphiE2(1:N,j), vectmp1)
            call cross(N,DMuZ(1:N,0),phiE(i)*DphiE2(1:N,j)
     .                                 - DphiE(1:N,i)*phiE2(j), vectmp2)
            vectmp = MuZ(0)*(MuZ(0)*vectmp1+vectmp2)
            ShapV(1:N,m) = MuZ(1)**(i-1)*vectmp
            call dot_product(DMuZ(1:N,1),vectmp, tmp)
            DivV(m)      = (i-1)*MuZ(1)**(i-2)*tmp
          enddo
        enddo
      endif
c  ...FAMILY 6 AND 7
      ndofB = nordB-1
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1:2) = .TRUE.
        minI = 2
        maxI = nordB
        do fam=0,1
          ab = cshift((/1,2/),fam)
          a = ab(1); b = ab(2)
c      ...construct shape functions, no need to orient
          call AncPhiE(Mu(a,0:1),DMu(1:N,a,0:1),nordB,IdecB(a),N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            call cross(N,DphiE(1:N,i)*MuZ(0)**2
     .              + 2*MuZ(0)*phiE(i)*DMuZ(1:N,0),DMu(1:N,b,1), vectmp)
            ShapV(1:N,m) = MuZ(1)**(i-1)*vectmp
            call dot_product(DMuZ(1:N,1),vectmp, tmp)
            DivV(m)      = (i-1)*MuZ(1)**(i-2)*tmp
          enddo
        enddo
      endif
c
c  ...total degrees of freedom
      NrdofV = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001)Xi(1:3),Nord(1:14),NoriF(1:5),NrdofV
 7001   format('shape3DVPyra: Xi = ',3f8.3,/,
     .         'Norder = ',4i3,1x,4i3,3x,i3,1x,4i3,3x,i3,/,
     .         'orient = ',i3,1x,4i3,/,
     .         'NrdofV = ',3i3)
        m=0
        call decod(Nord(9),MODORDER,2, nordQF)
        ndofQF = nordQF(1)*nordQF(2)
        if (ndofQF.gt.0) then
          write(*,*) 'SHAPE FUNCTIONS FOR QUADRILATERAL FACE'
          do j=1,ndofQF
            m=m+1
            write(*,7002) m,ShapV(1:N,m),DivV(m)
 7002       format('k = ',i3,' ShapV, DivV = ',3e12.5,3x,e12.5)
          enddo
        endif
        do f=1,4
          nordTF = Nord(9+f)
          ndofTF = (nordTF+1)*nordTF/2
          if (ndofTF.gt.0) then
            write(*,7014) f
 7014       format('SHAPE FUNCTIONS FOR TRIANGLAR FACE = ',i2)
            do j=1,ndofTF
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          endif
        enddo
        nordB = Nord(14)
        ndofB = nordB*(nordB-1)**2
        if (ndofB.gt.0) then
          write(*,*) 'BUBBLES'
          do fam=0,1
            write(*,7004) fam+1
 7004       format('Family ',i2)
            do j=1,ndofB
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          enddo
        endif
        ndofB = (nordB-1)**2
        if (ndofB.gt.0) then
          write(*,*) 'Family 3'
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapV(1:N,m),DivV(m)
          enddo
        endif
        ndofB = nordB**2*(nordB-1)
        if (ndofB.gt.0) then
          write(*,*) 'Family 4'
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapV(1:N,m),DivV(m)
          enddo
        endif
        ndofB = (nordB-1)**2
        if (ndofB.gt.0) then
          write(*,*) 'Family 5'
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapV(1:N,m),DivV(m)
          enddo
        endif
        ndofB = nordB-1
        if (ndofB.gt.0) then
          do fam=0,1
            write(*,7004) fam+6
            do j=1,ndofB
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DVPyra


c--------------------------------------------------------------------
c
c     routine name      - shape3DQPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Jan 15, Apr 17
c
c     purpose:          - routine returns values of 3D pyramid
c                         element L2 shape functions
c
c     arguments:
c
c     in:
c          Xi           - master pyramid coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQPyra(Xi,Nord,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: Nord(14),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: iprint,N,m,i,j,k,nordB,ndofB,minI,minJ,minK,maxI,maxJ
      integer :: maxK
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Lam(5),DLam(3,5)
      double precision :: Mu(2,0:1),DMu(3,2,0:1)
      double precision :: Nu(2,0:2),DNu(3,2,0:2)
      double precision :: MuZ(0:1),DMuZ(3,0:1)
      double precision :: homP(3,0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffinePyramid(Xi, Lam,DLam,Mu,DMu,Nu,DNu,MuZ,DMuZ)
c
c  ...local parameters
      nordB = Nord(14)
      ndofB = nordB**3
      minI = 0
      minJ = 0
      minK = 0
      maxI = Nord(14)-1
      maxJ = Nord(14)-1
      maxK = Nord(14)-1
c
c  ...get homogenized Legendre polynomials, homP
      call HomLegendre(Mu(1,0:1),maxI, homP(1,minI:maxI))
      call HomLegendre(Mu(2,0:1),maxJ, homP(2,minJ:maxJ))
      call HomLegendre(MuZ,maxK, homP(3,minK:maxK))
c
c  ...construct shape functions
      do k=minK,maxK
        do j=minJ,maxJ
          do i=minI,maxI
            m=m+1
c
            ShapQ(m) = homP(1,i)*homP(2,j)*homP(3,k)
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3),Nord(14)
 7001   format('shape3DQPyra: Xi = ',3f8.3,/,
     .         'Norder = ',i2)
        nordB = Nord(14)
        ndofB = nordB**3
        if (ndofB.gt.0) then
          write(*,7010)
 7010     format('BUBBLES = ')
          m=0
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapQ(m)
7002     format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DQPyra









c Routines:
c  - shape3DHTet
c  - shape3DETet
c  - shape3DVTet
c  - shape3DQTet
c--------------------------------------------------------------------
c
c     routine name      - shape3DHTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron element
c                         H1 shape functions and their derivatives
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHTet(X,Nord,NoriE,NoriF,Nsize,
     .                                              NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in)  :: Nord(11),NoriE(6),NoriF(4),Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: i,j,k,nij,nijk,m,v,e,f,N,ndofE,nordE,nordF,ndofF
      integer :: minI,minJ,minK,minIJ,minIJK,maxI,maxJ,maxK,maxIJ,maxIJK
      integer :: nordB,ndofB,iprint,minbeta
      logical :: IdecE,IdecF,IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
      double precision :: Lam(0:3),DLam(1:3,0:3)
      double precision :: LambV(4),DLambV(4,1:3)
      double precision :: LampE(6,0:1),DLampE(6,3,0:1)
      double precision :: GLampE(0:1),GDLampE(3,0:1)
      double precision :: LampF(4,0:2),DLampF(4,3,0:2)
      double precision :: GLampF(0:2),GDLampF(3,0:2)
      double precision :: phiE(2:Nsize(1)),DphiE(1:3,2:Nsize(1))
      double precision :: phiTri(2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: DphiTri(3,2:Nsize(1)-1,1:Nsize(1)-2)
      double precision :: homLbet(3:Nsize(1)-1,1:Nsize(1)-3)
      double precision :: DhomLbet(3,3:Nsize(1)-1,1:Nsize(1)-3)
      double precision :: templam(0:1),tempDlam(3,0:1)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimensions
      N=3
c
c  ...local parameters
      minI = 2; minJ = 1; minK = 1
      minIJ = minI+minJ;
      minIJK = minIJ+minK
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineTetrahedron(X, Lam,DLam)
c
c  ...VERTEX SHAPE FUNCTIONS
      call BlendTetV(Lam,DLam, LambV,DLambV)
      do v=1,4
       m=m+1
       ShapH(m) = LambV(v)
       GradH(1:N,m) = DLambV(v,1:N)
      enddo
c
c  ...EDGE SHAPE FUNCTIONS
      call ProjectTetE(Lam,DLam, LampE,DLampE,IdecE)
c  ...loop over edges
      do e=1,6
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE-1
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE
c      ...orient first
          call OrientE(LampE(e,0:1),DLampE(e,1:N,0:1),NoriE(e),N,
     .                                                   GLampE,GDLampE)
c      ...construct the shape functions
          call AncPhiE(GLampE,GDLampE,nordE,IdecE,N,
     .                             phiE(minI:maxI),DphiE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
            ShapH(m) = phiE(i)
            GradH(1:N,m) = DphiE(1:N,i)
          enddo
        endif
      enddo
c
c  ...FACE SHAPE FUNCTIONS
      call ProjectTetF(Lam,DLam, LampF,DLampF,IdecF)
c  ...loop over faces
      do f=1,4
c    ...local parameters
        nordF = Nord(6+f)
        ndofF = (nordF-1)*(nordF-2)/2
        if (ndofF.gt.0) then
c      ...local parameters (again)
          maxIJ = nordF
          maxI = maxIJ-minJ
          maxJ = maxIJ-minI
c      ...orient first
          call OrientTri(LampF(f,0:2),DLampF(f,1:N,0:2),NoriF(f),N,
     .                                                  GLampF,GDLampF)
c      ...construct the shape functions
          call AncPhiTri(GLampF,GDLampF,nordF,IdecF,N,
     .                                     phiTri(minI:maxI,minJ:maxJ),
     .                                DphiTri(1:N,minI:maxI,minJ:maxJ))
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+1
c
                ShapH(m) = phiTri(i,j)
                GradH(1:N,m) = DphiTri(1:N,i,j)
              enddo
            enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      nordB = Nord(11)
      ndofB = (nordB-1)*(nordB-2)*(nordB-3)/6
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecF; IdecB(2) = .TRUE.
        minbeta = 2*minIJ
        maxIJK = nordB
        maxIJ = maxIJK-minK
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
        maxK = maxIJK-minIJ
c    ...call phiTri and HomIJacobi - no need to orient
        call AncPhiTri(Lam(0:2),DLam(1:N,0:2),nordB-minK,IdecB(1),N,
     .                                     phiTri(minI:maxI,minJ:maxJ),
     .                                DphiTri(1:N,minI:maxI,minJ:maxJ))
        call HomIJacobi((/1-Lam(3),Lam(3)/),
     .           (/-DLam(1:N,3),DLam(1:N,3)/),maxK,minbeta,IdecB(2),N,
     .                                  homLbet(minIJ:maxIJ,minK:maxK),
     .                             DhomLbet(1:N,minIJ:maxIJ,minK:maxK))
        do nijk=minIJK,maxIJK
          do nij=minIJ,nijk-minK
            do i=minI,nij-minJ
                j=nij-i
                k=nijk-nij
                m=m+1
c
                ShapH(m) = phiTri(i,j)*homLbet(nij,k)
                GradH(1:N,m) = homLbet(nij,k)*DphiTri(1:N,i,j)
     .                       + phiTri(i,j)*DhomLbet(1:N,nij,k)
              enddo
            enddo
          enddo
      endif
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(1:11),
     .                NoriE(1:6),NoriF(1:4)
 7001   format('shape3DHTet: Xi = ',3f8.3,/,
     .         'Norder = ',6i2,3x,4i2,3x,i2,/,
     .         'orient = ',6i2,3x,4i2)
        write(*,7010)
 7010   format('VERTEX SHAPE FUNCTIONS = ')
        do v=1,4
          m=v
          write(*,7002) m,ShapH(m),GradH(1:3,m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,3e12.5)
        enddo
        do e=1,6
          ndofE = Nord(e)-1
          if (ndofE.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        do f=1,4
          nordF = Nord(6+f)
          ndofF = (nordF-1)*(nordF-2)/2
          if (ndofF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            do j=1,ndofF
              m=m+1
              write(*,7002) m,ShapH(m),GradH(1:3,m)
            enddo
          endif
        enddo
        nordB = Nord(11)
        ndofB = (nordB-1)*(nordB-2)*(nordB-3)/6
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapH(m),GradH(1:3,m)
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DHTet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DETet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron element
c                         H(curl) shape functions and their derivatives
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriE        - edge orientation
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - cur lof the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DETet(X,Nord,NoriE,NoriF,Nsize, 
     .                                              NrdofE,ShapE,CurlE)
c
      implicit none
      integer, intent(in)  :: Nord(11),NoriE(6),NoriF(4),Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: i,j,k,nij,nijk,m,v,e,f,N,nordE,ndofE,nordF,ndofF
      integer :: minI,minJ,minK,minIJ,minIJK,maxI,maxJ,maxK,maxIJ,maxIJK
      integer :: nordB,ndofB,iprint,minbeta,famctr,fam,abc(3),abcd(4),d
      logical :: IdecE,IdecF,IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapE(3,Nsize(2))
      double precision, intent(out) :: CurlE(3,Nsize(2))
      double precision :: Lam(0:3),DLam(3,0:3)
      double precision :: LampE(6,0:1),DLampE(6,3,0:1)
      double precision :: GLampE(0:1),GDLampE(3,0:1)
      double precision :: LampF(4,0:2),DLampF(4,3,0:2)
      double precision :: GLampF(0:2),GDLampF(3,0:2)
      double precision :: EE(3,0:Nsize(1)-1),CurlEE(3,0:Nsize(1)-1)
      double precision :: ETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: CurlETri(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: homLbet(1:Nsize(1)-1,1:Nsize(1)-1)
      double precision :: DhomLbet(1:3,1:Nsize(1)-1,1:Nsize(1)-1)
      double precision :: DhomLbetxETri(3)
c
c  ...debugging flag
      iprint=0
c
c  ...spatial dimension
      N=3
c
c  ...local parameters
      minI = 0; minJ = 1; minK = 1
      minIJ = minI+minJ
      minIJK = minIJ+minK
c
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineTetrahedron(X, Lam,DLam)
c
c  ...EDGE SHAPE FUNCTIONS
      call ProjectTetE(Lam,DLam, LampE,DLampE,IdecE)
c  ...loop over edges
      do e=1,6
c    ...local parameters
        nordE = Nord(e)
        ndofE = nordE
        if (ndofE.gt.0) then
c      ...local parameters (again)
          maxI = nordE-1
c      ...orient
          call OrientE(LampE(e,0:1),DLampE(e,1:N,0:1),NoriE(e),N,
     .                                                   GLampE,GDLampE)
c      ...construct the shape functions
          call AncEE(GLampE,GDLampE,nordE,IdecE,N, EE(1:N,minI:maxI),
     .                                            CurlEE(1:N,minI:maxI))
          do i=minI,maxI
            m=m+1
c
            ShapE(1:N,m) = EE(1:N,i)
            CurlE(1:N,m) = CurlEE(1:N,i)
          enddo
        endif
      enddo
c
c  ...FACE SHAPE FUNCTIONS
      call ProjectTetF(Lam,DLam, LampF,DLampF,IdecF)
c
c  ...loop over faces
      do f=1,4
c    ...local parameters
        nordF = Nord(6+f)
        ndofF = nordF*(nordF-1)/2
        if (ndofF.gt.0) then
c      ...local parameters (again)
          maxIJ = nordF-1
          maxI = maxIJ-minJ
          maxJ = maxIJ-minI
c      ...orient
          call OrientTri(LampF(f,0:2),DLampF(f,1:N,0:2),NoriF(f),N,
     .                                                   GLampF,GDLampF)
c      ...loop over families
          famctr=m
          do fam=0,1
            m=famctr+fam-1
            abc = cshift((/0,1,2/),fam)
c        ...construct the shape functions
            call AncETri(GLampF(abc),GDLampF(1:N,abc),nordF,IdecF,N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
            do nij=minIJ,maxIJ
              do i=minI,nij-minJ
                j=nij-i
                m=m+2
c
                ShapE(1:N,m) = ETri(1:N,i,j)
                CurlE(1:N,m) = CurlETri(1:N,i,j)
              enddo
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      nordB = Nord(11)
      ndofB = nordB*(nordB-1)*(nordB-2)/6
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecF; IdecB(2) = .TRUE.
        minbeta = 2*minIJ
        maxIJK = nordB-1
        maxIJ = maxIJK-minK
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
        maxK = maxIJK-minIJ
c    ...loop over families
        famctr=m
        do fam=0,2
          m=famctr+fam-2
          abcd = cshift((/0,1,2,3/),fam)
          abc = abcd(1:3)
          d = abcd(4)
c      ...now construct the shape functions (no need to orient)
          call AncETri(Lam(abc),DLam(1:N,abc),NordB-minK,IdecB(1),N,
     .                                    ETri(1:N,minI:maxI,minJ:maxJ),
     .                                CurlETri(1:N,minI:maxI,minJ:maxJ))
          call HomIJacobi((/1-Lam(d),Lam(d)/),
     .             (/-DLam(1:N,d),DLam(1:N,d)/),maxK,minbeta,IdecB(2),N,
     .                                   homLbet(minIJ:maxIJ,minK:maxK),
     .                              DhomLbet(1:N,minIJ:maxIJ,minK:maxK))

          do nijk=minIJK,maxIJK
            do nij=minIJ,nijk-minK
              do i=minI,nij-minJ
                j=nij-i
                k=nijk-nij
                m=m+3
c
                ShapE(1:N,m) = ETri(1:N,i,j)*homLbet(nij,k)
c
                call cross(N,DhomLbet(1:N,nij,k),ETri(1:N,i,j),
     .                                                   DhomLbetxETri)
c
                CurlE(1:N,m) = homLbet(nij,k)*CurlETri(1:N,i,j)
     .                       + DhomLbetxETri
              enddo
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(1:11),
     .                NoriE(1:6),NoriF(1:4)
 7001   format('shape3DETet: Xi = ',3f8.3,/,
     .         'Norder = ',6i2,3x,4i2,3x,i2,/,
     .         'orient = ',6i2,3x,4i2)
        m=0
        do e=1,6
          ndofE = Nord(e)
          if (ndofE.gt.0) then
            write(*,7011) e
 7011       format('SHAPE FUNCTIONS FOR EDGE = ',i2)
            do j=1,ndofE
              m=m+1
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
 7002         format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
            enddo
          endif
        enddo
        do f=1,4
          nordF = Nord(6+f)
          ndofF = nordF*(nordF-1)/2
          if (ndofF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            famctr=m
            do fam=0,1
              m=famctr+fam-1
              write(*,7003) fam
 7003         format('family = ',i2)
              do j=1,ndofF
                m=m+2
                write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
              enddo
            enddo
          endif
        enddo
        nordB = Nord(11)
        ndofB = nordB*(nordB-1)*(nordB-2)/6
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          famctr=m
          do fam=0,2
            m=famctr-fam-2
            write(*,7003) fam
            do j=1,ndofB
              m=m+3
              write(*,7002) m,ShapE(1:N,m),CurlE(1:N,m)
            enddo
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DETet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron element
c                         H(div) shape functions and their divergences
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          NoriF        - face orientation
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVTet(X,Nord,NoriF,Nsize, NrdofV,ShapV,DivV)
c
      implicit none
      integer, intent(in)  :: Nord(11),NoriF(4),Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: i,j,k,nij,nijk,m,f,N,nordF,ndofF
      integer :: minI,minJ,minK,minIJ,minIJK,maxI,maxJ,maxK,maxIJ,maxIJK
      integer :: nordB,ndofB,iprint,minbeta,famctr,fam,abc(3),abcd(4),d
      logical :: IdecE,IdecF,IdecB(2)
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapV(3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: Lam(0:3),DLam(3,0:3)
      double precision :: LampF(4,0:2),DLampF(4,3,0:2)
      double precision :: GLampF(0:2),GDLampF(3,0:2)
      double precision :: VTri(3,0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: DivVTri(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: homLbet(0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: DhomLbet(3,0:Nsize(1)-2,1:Nsize(1)-1)
      double precision :: DhomLbetVTri
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c
c  ...local parameters
      minI = 0; minJ = 0; minK = 1
      minIJ = minI+minJ;
      minIJK = minIJ+minK
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineTetrahedron(X, Lam,DLam)
c
c  ...FACE SHAPE FUNCTIONS
      call ProjectTetF(Lam,DLam, LampF,DLampF,IdecF)
      do f=1,4
c    ...local parameters
        nordF = Nord(6+f)
        ndofF = (nordF+1)*nordF/2
        if (ndofF.gt.0) then
c      ...local parameters (again)
          maxIJ = nordF-1
          maxI = maxIJ-minJ
          maxJ = maxIJ-minI
c      ...orient
          call OrientTri(LampF(f,0:2),DLampF(f,1:N,0:2),NoriF(f),N,
     .                                                   GLampF,GDLampF)
c      ...construct the shape functions
          call AncVTri(GLampF,GDLampF,nordF,IdecF,N,
     .                                    VTri(1:N,minI:maxI,minJ:maxJ),
     .                                     DivVTri(minI:maxI,minJ:maxJ))
          do nij=minIJ,maxIJ
            do i=minI,nij-minJ
              j=nij-i
              m=m+1
c
              ShapV(1:N,m) = VTri(1:N,i,j)
              DivV(m) = DivVTri(i,j)
            enddo
          enddo
        endif
      enddo
c
c  ...BUBBLE FUNCTIONS
c  ...local parameters
      nordB = Nord(11)
      ndofB = (nordB+1)*nordB*(nordB-1)/6
c  ...if necessary, create bubbles
      if (ndofB.gt.0) then
c    ...local parameters (again)
        IdecB(1) = IdecF; IdecB(2) = .TRUE.
        minbeta = 2*(minIJ+1)
        maxIJK = nordB-1
        maxIJ = maxIJK-minK
        maxI = maxIJ-minJ
        maxJ = maxIJ-minI
        maxK = maxIJK-minIJ
c    ...loop over families
        famctr=m
        do fam=0,2
          m=famctr+fam-2
          abcd = cshift((/0,1,2,3/),fam)
          abc = abcd(1:3)
          d = abcd(4)
c      ...construct the shape functions (no need to orient)
          call AncVTri(Lam(abc),DLam(1:N,abc),nordB-minK,IdecB(1),N,
     .                                    VTri(1:N,minI:maxI,minJ:maxJ),
     .                                     DivVTri(minI:maxI,minJ:maxJ))
          call HomIJacobi((/1-Lam(d),Lam(d)/),
     .             (/-DLam(1:N,d),DLam(1:N,d)/),maxK,minbeta,IdecB(2),N,
     .                                   homLbet(minIJ:maxIJ,minK:maxK),
     .                              DhomLbet(1:N,minIJ:maxIJ,minK:maxK))
          do nijk=minIJK,maxIJK
            do nij=minIJ,nijk-minK
              do i=minI,nij-minJ
                j=nij-i
                k=nijk-nij
                m=m+3
c
                ShapV(1:N,m) = VTri(1:N,i,j)*homLbet(nij,k)
c
                call dot_product(DhomLbet(1:N,nij,k),VTri(1:N,i,j),
     .                                                     DhomLbetVTri)
c
                DivV(m) = homLbet(nij,k)*DivVTri(i,j)+DhomLbetVTri
              enddo
            enddo
          enddo
        enddo
      endif
c
c  ...give total degrees of freedom
      NrdofV = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(7:11),NoriF(1:4)
 7001   format('shape3DVTet: Xi = ',3f8.3,/,
     .         'Norder = ',3(4i2,2x),2i3,2x,4i3,3x,i4,/,
     .         'orient = ',3(4i2,2x),2i3,2x,4i3)
        m=0
        do f=1,4
          nordF = Nord(6+f)
          ndofF = (nordF+1)*nordF/2
          if (ndofF.gt.0) then
            write(*,7012) f
 7012       format('SHAPE FUNCTIONS FOR FACE = ',i2)
            do j=1,ndofF
              m=m+1
              write(*,7002) m,ShapV(1:N,m),DivV(m)
 7002         format('k = ',i3,' ShapV, DivV= ',3e12.5,3x,e12.5)
            enddo
          endif
        enddo
        nordB = Nord(11)
        ndofB = (nordB+1)*nordB*(nordB-1)/6
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          famctr=m
          do fam=0,2
            m=famctr+fam-2
            write(*,7003) fam
 7003       format('family ',i2)
            do j=1,ndofB
              m=m+3
              write(*,7002) m,ShapV(1:N,m),DivV(m)
            enddo
          enddo
        endif
c        call pause
      endif
c
c
      end subroutine shape3DVTet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Oct 14, Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron
c                         element L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          Nord         - polynomial order for the nodes (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQTet(X,Nord,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: Nord(11),Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: i,j,k,nij,nijk,m,N,nordB,ndofB,iprint,minalpha,minbeta
      integer :: minI,minJ,minK,minIJ,minIJK,maxI,maxJ,maxK,maxIJ,maxIJK
      double precision, intent(in)  :: X(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
      double precision :: Lam(0:3),DLam(1:3,0:3)
      double precision :: homP(0:Nsize(1)-1)
      double precision :: homPal(0:Nsize(1)-1,0:Nsize(1)-1)
      double precision :: homPbet(0:Nsize(1)-1,0:Nsize(1)-1)
c
c  ...debugging flag
      iprint=0
c  ...spatial dimensions
      N=3
c  ...initiate counter for shape functions
      m=0
c
c  ...Define affine coordinates and gradients
      call AffineTetrahedron(X, Lam,DLam)
c
c  ...local parameters
      nordB = Nord(11)
      ndofB = (nordB+2)*(nordB+1)*nordB/6
      minI = 0; minJ = 0; minK = 0
      minIJ = minI+minJ
      minIJK = minIJ+minK
      minalpha = 2*minI+1
      minbeta = 2*(minIJ+1)
      maxIJK = NordB-1
      maxIJ = maxIJK-minK
      maxI = maxIJ-minJ
      maxJ = maxIJ-minI
      maxK = maxIJK-minIJ
c
c  ...get homogenized Legendre polynomials, homP
      call HomLegendre(Lam(0:1),maxI, homP(minI:maxI))
c
c  ...get homogenized Jacobi polynomials, homPal
      call HomJacobi((/Lam(0)+Lam(1),Lam(2)/),maxIJ,minalpha,
     .                                      homPal(minI:maxI,minJ:maxJ))
c  ...get homogenized Jacobi polynomials, homPbet
      call HomJacobi((/1-Lam(3),Lam(3)/),maxK,minbeta,
     .                                   homPbet(minIJ:maxIJ,minK:maxK))
c
c  ...construct shape functions
      do nijk=minIJK,maxIJK
        do nij=minIJ,nijk-minK
          do i=minI,nij-minJ
            j=nij-i
            k=nijk-nij
            m=m+1
c
            ShapQ(m) = homP(i)*homPal(i,j)*homPbet(nij,k)
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofQ = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) X(1:3),Nord(11)
 7001   format('shape3DQTet: Xi = ',3f8.3,/,
     .         'Norder = ',i2)
        nordB = Nord(11)
        ndofB = (nordB+2)*(nordB+1)*nordB/6
        if (ndofB.gt.0) then
          write(*,7013)
 7013     format('BUBBLES = ')
          m=0
          do j=1,ndofB
            m=m+1
            write(*,7002) m,ShapQ(m)
7002     format('k = ',i3,' ShapQ = ',e12.5)
          enddo
        endif
c        call pause
      endif
c
      end subroutine shape3DQTet










c
c----------------------------------------------------------------------
c
c   routine name       - cross
c
c----------------------------------------------------------------------
c
c   latest revision    - Dec 13
c
c   purpose            - routine evaluates cross product of two
c                        vectors in R^2 or R^3
c
c   arguments :
c     in:    
c           N          - space dimension N=2,3
c           A,B        - vectors in R^N
c     out: 
c           C          - scalar (R^2) or vector (R^3)
c
c----------------------------------------------------------------------
c
      subroutine cross(N,A,B, C)
c
c#include "syscom.blk"
c
      real*8 A(N),B(N), C(2*N-3)
c
      if (N.eq.3) then    
        C(1) =   A(2)*B(3) - A(3)*B(2)
        C(2) = - A(1)*B(3) + A(3)*B(1)
      endif
      C(2*N-3) =   A(1)*B(2) - A(2)*B(1)
c
      end subroutine cross


c
c----------------------------------------------------------------------
c
c   routine name       - dot_product
c
c----------------------------------------------------------------------
c
c   latest revision    - Apr 14
c
c   purpose            - routine evaluates dot product  of two
c                        vectors in R^3
c
c   arguments :
c     in:    
c           A,B        - vectors in R^3
c     out: 
c           Prod       - value of the product
c
c----------------------------------------------------------------------
c
      subroutine dot_product(A,B, Prod)
c
c#include "syscom.blk"
c
      real*8 A(3),B(3),Prod
c
      Prod = 0.d0
      do i=1,3
        Prod = Prod + A(i)*B(i)
      enddo
c
      end subroutine dot_product









c Routines:
c  - shape3DHBrokenHexa
c  - shape3DEBrokenHexa
c  - shape3DVBrokenHexa
c  - shape3DQBrokenHexa
c--------------------------------------------------------------------
c
c     routine name      - shape3DHBrokenHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHBrokenHexa(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(12),noriF(6),norder(19),nordF(3)
      integer :: i,j,k,m
      integer :: nordB(3),ndofH(3),iprint
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
      double precision :: shapH1(Nsize(1)+1),dshapH1(Nsize(1)+1)
      double precision :: shapH2(Nsize(1)+1),dshapH2(Nsize(1)+1)
      double precision :: shapH3(Nsize(1)+1),dshapH3(Nsize(1)+1)
c
c  ...Option 1: Simply call the usual shape functions with enrichment
c      noriE(1:12)=0
c      noriF(1:6)=0
c      call decod(NordM,MODORDER,2, (/nordF(1),nordB(3)/))
c      call decod(nordF(1),MODORDER,2, nordB(1:2))
c      call encod((/nordB(1),nordB(3)/),MODORDER,2, nordF(2))
c      call encod(nordB(2:3),MODORDER,2, nordF(3))
c      norder(1:4)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
c      norder(5:8)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
c      norder(9:12)=nordB(3)
c      norder(13:14)=nordF(1)
c      norder(15:18)=(/nordF(2),nordF(3),nordF(2),nordF(3)/)
c      norder(19)=NordM
c      call shape3DHHexa(Xi,norder,noriE,noriF,Nsize,
c     .                                             NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c  ...debugging flag
      iprint=0
c  ...initiate counter for shape functions
      m=0
c
c  ...shape functions are tensor products of 1D shape functions
      call decod(NordM,MODORDER,3, nordB)
      call shape1HH(Xi(1),nordB(1), ndofH(1),shapH1,dshapH1)
      call shape1HH(Xi(2),nordB(2), ndofH(2),shapH2,dshapH2)
      call shape1HH(Xi(3),nordB(3), ndofH(3),shapH3,dshapH3)
c
      do k=1,ndofH(3)
        do j=1,ndofH(2)
          do i=1,ndofH(1)
            m=m+1
            ShapH(m)   =  shapH1(i)* shapH2(j)* shapH3(k)
            GradH(1,m) = dshapH1(i)* shapH2(j)* shapH3(k)
            GradH(2,m) =  shapH1(i)*dshapH2(j)* shapH3(k)
            GradH(3,m) =  shapH1(i)* shapH2(j)*dshapH3(k)
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofH = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3)
 7001   format('shape3DHBrokenHexa: Xi = ',3f8.3)
        do m=1,NrdofH
          write(*,7002) m,ShapH(m),GradH(1:3,m)
 7002     format('k = ',i3,' ShapH, GradH = ',e12.5,3x,3e12.5)
        enddo
c        call pause
      endif
c
c
      end subroutine shape3DHBrokenHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEBrokenHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEBrokenHexa(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(12),noriF(6),norder(19),nordF(3)
      integer :: i,j,k,m
      integer :: nordB(3),ndofH(3),ndofQ(3),iprint
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(1:3,Nsize(2))
      double precision, intent(out) :: CurlE(1:3,Nsize(2))
      double precision :: shapH1(Nsize(1)+1),dshapH1(Nsize(1)+1)
      double precision :: shapH2(Nsize(1)+1),dshapH2(Nsize(1)+1)
      double precision :: shapH3(Nsize(1)+1),dshapH3(Nsize(1)+1)
      double precision :: shapQ1(Nsize(1))
      double precision :: shapQ2(Nsize(1))
      double precision :: shapQ3(Nsize(1))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
c      noriE(1:12)=0
c      noriF(1:6)=0
c      call decod(NordM,MODORDER,2, (/nordF(1),nordB(3)/))
c      call decod(nordF(1),MODORDER,2, nordB(1:2))
c      call encod((/nordB(1),nordB(3)/),MODORDER,2, nordF(2))
c      call encod(nordB(2:3),MODORDER,2, nordF(3))
c      norder(1:4)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
c      norder(5:8)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
c      norder(9:12)=nordB(3)
c      norder(13:14)=nordF(1)
c      norder(15:18)=(/nordF(2),nordF(3),nordF(2),nordF(3)/)
c      norder(19)=NordM
c      call shape3DEHexa(Xi,norder,noriE,noriF,Nsize,
c     .                                             NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c  ...debugging flag
      iprint=0
c  ...initiate counter for shape functions
      m=0
c
c  ...shape functions are tensor products of 1D shape functions
      call decod(NordM,MODORDER,3, nordB)
      call shape1HH(Xi(1),nordB(1), ndofH(1),shapH1,dshapH1)
      call shape1HH(Xi(2),nordB(2), ndofH(2),shapH2,dshapH2)
      call shape1HH(Xi(3),nordB(3), ndofH(3),shapH3,dshapH3)
      call shape1QQ(Xi(1),nordB(1), ndofQ(1),shapQ1)
      call shape1QQ(Xi(2),nordB(2), ndofQ(2),shapQ2)
      call shape1QQ(Xi(3),nordB(3), ndofQ(3),shapQ3)
c
c  ...shape functions with values along the x-axis
      do k=1,ndofH(3)
        do j=1,ndofH(2)
          do i=1,ndofQ(1)
            m=m+1
            ShapE(1,m) =  shapQ1(i)*shapH2(j)* shapH3(k)
            ShapE(2,m) =  0.d0
            ShapE(3,m) =  0.d0
            CurlE(1,m) =  0.d0
            CurlE(2,m) =  shapQ1(i)* shapH2(j)*dshapH3(k)
            CurlE(3,m) = -shapQ1(i)*dshapH2(j)* shapH3(k)
          enddo
        enddo
      enddo
c
c  ...shape functions with values along the y-axis
      do k=1,ndofH(3)
        do j=1,ndofQ(2)
          do i=1,ndofH(1)
            m=m+1
            ShapE(1,m) =  0.d0
            ShapE(2,m) =  shapH1(i)*shapQ2(j)* shapH3(k)
            ShapE(3,m) =  0.d0
            CurlE(1,m) = -shapH1(i)*shapQ2(j)*dshapH3(k)
            CurlE(2,m) =  0.d0
            CurlE(3,m) = dshapH1(i)*shapQ2(j)* shapH3(k)
          enddo
        enddo
      enddo
c
c  ...shape functions with values along the z-axis
      do k=1,ndofQ(3)
        do j=1,ndofH(2)
          do i=1,ndofH(1)
            m=m+1
            ShapE(1,m) = 0.d0
            ShapE(2,m) = 0.d0
            ShapE(3,m) =  shapH1(i)* shapH2(j)* shapQ3(k)
            CurlE(1,m) =  shapH1(i)*dshapH2(j)* shapQ3(k)
            CurlE(2,m) =-dshapH1(i)* shapH2(j)* shapQ3(k)
            CurlE(3,m) = 0.d0
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofE = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3)
 7001   format('shape3DEBrokenHexa: Xi = ',3f8.3)
        do m=1,NrdofE
          write(*,7002) k,ShapE(1:3,m),CurlE(1:3,m)
 7002     format('k = ',i3,' ShapE, CurlE = ',3e12.5,3x,3e12.5)
        enddo
c        call pause
      endif
c
c
      end subroutine shape3DEBrokenHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVBrokenHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVBrokenHexa(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriF(6),norder(19),nordF(3)
      integer :: i,j,k,m
      integer :: nordB(3),ndofH(3),ndofQ(3),iprint
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(1:3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
      double precision :: shapH1(Nsize(1)+1),dshapH1(Nsize(1)+1)
      double precision :: shapH2(Nsize(1)+1),dshapH2(Nsize(1)+1)
      double precision :: shapH3(Nsize(1)+1),dshapH3(Nsize(1)+1)
      double precision :: shapQ1(Nsize(1))
      double precision :: shapQ2(Nsize(1))
      double precision :: shapQ3(Nsize(1)) 
c
c  ...Option 1: Simply call the usual shape functions with enrichment
c      noriF(1:6)=0
c      call decod(NordM,MODORDER,2, (/nordF(1),nordB(3)/))
c      call decod(nordF(1),MODORDER,2, nordB(1:2))
c      call encod((/nordB(1),nordB(3)/),MODORDER,2, nordF(2))
c      call encod(nordB(2:3),MODORDER,2, nordF(3))
c      norder(1:12)=1
c      norder(13:14)=nordF(1)
c      norder(15:18)=(/nordF(2),nordF(3),nordF(2),nordF(3)/)
c      norder(19)=NordM
c      call shape3DVHexa(Xi,norder,noriF,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c  ...debugging flag
      iprint=0
c  ...initiate counter for shape functions
      m=0
c
c  ...shape functions are tensor products of 1D shape functions
      call decod(NordM,MODORDER,3, nordB)
      call shape1HH(Xi(1),nordB(1), ndofH(1),shapH1,dshapH1)
      call shape1HH(Xi(2),nordB(2), ndofH(2),shapH2,dshapH2)
      call shape1HH(Xi(3),nordB(3), ndofH(3),shapH3,dshapH3)
      call shape1QQ(Xi(1),nordB(1), ndofQ(1),shapQ1)
      call shape1QQ(Xi(2),nordB(2), ndofQ(2),shapQ2)
      call shape1QQ(Xi(3),nordB(3), ndofQ(3),shapQ3)
c
c  ...shape functions with values along the x-axis
      do k=1,ndofQ(3)
        do j=1,ndofQ(2)
          do i=1,ndofH(1)
            m=m+1
            ShapV(1,m) =  shapH1(i)* shapQ2(j)* shapQ3(k)
            ShapV(2,m) = 0.d0
            ShapV(3,m) = 0.d0
            DivV(m)    = dshapH1(i)* shapQ2(j)* shapQ3(k)
          enddo
        enddo
      enddo
c
c  ...shape functions with values along the y-axis
      do k=1,ndofQ(3)
        do j=1,ndofH(2)
          do i=1,ndofQ(1)
            m=m+1
            ShapV(1,m) = 0.d0
            ShapV(2,m) =  shapQ1(i)* shapH2(j)* shapQ3(k)
            ShapV(3,m) = 0.d0
            DivV(m)    =  shapQ1(i)*dshapH2(j)* shapQ3(k)
          enddo
        enddo
      enddo
c
c  ...shape functions with values along the z-axis
      do k=1,ndofH(3)
        do j=1,ndofQ(2)
          do i=1,ndofQ(1)
            m=m+1
            ShapV(1,m) = 0.d0
            ShapV(2,m) = 0.d0
            ShapV(3,m) =  shapQ1(i)* shapQ2(j)* shapH3(k)
            DivV(m)    =  shapQ1(i)* shapQ2(j)*dshapH3(k)
          enddo
        enddo
      enddo
c
c  ...give total degrees of freedom
      NrdofV = m
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7001) Xi(1:3)
 7001   format('shape3DVBrokenHexa: Xi = ',3f8.3)
        do m=1,NrdofV
          write(*,7002) m,ShapV(1:3,m),DivV(m)
 7002     format('k = ',i3,' ShapV, DivV = ',3e12.5,3x,e12.5)
        enddo
c        call pause
      endif
c
c
      end subroutine shape3DVBrokenHexa
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQBrokenHexa
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D hexahedron
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master hexahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQBrokenHexa(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(19),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:12)=1
      call encod((/1,1/),MODORDER,2, nordF)
      norder(13:18)=nordF
      norder(19)=NordM
      call shape3DQHexa(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape3DQBrokenHexa










c Routines:
c  - shape3DHBrokenPris
c  - shape3DEBrokenPris
c  - shape3DVBrokenPris
c  - shape3DQBrokenPris
c--------------------------------------------------------------------
c
c     routine name      - shape3DHBrokenPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D prism
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHBrokenPris(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(9),noriF(5),norder(15),nordB(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:9)=0
      noriF(1:5)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:6)=nordB(1)
      norder(7:9)=nordB(2)
      norder(10:11)=nordB(1)
      norder(12:14)=NordM
      norder(15)=NordM
      call shape3DHPris(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DHBrokenPris
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEBrokenPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D prism
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEBrokenPris(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(9),noriF(5),norder(15),nordB(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(1:3,Nsize(2))
      double precision, intent(out) :: CurlE(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:9)=0
      noriF(1:5)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:6)=nordB(1)
      norder(7:9)=nordB(2)
      norder(10:11)=nordB(1)
      norder(12:14)=NordM
      norder(15)=NordM
      call shape3DEPris(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DEBrokenPris
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVBrokenPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D prism
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVBrokenPris(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriF(5),norder(15),nordB(2)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(1:3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriF(1:5)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:9)=1
      norder(10:11)=nordB(1)
      norder(12:14)=NordM
      norder(15)=NordM
      call shape3DVPris(Xi,norder,noriF,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DVBrokenPris
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQBrokenPris
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D prism
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master prism coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQBrokenPris(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(15),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:11)=1
      call encod((/1,1/),MODORDER,2, nordF)
      norder(12:14)=nordF
      norder(15)=NordM
      call shape3DQPris(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape3DQBrokenPris








c Routines:
c  - shape3DHBrokenPyra
c  - shape3DEBrokenPyra
c  - shape3DVBrokenPyra
c  - shape3DQBrokenPyra
c--------------------------------------------------------------------
c
c     routine name      - shape3DHBrokenPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D pyramid
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master pyramid coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHBrokenPyra(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(8),noriF(5),norder(14),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:8)=0
      noriF(1:5)=0
      norder(1:8)=NordM
      call encod((/NordM,NordM/),MODORDER,2, nordF)
      norder(9)=nordF
      norder(10:13)=NordM
      norder(14)=NordM
      call shape3DHPyra(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DHBrokenPyra
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEBrokenPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D pyramid
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master pyramid coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEBrokenPyra(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(8),noriF(5),norder(14),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(1:3,Nsize(2))
      double precision, intent(out) :: CurlE(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:8)=0
      noriF(1:5)=0
      norder(1:8)=NordM
      call encod((/NordM,NordM/),MODORDER,2, nordF)
      norder(9)=nordF
      norder(10:13)=NordM
      norder(14)=NordM
      call shape3DEPyra(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DEBrokenPyra
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVBrokenPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D pyramid
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master pyramid coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVBrokenPyra(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriF(5),norder(14),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(1:3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriF(1:5)=0
      norder(1:8)=1
      call encod((/NordM,NordM/),MODORDER,2, nordF)
      norder(9)=nordF
      norder(10:13)=NordM
      norder(14)=NordM
      call shape3DVPyra(Xi,norder,noriF,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DVBrokenPyra
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQBrokenPyra
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D pyramid
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master pyramid coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQBrokenPyra(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(14),nordF
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:8)=1
      call encod((/1,1/),MODORDER,2, nordF)
      norder(9)=nordF
      norder(10:13)=1
      norder(14)=NordM
      call shape3DQPyra(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape3DQBrokenPyra








c Routines:
c  - shape2DHBrokenQuad
c  - shape2DEBrokenQuad
c  - shape2DVBrokenQuad
c  - shape2DQBrokenQuad
c--------------------------------------------------------------------
c
c     routine name      - shape2DHBrokenQuad
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D quadrilateral
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master quadrilateral coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DHBrokenQuad(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(4),norder(5),nordB(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:2,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:4)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:4)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
      norder(5)=NordM
      call shape2DHQuad(Xi,norder,noriE,Nsize, NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DHBrokenQuad
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DEBrokenQuad
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D quadrilateral
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master quadrilateral coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DEBrokenQuad(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(4),norder(5),nordB(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapE(1:2,Nsize(2))
      double precision, intent(out) :: CurlE(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:4)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:4)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
      norder(5)=NordM
      call shape2DEQuad(Xi,norder,noriE,Nsize, NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DEBrokenQuad
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DVBrokenQuad
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D quadrilateral
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master quadrilateral coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DVBrokenQuad(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      use parameters , only : MODORDER
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriE(4),norder(5),nordB(2)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapV(1:2,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:4)=0
      call decod(NordM,MODORDER,2, nordB)
      norder(1:4)=(/nordB(1),nordB(2),nordB(1),nordB(2)/)
      norder(5)=NordM
      call shape2DVQuad(Xi,norder,noriE,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DVBrokenQuad
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DQBrokenQuad
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D quadrilateral
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master quadrilateral coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape2DQBrokenQuad(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(5)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:4)=1
      norder(5)=NordM
      call shape2DQQuad(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape2DQBrokenQuad









c Routines:
c  - shape1DHBrokenSeg
c  - shape1DQBrokenSeg
c--------------------------------------------------------------------
c
c     routine name      - shape1DHBrokenSeg
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 1D segment
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master segment coordinates from (0,1)
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape1DHBrokenSeg(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapH(Nsize(2)),GradH(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      call shape1DHSeg(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape1DHBrokenSeg
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape1DQBrokenSeg
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 1D segment
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master segment coordinates from (0,1)
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape1DQBrokenSeg(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      double precision, intent(in)  :: Xi
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      call shape1DQSeg(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape1DQBrokenSeg





c Routines:
c  - shape3DHBrokenTet
c  - shape3DEBrokenTet
c  - shape3DVBrokenTet
c  - shape3DQBrokenTet
c--------------------------------------------------------------------
c
c     routine name      - shape3DHBrokenTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DHBrokenTet(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(6),noriF(4),norder(11)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:6)=0
      noriF(1:4)=0
      norder(1:11)=NordM
      call shape3DHTet(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DHBrokenTet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DEBrokenTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DEBrokenTet(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(6),noriF(4),norder(11)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapE(1:3,Nsize(2))
      double precision, intent(out) :: CurlE(1:3,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:6)=0
      noriF(1:4)=0
      norder(1:11)=NordM
      call shape3DETet(Xi,norder,noriE,noriF,Nsize,
     .                                             NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DEBrokenTet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DVBrokenTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape3DVBrokenTet(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriF(4),norder(11)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapV(1:3,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriF(1:4)=0
      norder(1:6)=1
      norder(7:11)=NordM
      call shape3DVTet(Xi,norder,noriF,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape3DVBrokenTet
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape3DQBrokenTet
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 3D tetrahedron
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master tetrahedron coordinates from (0,1)^3
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape3DQBrokenTet(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(11)
      double precision, intent(in)  :: Xi(3)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:10)=1
      norder(11)=NordM
      call shape3DQTet(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape3DQBrokenTet







c Routines:
c  - shape2DHBrokenTri
c  - shape2DEBrokenTri
c  - shape2DVBrokenTri
c  - shape2DQBrokenTri
c--------------------------------------------------------------------
c
c     routine name      - shape2DHBrokenTri
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D triangle
c                         BROKEN H1 shape functions
c
c     arguments:
c
c     in:
c          X            - master triangle coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofH       - number of dof
c          ShapH        - values of the shape functions at the point
c          GradH        - gradients of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DHBrokenTri(Xi,NordM,Nsize, NrdofH,ShapH,GradH)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofH
      integer :: noriE(3),norder(4)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapH(Nsize(2))
      double precision, intent(out) :: GradH(1:2,Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:3)=0
      norder(1:4)=NordM
      call shape2DHTri(Xi,norder,noriE,Nsize, NrdofH,ShapH,GradH)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DHBrokenTri
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DEBrokenTri
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D triangle
c                         BROKEN H(curl) shape functions
c
c     arguments:
c
c     in:
c          X            - master triangle coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofE       - number of dof
c          ShapE        - values of the shape functions at the point
c          CurlE        - curl of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DEBrokenTri(Xi,NordM,Nsize, NrdofE,ShapE,CurlE)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofE
      integer :: noriE(3),norder(4)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapE(1:2,Nsize(2))
      double precision, intent(out) :: CurlE(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:3)=0
      norder(1:4)=NordM
      call shape2DETri(Xi,norder,noriE,Nsize, NrdofE,ShapE,CurlE)
c
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DEBrokenTri
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DVBrokenTri
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D triangle
c                         BROKEN H(div) shape functions
c
c     arguments:
c
c     in:
c          X            - master triangle coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofV       - number of dof
c          ShapV        - values of the shape functions at the point
c          DivV         - divergence of the shape functions
c
c-----------------------------------------------------------------------
c
      subroutine shape2DVBrokenTri(Xi,NordM,Nsize, NrdofV,ShapV,DivV)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofV
      integer :: noriE(3),norder(4)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapV(1:2,Nsize(2))
      double precision, intent(out) :: DivV(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      noriE(1:3)=0
      norder(1:4)=NordM
      call shape2DVTri(Xi,norder,noriE,Nsize, NrdofV,ShapV,DivV)
c
c  ...Option 2: Write more efficient routine for enriched functions
c
c
      end subroutine shape2DVBrokenTri
c
c
c--------------------------------------------------------------------
c
c     routine name      - shape2DQBrokenTri
c
c--------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine returns values of 2D triangle
c                         BROKEN L2 shape functions
c
c     arguments:
c
c     in:
c          X            - master triangle coordinates from (0,1)^2
c          NordM        - polynomial order for middle node (H1 sense)
c          Nsize        - relevant sizes of local arrays
c
c     out:
c          NrdofQ       - number of dof
c          ShapQ        - values of the shape functions at the point
c
c-----------------------------------------------------------------------
c
      subroutine shape2DQBrokenTri(Xi,NordM,Nsize, NrdofQ,ShapQ)
c
      implicit none
      integer, intent(in)  :: NordM,Nsize(2)
      integer, intent(out) :: NrdofQ
      integer :: norder(4)
      double precision, intent(in)  :: Xi(2)
      double precision, intent(out) :: ShapQ(Nsize(2))
c
c  ...Option 1: Simply call the usual shape functions with enrichment
      norder(1:3)=1
      norder(4)=NordM
      call shape2DQTri(Xi,norder,Nsize, NrdofQ,ShapQ)
c
c  ...Option 2: Write a separate routine for enriched functions
c
c
      end subroutine shape2DQBrokenTri







c Routines:
c  - checkorder
c----------------------------------------------------------------------
c
c     routine name      - checkorder
c
c----------------------------------------------------------------------
c
c     latest revision:  - Apr 17
c
c     purpose:          - routine checks whether polynomial orders of 
c                         edges, faces and bubbles are within 
c                         appropriate bounds. Returns values that help
c                         to more efficiently size temporary arrays in
c                         other routines in order to save memory.
c
c     arguments:
c
c     in:
c       Type            - element type
c       Dtype           - discretization type (H1,H(curl),H(div),L2)
c       Norder          - polynomial order for the nodes (H1 sense)
c       MaxOrd          - maximum polynomial order allowed
c
c     out:
c       Nsize           - highest polynomial order in Norder and other
c                         values that help appropriately size arrays
c
c---------------------------------------------------------------------- 
c
      subroutine checkorder(Type,Dtype,Norder,MaxOrd, Nsize, NN)
c
      use parameters , only : MODORDER
c
      implicit none
      character(len=4), intent(in)  :: Type
      character(len=6), intent(in)  :: Dtype
      integer, intent(in)  :: NN
      integer, intent(in)  :: Norder(NN)
      integer, intent(in)  :: MaxOrd
      integer, intent(out) :: Nsize(2)
      integer :: minp,maxp,nps(27),m,f,nordF(2),nordB(3),iprint
      logical :: confident
c
c  ...intialize printing flag
      iprint = 0
c
c  ...The flag confident determines whether you are confident enough to
c     NOT make a check to Norder. In that case, it is assumed all orders 
c     are less than MaxOrd, and the size of the arrays assume the worst
c     case scenario (with MaxOrd).
c  ...If you are not confident enough (default), this routine will check
c     whether the values in Norder lie below MaxOrd, and will determine
c     the maximum order in Norder and size temporary arrays accordingly
c     in the shape element routines.
      confident=.FALSE.
      if (confident) then
        minp=1
        maxp=MaxOrd
      else
        select case(Type)
        case('bric','mdlb')
          m=12
          nps(1:m)=Norder(1:m)
          do f=1,6
            call decod(Norder(12+f),MODORDER,2, nordF)
            nps(m+1)=nordF(1)
            nps(m+2)=nordF(2)
            m=m+2
          enddo
          call decod(Norder(19),MODORDER,3, nordB)
          nps(m+1)=nordB(1)
          nps(m+2)=nordB(2)
          nps(m+3)=nordB(3)
          m=m+3
        case('tetr','mdln')
          m=11
          nps(1:m)=Norder(1:m)
        case('pris','mdlp')
          m=11
          nps(1:m)=Norder(1:m)
          do f=1,3
            call decod(Norder(11+f),MODORDER,2, nordF)
            nps(m+1)=nordF(1)
            nps(m+2)=nordF(2)
            m=m+2
          enddo
          call decod(Norder(15),MODORDER,2, nordB(1:2))
          nps(m+1)=nordB(1)
          nps(m+2)=nordB(2)
          m=m+2
        case('pyra','mdld')
          m=8
          nps(1:m)=Norder(1:m)
          call decod(Norder(9),MODORDER,2, nordF)
          nps(m+1)=nordF(1)
          nps(m+2)=nordF(2)
          m=m+2
          nps(m+1:m+5)=Norder(10:14)
          m=m+5
        case('quad','mdlq','rect')
          m=4
          nps(1:m)=Norder(1:m)
          call decod(Norder(5),MODORDER,2, nordF)
          nps(m+1)=nordF(1)
          nps(m+2)=nordF(2)
          m=m+2
        case('tria','mdlt')
          m=4
          nps(1:m)=Norder(1:m)
        case('segm')
          m=1
          nps(1:m)=Norder(1:m)
        end select
c    ...print this when debugging
        if (iprint.ge.1) then
          write(*,7006) Type,Dtype
 7006     format('checkorder: Type, Dtype = ',1A6,2x,1A6)
          write(*,7007) nps(1:m)
 7007     format('checkorder: nps = ',27i2)
        endif
c    ...Find the values of minp and maxp inside nps.
        minp=minval(nps(1:m))
        maxp=maxval(nps(1:m))
c    ...Determine if minp and maxp are within the bounds.
c       Otherwise stop the code as order is too low or too high.
        if (minp.lt.1) then
          write(*,7001) minp
          write(*,7002)
 7001     format('checkorder: Polynomial order = ',i3,' is less than 1')
 7002     format('            Order must be at least 1')
c        stop 1
        else if (maxp.gt.MaxOrd) then
          write(*,7003,advance="no") maxp
          write(*,7004) MaxOrd
          write(*,7005) MaxOrd
 7003     format('checkorder: Polynomial order = ',i3)
 7004     format(                        ' is more than MaxOrd = ',i3)
 7005     format('            Order must be at most MaxOrd = ',i3)
c        stop 1
        endif
      endif
c
c  ...The sizing of the arrays is based on the value of maxp and is 
c     dependent on element type and discretization type (H1,Hcurl,...).
c     Compare these values with module parameters.
      Nsize(1)=maxp
      select case(Type)
      case('bric','mdlb')
        select case(Dtype)
        case('contin');Nsize(2)=(maxp+1)**3
        case('tangen');Nsize(2)=3*maxp*(maxp+1)**2
        case('normal');Nsize(2)=3*maxp**2*(maxp+1)
        case('discon');Nsize(2)=maxp**3
        end select
      case('tetr','mdln')
        select case(Dtype)
        case('contin');Nsize(2)=(maxp+1)*(maxp+2)*(maxp+3)/6
        case('tangen');Nsize(2)=maxp*(maxp+2)*(maxp+3)/2
        case('normal');Nsize(2)=maxp*(maxp+1)*(maxp+3)/2
        case('discon');Nsize(2)=maxp*(maxp+1)*(maxp+2)/6
        end select
      case('pris','mdlp')
        select case(Dtype)
        case('contin');Nsize(2)=(maxp+1)*(maxp+2)*(maxp+1)/2
        case('tangen');Nsize(2)=maxp*(maxp+2)*(maxp+1)
     .                          +(maxp+1)*(maxp+2)*maxp/2
        case('normal');Nsize(2)=maxp*(maxp+2)*maxp
     .                          +maxp*(maxp+1)*(maxp+1)/2
        case('discon');Nsize(2)=maxp*(maxp+1)*maxp/2
        end select
      case('pyra','mdld')
        select case(Dtype)
        case('contin');Nsize(2)=5+8*(maxp-1)+(maxp-1)**2
     .                          +2*(maxp-2)*(maxp-1)+(maxp-1)**3
        case('tangen');Nsize(2)=8*maxp+2*maxp*(maxp-1)
     .                          +4*maxp*(maxp-1)+3*(maxp-1)**2*maxp
        case('normal');Nsize(2)=maxp**2+2*maxp*(maxp+1)
     .                          +3*(maxp-1)*maxp**2
        case('discon');Nsize(2)=maxp**3
        end select
      case('quad','mdlq','rect')
        select case(Dtype)
        case('contin');         Nsize(2)=(maxp+1)**2
        case('tangen','normal');Nsize(2)=2*maxp*(maxp+1)
        case('discon');         Nsize(2)=maxp**2
        end select
      case('tria','mdlt')
        select case(Dtype)
        case('contin');         Nsize(2)=(maxp+1)*(maxp+2)/2
        case('tangen','normal');Nsize(2)=maxp*(maxp+2)
        case('discon');         Nsize(2)=maxp*(maxp+1)/2
        end select
      case('segm')
        select case(Dtype)
        case('contin');                  Nsize(2)=maxp+1
        case('tangen','normal','discon');Nsize(2)=maxp
        end select
      end select
c
c  ...print this when debugging
      if (iprint.ge.1) then
        write(*,7008) Nsize(1),Nsize(2)
 7008   format('checkorder: Nsize(1:2) = ',i2,i5)
      endif
c
c
      end subroutine checkorder



