function [coords, cT ,nNodes ]=TriMesh(Lx,Ly,Nx,NE)
    if mod((NE/Nx),2)~=0
        errordlg('divisions on X axis must divide No of Elements twice')
    end
    Ny=NE/(2*Nx);   %Divisions on y axis
    nNodes =(Nx+1)*(Ny+1);  %No of nodes
    m=1;
    j=1:Nx;
    k=linspace(Nx*2,NE,Ny);
    for i=1:Ny
        cT(m:2:k(i),1)= j;  %node 1 of 1st element
        cT(m+1:2:k(i),1)= j;  %node 1 of 2nd element
        cT(m:2:k(i),2)=j+1; %%node 2 of 1st element
        cT(m+1:2:k(i),2)=j+Nx+2;%node 2 of 2nd element
        cT(m:2:k(i),3)= j+Nx+2;  %node 3 of 1st element
        cT(m+1:2:k(i),3)=j+1+Nx;    %%node 3 of 1st element
        m=k(i)+1;
        j=j+Nx+1;
    end
    ax=linspace(0,Lx,Nx+1); 
    by=linspace(0,Ly,Ny+1); 
    X1=[];
    Y1=[];
    for i1=1:Ny+1
        by1(1:Nx+1)=by(i1);
        X1=[X1 ax];
        Y1=[Y1 by1];
    end
    coords=[X1(:)'; Y1(:)'];   