function [Pr,Ke,fe,Ge,Be,Bhe,fee]= assembly(Pr,ue)

disp('Assembly');
if ((Pr.MType==4 || Pr.MType==3) && (Pr.RefT==1 || Pr.nRef==0))
    [Pr,Ke,fe,Ge,Be,Bhe,fee,KeC,feC]= UniAsmb(Pr,ue);
else
    % Parfor ---------------
    NV=Pr.NV;nQ=Pr.nQ;nVV=Pr.nVV;NU=Pr.NU;NUh=Pr.NUh; ep=(Pr.P-1)+Pr.P;
    conn=Pr.conn; x=Pr.x; En=Pr.En; Etype=Pr.Etype;  P=Pr.P; dP=Pr.dP;
    alph=Pr.alph;    Stype=Pr.Stype;  connMS=Pr.connMS;
    connEg=Pr.connEg; edges=Pr.edges; S=Pr.S; ngp=Pr.ngp; BCdof=Pr.BCdof;
    nel=Pr.nel;  Length=Pr.Length; Height=Pr.Height;   
    % -----------------------
    KeC=zeros(Pr.nel,Pr.NUh^2); feC=zeros(Pr.nel,Pr.NUh); % only trace dofs
    Ge=zeros(Pr.nel,Pr.NV^2); fee=zeros(Pr.nel,Pr.NV);
    Be=zeros(Pr.nel,Pr.NV*Pr.NU); Bhe=zeros(Pr.nel,Pr.NV*Pr.NUh);
    Ke=zeros(Pr.nel,NU*NUh);    fe=zeros(Pr.nel,NU);
    [gp,wg]=lgwt(Pr.ngp,0,1);
    if strcmp(Pr.Etype,'tria');
        ElT=300; ELA=1; mA=[0 1 0;0 0 1; 1 1 1];   % affine coordinates
    elseif strcmp(Pr.Etype,'quad');
        ElT=400; ELA=101; mA=[0 1 1 0;0 0 1 1; 1 1 1 1]; 
    end
    for i=1:nel
        B=zeros(NV,NU);  Bh=zeros(NV,NUh);   A=zeros(NV,NV);
        nde=conn(i,:); nde=nde(1:En(i));   Xver=x(:,nde);     f=zeros(NV,1);
        ndeMS=connMS(i,:);  ndeMS(ndeMS==0)=[];  XverMS=x(:,ndeMS);
        mB=zeros(3,ElT/100);
        if strcmp(Etype,'quad');
            % ---------------  Bounding Rectangle
            Xmax=max(Xver(1,:)); Xmin=min(Xver(1,:)); Ymax=max(Xver(2,:)); Ymin=min(Xver(2,:));
            XverR=[Xmin Xmax Xmax Xmin; Ymin Ymin Ymax Ymax];
            mB=[XverR(1,1) XverR(1,2) XverR(1,3) XverR(1,4);XverR(2,1) XverR(2,2) XverR(2,3) XverR(2,4);1 1 1 1];
        elseif strcmp(Etype,'tria');
            % ---------------  Bounding triangle
            if En(i)==3
                XverT=Xver;
            else
                [C] = polygonCentroid(Xver.');   C=C.';
                rC=max(sqrt(sum((Xver-repmat(C,1,En(i))).^2)));
                XverT=[C(1)-sqrt(3)*rC C(2)-rC;C(1)+sqrt(3)*rC C(2)-rC;C(1) C(2)+2*rC].';
            end
            mB=[XverT(1,1) XverT(1,2) XverT(1,3);XverT(2,1) XverT(2,2) XverT(2,3); 1 1 1];
        end
        JM=mB/mA;
        if det(JM)<0; disp('-Negative Jacobian-'); end
        J=JM(1:2,1:2);  detJ=det(JM);
        [x1q,x2q,wq]=polyquadrature(ngp,XverMS.'); % Quadrature
        % ---------------  Element Integrals
        for j=1:length(x1q)
            X=[x1q(j);x2q(j);1];  Xi=JM\X;     Xi=Xi(1:2).';  X=X(1:2).'; % local
            % ---------------  Test/Trial Functions 
            [shapQ]=         Shape(2030+ElT,Xi,P*ELA); shapQ2=kron(shapQ,eye(2));
            [shapHH,gradHH]= Shape(2000+ElT,Xi,(P+dP)*ELA);
            [shapVV,divVV]=  Shape(2020+ElT,Xi,(P+dP)*ELA);
            w= wq(j);
            shapQ=shapQ/detJ;      shapQ2=shapQ2/detJ;      divVV=divVV/detJ;
            gradHH=(J.')\gradHH;   shapVV=(J/detJ)*shapVV; % Piola
            % ---------------  GRAM
            % alpha * (t,t)
            A(1:nVV,1:nVV)=A(1:nVV,1:nVV)+ (shapVV'*shapVV) * ( w * alph);
            % alpha * (v,v)
            A(nVV+1:NV,nVV+1:NV)=A(nVV+1:NV,nVV+1:NV)+ (shapHH'*shapHH)  * ( w * alph);
            % (div_t,div_t)
            A(1:nVV,1:nVV)=A(1:nVV,1:nVV)+ (divVV'*divVV) * (w );
            % (grad_v,grad_v)
            A(nVV+1:NV,nVV+1:NV)=A(nVV+1:NV,nVV+1:NV)+(gradHH'*gradHH) * (w);
            % (t,t)
            A(1:nVV,1:nVV)=A(1:nVV,1:nVV)+(shapVV'*shapVV) * (w);
            % (grad_v,t)
            A(1:nVV,nVV+1:NV)=A(1:nVV,nVV+1:NV)+ (shapVV'*gradHH) * (w);
            % (t,grad_v)
            A(nVV+1:NV,1:nVV)=A(nVV+1:NV,1:nVV)+ (gradHH'*shapVV) * (w);
            % ---------------  Stiffness
            % (u,div_t)
            B(1:nVV,1:nQ)=B(1:nVV,1:nQ)+ (divVV.'*shapQ) * (w );
            % (s,t)
            B(1:nVV,nQ+1:NU)=B(1:nVV,nQ+1:NU)+ (shapVV.'*shapQ2) *(w);
            % (s,grad_v)
            B(nVV+1:NV,nQ+1:NU)=B(nVV+1:NV,nQ+1:NU)+(gradHH.'*shapQ2) * (w);
            % ---------------  RHS
                [fval]=Exact(X,Stype,Length,Height);
                f(nVV+1:NV)= f(nVV+1:NV) +  (shapHH(:)) * (fval*w);
        end
        % ---------------  Boundary Integrals
        for ie=1:En(i)
            edg=connEg(i,ie);                ndeE=edges(edg,:);
            [~,locV]=intersect(nde,ndeE);    locV=locV'; % location of ndE in nde
            locEu=S+(ie-1)*ep+(1:(P-1));     locEs=S+(ie-1)*ep+(P-1)+(1:P);
            % ---------------  Normal
            Nsign=1; %h%
            t=zeros(1,2); t(1)=x(1,ndeE(1))-x(1,ndeE(2)); t(2)=x(2,ndeE(1))-x(2,ndeE(2));
            detJb=sqrt(t(1)^2+t(2)^2);
            Rn(1)=-t(2); Rn(2)=t(1); Rn=Rn/norm(Rn,2);
            c=zeros(1,2); c(1)=(x(1,ndeE(1))+x(1,ndeE(2)))/2;c(2)=(x(2,ndeE(1))+x(2,ndeE(2)))/2;
            c(1)=c(1)+Rn(1)*detJb*1e-5; c(2)=c(2)+Rn(2)*detJb*1e-5;
            if  isPointInPolygon(c, XverMS.');  Rn=-Rn; Nsign=-1;  end
            for j=1:ngp
                % Global
                X(1)= (1-gp(j)) * x(1,edges(edg,1)) + gp(j) * x(1,edges(edg,2));
                X(2)= (1-gp(j)) * x(2,edges(edg,1)) + gp(j) * x(2,edges(edg,2));
                Xi=JM\[X(1:2),1].';   Xi=Xi(1:2).'; % local 
                % ---------------  Test/Trial Functions
                [shapHH,~]=    Shape(2000+ElT,Xi,(P+dP)*ELA);
                [shapVV,~]=    Shape(2020+ElT,Xi,(P+dP)*ELA);
                [shapH1D,~]=  Shape(1101,gp(j),P);
                [shapQ1D]=    Shape(1131,gp(j),P);
                w = wg(j) * detJb;
                shapVV=(J/detJ)*shapVV; shapVV_n=Rn*shapVV; %   Piola
                shapQ1D=shapQ1D/detJb;
                % ---------------  Boundary Stiffness
                %-1 * <u_h,t.n>
                Bh(1:nVV,[locV locEu])=Bh(1:nVV,[locV locEu])+(shapVV_n.'*shapH1D) * (-1 * w ); %h%
                % -1 * <s_h.n,v>
                Bh(nVV+1:NV,locEs)=Bh(nVV+1:NV,locEs)+(shapHH.'*(Nsign*shapQ1D)) * (-1 * w); %h%
            end
        end
        % ---------------  DPG Stiffness
        % diagonal preconditioning
        LA=diag( diag(A).^(-1/2) ); A=LA*A*LA; B=LA*B; Bh=LA*Bh; f=LA*f;
        A = chol(A,'lower');
        Ge(i,:)=reshape(A.',1,[]);   Be(i,:)=reshape(B.',1,[]);
        Bhe(i,:)=reshape(Bh.',1,[]); fee(i,:)=f;
        B=A\B; Bh=A\Bh;   f=A\f;
        Kdpg=[B'*B  B'*Bh; Bh'*B  Bh'*Bh];     Fdpg=[B'*f;Bh'*f];
        Kdpg(abs(Kdpg)<1e-13 * norm(Kdpg,inf))=0; % filter
        Fdpg(abs(Fdpg)<1e-13 * norm(Fdpg,inf))=0; % filter
        % --------------- Condensing trial dofs
        a=(NU+1:NU+NUh); b=(1:NU);            L = chol(Kdpg(b,b),'lower');
        Kc=(L'\(L\Kdpg(b,a)));  fc=(L'\(L\Fdpg(b)));
        Ke(i,:)=reshape(Kc.',1,[]);    fe(i,:)=fc;
        KdpgC=Kdpg(a,a)-Kdpg(a,b)*Kc;  FdpgC=Fdpg(a)-Kdpg(a,b)*fc;
        % --------------  BC (trace dofs)
        bdof=find(BCdof(i,:)>1);
        if bdof
            idof=1:NUh;  idof(bdof)=[];
            UE=ue(i,:);  UE=UE(bdof); % bc of parfor
            FdpgC(idof)=FdpgC(idof)-KdpgC(idof,bdof)*UE.'; % BC lift
            KdpgC(bdof,:)=0; KdpgC(:,bdof)=0;
            for k=1:length(bdof);KdpgC(bdof(k),bdof(k))=1; end
            FdpgC(bdof)=UE.';
        end
        FdpgC(abs(FdpgC)<1e-13 * norm(FdpgC,inf))=0; % filter
        KeC(i,:)=reshape(KdpgC.',1,[]);   feC(i,:)=FdpgC;
    end
end

% ---------------  Assembly 
disp('Making Sparse Matrix');
dofB=Pr.dof;    dofB(dofB==0)=1;
nen=size(Pr.dof,2);                nel=size(Pr.dof,1);
YIndex=repmat(dofB,1,nen);         YIndex=reshape(YIndex',1,[]);
XIndex=repmat(dofB,nen,1);          XIndex=reshape(XIndex',1,[]);
XIndex=reshape(XIndex,[],nen);      XIndex=reshape(XIndex',1,[]);
XIndex=reshape(XIndex,[],nel)';     YIndex=reshape(YIndex,[],nel)';
XIndex=reshape(XIndex,1,[]);        YIndex=reshape(YIndex,1,[]);  KeC=reshape(KeC,1,[]);
Ttip=[YIndex' XIndex' KeC.']; clear YIndex XIndex KeC;
Ttip(abs(Ttip(:,3))<1e-16 * norm(Ttip(:,3),inf),:)=[];   %  filter
XIndex=Ttip(:,2); YIndex=Ttip(:,1);  KeC=Ttip(:,3); clear Ttip;
Pr.f=full(sparse(dofB,1,feC)); clear feC;
Pr.K=sparse(XIndex,YIndex,KeC);
clear  XIndex YInde KeC;