function [Pr,ue]=boundary(Pr)

disp('Boundary Conditions');
ue=zeros(Pr.nel,Pr.NUh);
Pr.BCdof=sign(Pr.dof); % 1:interior 2:dbc 3:nbc
ep=(Pr.P-1)+Pr.P;
gTol=1e-6;              % geometry tolerance
%------------------------------------------------------  Dirichlet BC dofs
NdofDBC= Pr.nDEbc * (  (Pr.P-1) + 1 )   +  2;  % 2 is max added
Pr.dofDBC=zeros(1,NdofDBC);   c=0;
% Vertex dofs on the DBC
for in=1:Pr.numnod
    if ((Pr.DBCtype(1)==1  && abs(Pr.x(2,in)-0)<gTol)         || ...      % bottom
            (Pr.DBCtype(2)==1  && abs(Pr.x(1,in)-Pr.Length)<gTol) || ...  % right
            (Pr.DBCtype(3)==1  && abs(Pr.x(2,in)-Pr.Height)<gTol) || ...  % top
            (Pr.DBCtype(4)==1  && abs(Pr.x(1,in)-0)<gTol)  )              % left
        c=c+1;  Pr.dofDBC(c)=in;
        [i,j]=find(Pr.conn==in);
        [~,U]=Exact(Pr.x(:,in),Pr.Stype,Pr.Length,Pr.Height);
        for k=1:length(i);  Pr.BCdof(i(k),j(k))=2;   ue(i(k),j(k))=U; end
    end
end
% H1 Projection based interpolation
[gp,wg]=lgwt(Pr.ngp,0,1);
% Edge dofs on the DBC
for e=1:size(Pr.edges,1)
    dir=0;
    if (  (Pr.DBCtype(4)==1 && abs(Pr.x(1,Pr.edges(e,1))-0)<gTol  &&  abs(Pr.x(1,Pr.edges(e,2))-0)<gTol) || ...             % left
            (Pr.DBCtype(2)==1 && abs(Pr.x(1,Pr.edges(e,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(e,2))-Pr.Length)<gTol)) % right
        dir=2;
    elseif (  (Pr.DBCtype(1)==1 && abs(Pr.x(2,Pr.edges(e,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(e,2))-0)<gTol) || ...         % bottom
            (Pr.DBCtype(3)==1 && abs(Pr.x(2,Pr.edges(e,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(e,2))-Pr.Height)<gTol)) %top
        dir=1;
    end
    if dir>0
        c=c+(Pr.P-1);
        B=zeros(Pr.P-1,Pr.P-1); g=zeros(Pr.P-1,1);
        Pr.dofDBC(c-(Pr.P-1)+1:c)=Pr.dofEg(e,1:(Pr.P-1));
        [i,ie]=find(Pr.connEg==e); edg=Pr.connEg(i,ie);
        Pr.BCdof(i,Pr.S+(ie-1)*ep+(1:(Pr.P-1)))=2;   % local
        if length(i)>1 ; disp('---------- ERR BC 1 --------'); end
        t=zeros(1,2); t(1)=Pr.x(1,Pr.edges(edg,1))-Pr.x(1,Pr.edges(edg,2)); t(2)=Pr.x(2,Pr.edges(edg,1))-Pr.x(2,Pr.edges(edg,2));
        detJb=sqrt(t(1)^2+t(2)^2); J=detJb;
        for j=1:Pr.ngp
            % Global
            X(1)= (1-gp(j)) * Pr.x(1,Pr.edges(edg,1)) + gp(j) * Pr.x(1,Pr.edges(edg,2));
            X(2)= (1-gp(j)) * Pr.x(2,Pr.edges(edg,1)) + gp(j) * Pr.x(2,Pr.edges(edg,2));
            [~,gradH]=  Shape(1101,gp(j),Pr.P);
            w = wg(j) * detJb;    gradH=(J.')\gradH;
            [~,~,dU]=Exact(X,Pr.Stype,Pr.Length,Pr.Height);  dU=dU(dir);
            %  orientation
            if ( (dir==1 && ( Pr.x(1,Pr.edges(edg,1)) > Pr.x(1,Pr.edges(edg,2)) ) )  || ...
                    (dir==2 && ( Pr.x(2,Pr.edges(edg,1)) > Pr.x(2,Pr.edges(edg,2)) ) )  )
                gradH=-gradH;
            end
            B = B  +  gradH(3:end).'*gradH(3:end) * w;
            locv1=find(Pr.conn(i,:)==Pr.edges(edg,1)); locv2=find(Pr.conn(i,:)==Pr.edges(edg,2));
            g = g  +  gradH(3:end).'*(dU-(gradH(1)*ue(i,locv1)-gradH(2)*ue(i,locv2))) * w;
        end
        ue(i,Pr.S+(ie-1)*ep+(1:(Pr.P-1)))=B\g;
    end
end
if NdofDBC-c>2;disp('--BC Error 2 --');end
Pr.dofDBC=Pr.dofDBC(1:c);
%---------------------------------------------------------  Neumann BC dofs
NdofNBC= Pr.nNEbc * (Pr.P) ;
Pr.dofNBC=zeros(1,NdofNBC);
cn=0;
% Edge dofs on the NBC
for e=1:size(Pr.edges,1)
    dir=0;
    if (  (Pr.NBCtype(4)==1 && abs(Pr.x(1,Pr.edges(e,1))-0)<gTol  &&  abs(Pr.x(1,Pr.edges(e,2))-0)<gTol) || ...                  % left
            (Pr.NBCtype(2)==1 && abs(Pr.x(1,Pr.edges(e,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(e,2))-Pr.Length)<gTol) || ... % right
            (Pr.NBCtype(1)==1 && abs(Pr.x(2,Pr.edges(e,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(e,2))-0)<gTol) || ...                     % bottom
            (Pr.NBCtype(3)==1 && abs(Pr.x(2,Pr.edges(e,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(e,2))-Pr.Height)<gTol))       % top
        dir=1;
    end
    if dir>0
        cn=cn+(Pr.P);
        B=zeros(Pr.P,Pr.P); g=zeros(Pr.P,1);
        Pr.dofNBC(cn-(Pr.P)+1:cn)=Pr.dofEg(e,(Pr.P-1)+1:(Pr.P-1)+Pr.P);
        [i,ie]=find(Pr.connEg==e); edg=Pr.connEg(i,ie);  ndeE=Pr.edges(edg,:);
        Pr.BCdof(i,Pr.S+(ie-1)*ep+(Pr.P-1)+(1:Pr.P))=3; % mark dof (nbc) - local
        nde=Pr.conn(i,1:Pr.En(i));  Xver=Pr.x(:,nde);
        if length(i)>1 ; disp('--BC Error1 -'); end
        t=zeros(1,2); t(1)=Pr.x(1,Pr.edges(edg,1))-Pr.x(1,Pr.edges(edg,2)); t(2)=Pr.x(2,Pr.edges(edg,1))-Pr.x(2,Pr.edges(edg,2));
        detJb=sqrt(t(1)^2+t(2)^2);
        for j=1:Pr.ngp
            % Global
            X(1)= (1-gp(j)) * Pr.x(1,Pr.edges(edg,1)) + gp(j) * Pr.x(1,Pr.edges(edg,2));
            X(2)= (1-gp(j)) * Pr.x(2,Pr.edges(edg,1)) + gp(j) * Pr.x(2,Pr.edges(edg,2));
            [shapQ]=  Shape(1131,gp(j),Pr.P);
            w = wg(j) * detJb;                 shapQ=shapQ/detJb;
            % -----  Normal
            Nsign=1; 
            t=zeros(1,2); t(1)=Pr.x(1,ndeE(1))-Pr.x(1,ndeE(2)); t(2)=Pr.x(2,ndeE(1))-Pr.x(2,ndeE(2));
            detJb=sqrt(t(1)^2+t(2)^2);
            Rn(1)=-t(2); Rn(2)=t(1); Rn=Rn/norm(Rn,2);
            c=zeros(1,2); c(1)=(Pr.x(1,ndeE(1))+Pr.x(1,ndeE(2)))/2;c(2)=(Pr.x(2,ndeE(1))+Pr.x(2,ndeE(2)))/2;
            c(1)=c(1)+.1*Rn(1)*detJb; c(2)=c(2)+.1*Rn(2)*detJb;
            if  isPointInPolygon(c, Xver.');  Rn=-Rn; Nsign=-1;  end
            [~,~,dU]=Exact(X,Pr.Stype,Pr.Length,Pr.Height); Sh_n=dU*Rn.';
            B = B  +  shapQ.'*shapQ * w;
            g = g  +  shapQ.'*(Sh_n*Nsign) * w;
        end
        ue(i,Pr.S+(ie-1)*ep+(Pr.P-1)+(1:Pr.P))=B\g;
    end
end
if NdofNBC~=cn;disp('-- BC Error 3 --');end