function [Pr]=errorcalc(Pr,Ke,fe,ue)

% Parfor ---------------
nQ=Pr.nQ;NU=Pr.NU;NUh=Pr.NUh;   connMS=Pr.connMS;
conn=Pr.conn; x=Pr.x; En=Pr.En; Etype=Pr.Etype;
dof=Pr.dof;  P=Pr.P; ngp=Pr.ngp; Stype=Pr.Stype;
Length=Pr.Length; Height=Pr.Height; nel=Pr.nel;
%-------------------
ErrU=0; ExU=0; ErrS=0; ExS=0;
if strcmp(Pr.Etype,'tria');
    ElT=300; ELA=1;
    mA=[0 1 0;0 0 1; 1 1 1];     % affine
elseif strcmp(Pr.Etype,'quad');
    ElT=400; ELA=101;
    mA=[0 1 1 0;0 0 1 1; 1 1 1 1];  % affine
end
disp('Err Calculation')
for i=1:nel
    nde=conn(i,:); nde=nde(1:En(i));  Xver=x(:,nde);
    ndeMS=connMS(i,:); ndeMS(ndeMS==0)=[]; XverMS=x(:,ndeMS);
    % To recover condensed L2 dofs
    Kc=Ke(i,:);   Kc=reshape(Kc,NUh,NU).'; fc=fe(i,:).';
    a=(NU+1:NU+NUh); b=(1:NU);
    Udpg=zeros(NU+NUh,1);
    [~,loc]=find(dof(i,:)~=0);
    UE=ue(i,:); Udpg(a(loc))=UE(loc);
    Udpg(b)=fc-Kc(:,loc)*Udpg(a(loc));
    mB=zeros(3,ElT/100);
    if strcmp(Etype,'quad');
        % ---------------  Bounding Rectangle
        Xmax=max(Xver(1,:)); Xmin=min(Xver(1,:)); Ymax=max(Xver(2,:)); Ymin=min(Xver(2,:));
        XverR=[Xmin Xmax Xmax Xmin; Ymin Ymin Ymax Ymax];
        mB=[XverR(1,1) XverR(1,2) XverR(1,3) XverR(1,4);XverR(2,1) XverR(2,2) XverR(2,3) XverR(2,4);1 1 1 1];
    elseif strcmp(Etype,'tria');
        % ---------------  Bounding triangle
        if En(i)==3
            XverT=Xver;
        else
            [C] = polygonCentroid(Xver.');   C=C.';
            rC=max(sqrt(sum((Xver-repmat(C,1,En(i))).^2)));
            XverT=[C(1)-sqrt(3)*rC C(2)-rC;C(1)+sqrt(3)*rC C(2)-rC;C(1) C(2)+2*rC].';
        end
        mB=[XverT(1,1) XverT(1,2) XverT(1,3);XverT(2,1) XverT(2,2) XverT(2,3); 1 1 1];
    end
    JM=mB/mA;
    if det(JM)<0
        disp('---------negative jacob--------')
    end
    detJ=det(JM);
    [x1q,x2q,wq]=polyquadrature(ngp,XverMS.'); % Quadrature
    % ---------------  Element Integrals
    for j=1:length(x1q)
        X=[x1q(j);x2q(j)];
        Xi=JM\[X;1];     Xi=Xi(1:2).';  % local
        % ---------------  Test/Trial Functions
        [shapQ]=         Shape(2030+ElT,Xi,P*ELA);     shapQ2=kron(shapQ,eye(2));
        w=  wq(j);
        shapQ=shapQ/detJ;      shapQ2=shapQ2/detJ; % Piola
        [~,uex,sex]=Exact(X,Stype,Length,Height);
        ErrU = ErrU + ( shapQ*Udpg(b(1:nQ)) - uex )^2 * w;
        ExU  = ExU  + (uex^2) * w;
        ErrS = ErrS + ( ( shapQ2(1,:)*Udpg(b(nQ+1:NU)) - sex(1) )^2 + ...
            ( shapQ2(2,:)*Udpg(b(nQ+1:NU)) - sex(2) )^2 ) * w;
        
        ExS = ExS +  (sex(1)^2 + sex(2)^2) * w;
    end
end
Pr.Err=sqrt(ErrU+ErrS)/sqrt(ExU+ExS);