function [X,Y,W]=polyquadrature(N,v)
Ntri=size(v,1)-2;
X=zeros(Ntri*N^2,1);
Y=zeros(Ntri*N^2,1);
W=zeros(Ntri*N^2,1);
% ntriang=size(triang,1);
triang=delaunay(v);
q0=0;
q1=0;
for t=1:Ntri
    tria_vert=v(triang(t,:),:);
    q0=(t-1)*N^2+1;
    q1=t*N^2;
    [X(q0:q1),Y(q0:q1),W(q0:q1)]=triquad(N,tria_vert);    
end