function [Pr]=postprocessor(Pr,Ke,fe,ue)

disp('Analysis finished. Plottig trial/trace variables...');
disp('   (plottig "trial" variables is time consuming)');
gp=0:.1:1; ngp=length(gp);                                  % resolution
h2D=20; gap=1e-2;                                           % resolution
if strcmp(Pr.Etype,'tria');
    ElT=300; ELA=1;
    mA=[0 1 0;0 0 1; 1 1 1];     % affine
elseif strcmp(Pr.Etype,'quad');
    ElT=400; ELA=101;
    mA=[0 1 1 0;0 0 1 1; 1 1 1 1];  % affine
end
if (Pr.Ptrial==1)
    XP=zeros(Pr.nel,h2D+1,h2D+1); YP=XP; ZP=XP; ZPSX=XP; ZPSY=XP; ZPSN=XP; %h%
end
if (Pr.Ptrace==1)
    xp=zeros(Pr.nel,Pr.S,ngp); yp=xp; zp=xp; zps=xp;
end
% Parfor ---------------
nQ=Pr.nQ;NU=Pr.NU;NUh=Pr.NUh; P=Pr.P; connEg=Pr.connEg;
conn=Pr.conn; x=Pr.x; En=Pr.En; Etype=Pr.Etype;
dof=Pr.dof;   nel=Pr.nel; connMS=Pr.connMS; S=Pr.S;
Ptrial=Pr.Ptrial; Ptrace=Pr.Ptrace; edges=Pr.edges; 
%----------------------
for i=1:nel
    nde=conn(i,:); nde=nde(1:En(i));  Xver=x(:,nde);
    ndeMS=connMS(i,:); ndeMS(ndeMS==0)=[]; XverMS=x(:,ndeMS);
    % To recover condensed L2 dofs
    Kc=Ke(i,:);   Kc=reshape(Kc,NUh,NU).'; fc=fe(i,:).';
    a=(NU+1:NU+NUh); b=(1:NU);
    Udpg=zeros(NU+NUh,1);
    [~,loc]=find(dof(i,:)~=0);
    UE=ue(i,:); Udpg(a(loc))=UE(loc);
    Udpg(b)=fc-Kc(:,loc)*Udpg(a(loc));
    if (Ptrial==1)
        gpX=min(Xver(1,:)):(max(Xver(1,:))-min(Xver(1,:)))/h2D:max(Xver(1,:)); ngpX=length(gpX);
        gpY=min(Xver(2,:)):(max(Xver(2,:))-min(Xver(2,:)))/h2D:max(Xver(2,:)); ngpY=length(gpY);
        gpX(1)=gpX(1)+gap; gpX(end)=gpX(end)-gap; gpY(1)=gpY(1)+gap; gpY(end)=gpY(end)-gap;
        XPt=zeros(h2D+1,h2D+1); YPt=XPt; ZPt=XPt;  ZPSXt=XPt;  ZPSYt=XPt; ZPSNt=XPt;
        mB=zeros(3,ElT/100);
        if strcmp(Etype,'quad');
            % ---------------  Bounding Rectangle
            Xmax=max(Xver(1,:)); Xmin=min(Xver(1,:)); Ymax=max(Xver(2,:)); Ymin=min(Xver(2,:));
            XverR=[Xmin Xmax Xmax Xmin; Ymin Ymin Ymax Ymax];
            mB=[XverR(1,1) XverR(1,2) XverR(1,3) XverR(1,4);XverR(2,1) XverR(2,2) XverR(2,3) XverR(2,4);1 1 1 1];
        elseif strcmp(Etype,'tria');
            % ---------------  Bounding triangle
            if En(i)==3
                XverT=Xver;
            else
                [C] = polygonCentroid(Xver.');   C=C.';
                rC=max(sqrt(sum((Xver-repmat(C,1,En(i))).^2)));
                XverT=[C(1)-sqrt(3)*rC C(2)-rC;C(1)+sqrt(3)*rC C(2)-rC;C(1) C(2)+2*rC].';
            end
            mB=[XverT(1,1) XverT(1,2) XverT(1,3);XverT(2,1) XverT(2,2) XverT(2,3); 1 1 1];
        end
        JM=mB/mA;
        detJ=det(JM);
        % ---------------  Element Integrals
        for jX=1:ngpX
            for jY=1:ngpY
                X=[gpX(jX),gpY(jY)];
                if  isPointInPolygon(X, Xver.');
                    % local
                    Xi=JM\[X.';1];     Xi=Xi(1:2).';
                    % ---------------  Test/Trial Functions
                    [shapQ]=         Shape(2030+ElT,Xi,P*ELA);     shapQ2=kron(shapQ,eye(2));
                    shapQ=shapQ/detJ;      shapQ2=shapQ2/detJ;
                    XPt(jX,jY)=X(1);
                    YPt(jX,jY)=X(2);
                    ZPt(jX,jY)=shapQ*Udpg(b(1:nQ));
                    ZPSXt(jX,jY)=shapQ2(1,:)*Udpg(b(nQ+1:NU));
                    ZPSYt(jX,jY)=shapQ2(2,:)*Udpg(b(nQ+1:NU));
                else
                    ZPt(jX,jY)=NaN;  ZPSXt(jX,jY)=NaN; ZPSYt(jX,jY)=NaN;  ZPSNt(jX,jY)=NaN;
                end
            end
        end
        XP(i,:,:)=XPt; YP(i,:,:)=YPt; ZP(i,:,:)=ZPt; ZPSX(i,:,:)=ZPSXt;
        ZPSY(i,:,:)=ZPSYt; ZPSN(i,:,:)=ZPSNt;
    end
    
    if (Ptrace==1)
        xpt=zeros(S,ngp); ypt=xpt; zpt=xpt; zpst=xpt;
        % ---------------  Boundary Integrals
        ep=(P-1)+P;
        for ie=1:En(i)
            edg=connEg(i,ie);             ndeE=edges(edg,:);
            [~,locV]=intersect(nde,ndeE);    locV=locV';
            locEu=S+(ie-1)*ep+(1:(P-1));  locEs=S+(ie-1)*ep+(P-1)+(1:P);
            % ---------------  Normal
            Nsign=1; %h%
            t=zeros(1,2); t(1)=x(1,ndeE(1))-x(1,ndeE(2)); t(2)=x(2,ndeE(1))-x(2,ndeE(2));
            detJb=sqrt(t(1)^2+t(2)^2);
            Rn(1)=-t(2); Rn(2)=t(1); Rn=Rn/norm(Rn,2);
            c=zeros(1,2); c(1)=(x(1,ndeE(1))+x(1,ndeE(2)))/2;c(2)=(x(2,ndeE(1))+x(2,ndeE(2)))/2;
            c(1)=c(1)+Rn(1)*detJb*1e-5; c(2)=c(2)+Rn(2)*detJb*1e-5;
            if  isPointInPolygon(c, XverMS.');  Rn=-Rn; Nsign=-1;  end % Global normal
            for j=1:ngp
                % Global
                X(1)= (1-gp(j)) * x(1,edges(edg,1)) + gp(j) * x(1,edges(edg,2));
                X(2)= (1-gp(j)) * x(2,edges(edg,1)) + gp(j) * x(2,edges(edg,2));
                % ---------------  Trial Functions
                [shapH1D,~]=  Shape(1101,gp(j),P);
                [shapQ1D]=    Shape(1131,gp(j),P);
                shapQ1D=shapQ1D/detJb;
                xpt(ie,j)=X(1); ypt(ie,j)=X(2);
                zpt(ie,j)=(shapH1D)*Udpg(a([locV locEu]));
                zpst(ie,j)=(shapQ1D)*Udpg(a(locEs));
            end
        end
        xp(i,:,:)=xpt; yp(i,:,:)=ypt; zp(i,:,:)=zpt; zps(i,:,:)=zpst;
    end
end
Fs=15; % font size
if (Pr.Ptrial==1)
    figure(1);
    for i=1:nel
        surf(squeeze(XP(i,:,:)),squeeze(YP(i,:,:)),squeeze(ZP(i,:,:)),'EdgeColor','none'); hold on
    end
    view([-45 45]);
    xlabel('$x$','Interpreter','Latex','FontSize',Fs);ylabel('$y$','Interpreter','Latex','FontSize',Fs);
    zlabel('$u$','Interpreter','Latex','FontSize',Fs);  set(gca,'color','none')
    set(gcf, 'Units', 'centimeters');set(gcf, 'Position', [5 5 8.5 7.5]); set(gcf, 'PaperPositionMode', 'auto');
    ax = gca; ax.LineWidth = .75;
    figure(3);
    for i=1:nel
        surf(squeeze(XP(i,:,:)),squeeze(YP(i,:,:)),squeeze(ZPSX(i,:,:)),'EdgeColor','none'); hold on
    end
    view([-45 45]);
    xlabel('$x$','Interpreter','Latex','FontSize',Fs);ylabel('$y$','Interpreter','Latex','FontSize',Fs);
    zlabel('$q_x$','Interpreter','Latex','FontSize',Fs);
    set(gca,'color','none')
    ax = gca; ax.LineWidth = .75;
    set(gcf, 'Units', 'centimeters');set(gcf, 'Position', [5 5 8.5 7.5]); set(gcf, 'PaperPositionMode', 'auto');
    figure(5);
    for i=1:nel
        surf(squeeze(XP(i,:,:)),squeeze(YP(i,:,:)),squeeze(ZPSY(i,:,:)),'EdgeColor','none'); hold on
    end
    view([-45 45]);
    xlabel('$x$','Interpreter','Latex','FontSize',Fs);ylabel('$y$','Interpreter','Latex','FontSize',Fs);
    zlabel('$q_y$','Interpreter','Latex','FontSize',Fs);
    set(gca,'color','none')
    ax = gca; ax.LineWidth = .75;
    set(gcf, 'Units', 'centimeters');set(gcf, 'Position', [5 5 8.5 7.5]); set(gcf, 'PaperPositionMode', 'auto');
end
if (Pr.Ptrace==1)
    figure(2);
    for i=1:nel
        for ie=1:En(i)
            plot3(squeeze(xp(i,ie,:)),squeeze(yp(i,ie,:)),squeeze(zp(i,ie,:)),'-b','Linewidth',1); hold on
        end
    end
    xlabel('$x$','Interpreter','Latex','FontSize',Fs);ylabel('$y$','Interpreter','Latex','FontSize',Fs);
    view([-45 45]); zlabel('$$\hat{u}$$','Interpreter','Latex','FontSize',Fs);
    set(gca,'color','none'); grid on
    ax = gca; ax.LineWidth = .75;
    set(gcf, 'Units', 'centimeters');set(gcf, 'Position', [5 5 8.5 7.5]); set(gcf, 'PaperPositionMode', 'auto');
    figure(4);
    for i=1:nel
        for ie=1:Pr.En(i)
            plot3(squeeze(xp(i,ie,:)),squeeze(yp(i,ie,:)),squeeze(zps(i,ie,:)),'-b','Linewidth',1); hold on
        end
    end
    xlabel('$x$','Interpreter','Latex','FontSize',Fs);ylabel('$y$','Interpreter','Latex','FontSize',Fs);
    view([-45 45]);  zlabel('$$\hat{q.n_{global}}$$','Interpreter','Latex','FontSize',Fs)
    set(gca,'color','none'); grid on
    ax = gca; ax.LineWidth = .75;
    set(gcf, 'Units', 'centimeters');set(gcf, 'Position', [5 5 8.5 7.5]); set(gcf, 'PaperPositionMode', 'auto');
end