function [Pr]=preprocessor(Pr)

% -------------------------------------------------------------------------
Pr.NBCtype=1-Pr.DBCtype;       % NBC: [bottom right top left]
if Pr.MType==4
    Pr.Etype   ='quad';        % Bounding elem 'quad' - 'tria'
else
    Pr.Etype   ='tria';        % Bounding elem  'quad' - 'tria'
end
Pr.ngp     = 2*(Pr.dP+Pr.P)+1; % number of Gauss points
% Triangular Mesh ---------------------------------------------------------
if Pr.MType==3
    Pr.S=3;
    [Pr.x, Pr.conn ,Pr.numnod ]=TriMesh(...
        Pr.Length,Pr.Height,Pr.nelx,(2*Pr.nelx*Pr.nely));
    Pr.nel=size(Pr.conn,1);  Pr.En=zeros(Pr.nel,1)+3;
    Pr.nDEbc=(Pr.nelx*(Pr.DBCtype(1)+Pr.DBCtype(3))+Pr.nely*(Pr.DBCtype(2)+Pr.DBCtype(4)));
    Pr.nNEbc=(Pr.nelx*(Pr.NBCtype(1)+Pr.NBCtype(3))+Pr.nely*(Pr.NBCtype(2)+Pr.NBCtype(4)));
    Pr.edges=zeros(Pr.nel*3,2);  Pr.connEg=zeros(Pr.nel,3);
    for i=1:Pr.nel
        Pr.edges((i-1)*3+1,:)=sort([Pr.conn(i,1) Pr.conn(i,2)]);
        Pr.edges((i-1)*3+2,:)=sort([Pr.conn(i,2) Pr.conn(i,3)]);
        Pr.edges((i-1)*3+3,:)=sort([Pr.conn(i,3) Pr.conn(i,1)]);
        Pr.connEg(i,1:3)=((i-1)*3+1:(i-1)*3+3);
    end
    [Pr.edges,~,iU] = unique(Pr.edges,'rows');
    Pr.connEg=Pr.connEg(:);Pr.connEg=iU(Pr.connEg);
    Pr.connEg=reshape(Pr.connEg,Pr.nel,3);
% Quadrilateral Mesh ------------------------------------------------------
elseif (Pr.MType==4 || Pr.MType==41)
    Pr.S=4;
    Pr.numnod=(Pr.nelx+1)*(Pr.nely+1);
    Pr.conn=QuadMesh(Pr.nelx,Pr.nely); Pr.conn=Pr.conn';
    Pr.nel=size(Pr.conn,1); Pr.En=zeros(Pr.nel,1)+4;
    Pr.x=zeros(2,Pr.numnod);dx=Pr.Length/(Pr.nelx*2);dy=Pr.Height/(Pr.nely*2);
    Pr.nDEbc=(Pr.nelx*(Pr.DBCtype(1)+Pr.DBCtype(3))+Pr.nely*(Pr.DBCtype(2)+Pr.DBCtype(4)));
    Pr.nNEbc=(Pr.nelx*(Pr.NBCtype(1)+Pr.NBCtype(3))+Pr.nely*(Pr.NBCtype(2)+Pr.NBCtype(4)));
    e=0;
    for i=1:Pr.nely
        for j=1:Pr.nelx
            e=e+1;
            cenx=(j-1)*(2*dx)+dx;
            ceny=(i-1)*(2*dy)+dy;
            Pr.x(:,Pr.conn(e,1))=[cenx-dx;ceny-dy];   Pr.x(:,Pr.conn(e,2))=[cenx+dx;ceny-dy];
            Pr.x(:,Pr.conn(e,3))=[cenx+dx;ceny+dy];   Pr.x(:,Pr.conn(e,4))=[cenx-dx;ceny+dy];
        end
    end
    Pr.edges=zeros(Pr.nel*4,2);  Pr.connEg=zeros(Pr.nel,4);
    for i=1:Pr.nel
        Pr.edges((i-1)*4+1,:)=sort([Pr.conn(i,1) Pr.conn(i,2)]);
        Pr.edges((i-1)*4+2,:)=sort([Pr.conn(i,2) Pr.conn(i,3)]);
        Pr.edges((i-1)*4+3,:)=sort([Pr.conn(i,3) Pr.conn(i,4)]);
        Pr.edges((i-1)*4+4,:)=sort([Pr.conn(i,4) Pr.conn(i,1)]);
        Pr.connEg(i,1:4)=((i-1)*4+1:(i-1)*4+4);
    end
    [Pr.edges,~,iU] = unique(Pr.edges,'rows');
    Pr.connEg=Pr.connEg(:);Pr.connEg=iU(Pr.connEg);
    Pr.connEg=reshape(Pr.connEg,Pr.nel,4);
elseif (Pr.MType==5)
    load PM PM;
    if Pr.nelx==2 
        Pr.x=PM.x2; Element=PM.e2;
    elseif Pr.nelx==4
        Pr.x=PM.x4; Element=PM.e4;
    elseif Pr.nelx==8
        Pr.x=PM.x8; Element=PM.e8;
    elseif Pr.nelx==16 
        Pr.x=PM.x16; Element=PM.e16;
    end
    for i=1:size(Element,1)
        if i==1
            Pr.conn=zeros(size(Element,1),4);
        end
        E=Element{i,1};
        Pr.conn(i,1:length(E))=E;
    end
    Pr.S=size(Pr.conn,2);
    Pr.numnod=max(max(Pr.conn));
    Pr.nel=size(Pr.conn,1);
    Pr.En=zeros(Pr.nel,1);
    for i=1:Pr.nel
        [~,loc]=find(Pr.conn(i,:)~=0);  Pr.En(i)=length(loc);
    end
    Pr.edges=zeros(Pr.nel*Pr.S,2);
    for i=1:Pr.nel
        for j=1:Pr.En(i)
            if j<Pr.En(i)
                Pr.edges((i-1)*Pr.S+j,:)=sort(Pr.conn(i,[j j+1]));
            else
                Pr.edges((i-1)*Pr.S+j,:)=sort(Pr.conn(i,[j 1]));
            end
        end
    end
    [Pr.edges] = unique(Pr.edges,'rows');
    if Pr.edges(1)==0; Pr.edges(1,:)=[];end
    Pr.connEg=zeros(Pr.nel,Pr.S);
    for i=1:Pr.nel
        for j=1:Pr.En(i)
            if j<Pr.En(i)
                t=sort(Pr.conn(i,j:j+1));
            else
                t=sort(Pr.conn(i,[j,1]));
            end
            Pr.connEg(i,j)=find(ismember(Pr.edges,t,'rows'),1);
        end
    end
end
if (Pr.MType==5)
    gTol=1e-6;   % Boundary node coordinate correction
    for i=1:Pr.numnod
        if abs(Pr.x(1,i)-0)<gTol; Pr.x(1,i)=0;end
        if  abs(Pr.x(1,i)-Pr.Length)<gTol; Pr.x(1,i)=Pr.Length;end
        if abs(Pr.x(2,i)-0)<gTol; Pr.x(2,i)=0;end
        if abs(Pr.x(2,i)-Pr.Height)<gTol; Pr.x(2,i)=Pr.Height;end
    end
    cd=0; cn=0;
    for i=1:size(Pr.edges,1)
        if (  (Pr.DBCtype(4)==1 && abs(Pr.x(1,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-0)<gTol) || ...                    % left
                (Pr.DBCtype(2)==1 && abs(Pr.x(1,Pr.edges(i,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-Pr.Length)<gTol) || ...) % right
                (Pr.DBCtype(1)==1 && abs(Pr.x(2,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-0)<gTol) || ...                  % bottom
                (Pr.DBCtype(3)==1 && abs(Pr.x(2,Pr.edges(i,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-Pr.Height)<gTol))        %top
            cd=cd+1;
        end
        if (  (Pr.NBCtype(4)==1 && abs(Pr.x(1,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-0)<gTol) || ...                    % left
                (Pr.NBCtype(2)==1 && abs(Pr.x(1,Pr.edges(i,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-Pr.Length)<gTol) || ...) % right
                (Pr.NBCtype(1)==1 && abs(Pr.x(2,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-0)<gTol) || ...                  % bottom
                (Pr.NBCtype(3)==1 && abs(Pr.x(2,Pr.edges(i,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-Pr.Height)<gTol))        %top
            cn=cn+1;
        end
    end
    Pr.nDEbc=cd;
    Pr.nNEbc=cn;
end
% dof connectivity  -------------------------------------------------------
Pr.dof=zeros(Pr.nel,Pr.S*(1+(Pr.P-1)+Pr.P));
ep=(Pr.P-1)+Pr.P;
for i=1:Pr.nel
    Pr.dof(i,1:Pr.S)=Pr.conn(i,1:Pr.S);
    for j=1:Pr.En(i)
        Pr.dof(i,Pr.S+1+(j-1)*ep:Pr.S+j*ep)=((Pr.connEg(i,j)-1)*ep+1:(Pr.connEg(i,j))*ep)+ Pr.numnod;
    end
end
Pr.dofEg=zeros(size(Pr.edges,1),ep);
for i=1:size(Pr.edges,1)
    Pr.dofEg(i,1:ep)=((i-1)*ep+1:i*ep)+ Pr.numnod;
end
% 0:H1, 2:Hdiv, 3: L2
% 2D test-trial
if strcmp(Pr.Etype,'tria'); ElT=300; ELA=1; elseif strcmp(Pr.Etype,'quad'); ElT=400; ELA=101; end
[shapQ]=    Shape(2030+ElT,[0 0], Pr.P*ELA);                        Pr.nQ=length(shapQ);
[shapHH,~]= Shape(2000+ElT,[0 0],(Pr.P+Pr.dP)*ELA);                 Pr.nHH=length(shapHH);
[shapVV,~]= Shape(2020+ElT,[0 0],(Pr.P+Pr.dP)*ELA);                 Pr.nVV=length(shapVV);
% 1D trace
[shapH,~]=  Shape(1101,0,Pr.P);                             Pr.nH=length(shapH);
[shapV]=    Shape(1131,0,Pr.P);                             Pr.nV=length(shapV);
% Polygon with Pr.S sides
Pr.NU= Pr.nQ+2*Pr.nQ;  Pr.NUh=Pr.S*(1+(Pr.nH-2)+Pr.nV);     Pr.NV=Pr.nHH+Pr.nVV;
% Check  test dof > trial dof
Pr.dPv=zeros(Pr.nel,1)+Pr.dP;    Tv=zeros(Pr.nel,1)+Pr.NV;
for i=1:Pr.nel
    tc=0;
    while tc==0
        tc=1;
        if (  (Pr.nQ+2*Pr.nQ )  +  (Pr.En(i)*(1+(Pr.nH-2)+Pr.nV))   ) > Tv(i)
            Pr.dPv(i)=Pr.dPv(i)+1;
            [shapHH,~]= Shape(2000+ElT,[0 0],(Pr.P+Pr.dPv(i))); [shapVV,~]= Shape(2020+ElT,[0 0],(Pr.P+Pr.dPv(i)));
            Tv(i)=length(shapHH)+length(shapVV);
            tc=0;
        end
    end
end
if max(Pr.dPv)>Pr.dP;
    disp(['--- dP is raised globally to dP=' num2str(max(Pr.dPv)) ' ---']);
    Pr.dP=max(Pr.dPv);
    [shapHH,~]= Shape(2000+ElT,[0 0],(Pr.P+Pr.dP));    Pr.nHH=length(shapHH);
    [shapVV,~]= Shape(2020+ElT,[0 0],(Pr.P+Pr.dP));    Pr.nVV=length(shapVV);
    Pr.NV=Pr.nHH+Pr.nVV;
end
if max(Pr.P+Pr.dPv(i))>21 ; disp('Pr.P +Pr.dP should be less than 21'); pause; end
Pr.connMS=Pr.conn;    % Adaptive mesh master nodes