function [Pr]=refine(Pr)

disp('Refinement')
Pr.rfn=zeros(Pr.nel,1);
list=find(Pr.res>Pr.AdpFac*max(Pr.res))';
cNd=max(max(Pr.conn));  cEd=size(Pr.edges,1); cEl=size(Pr.conn,1);
for i=list
    % add the centroid node --------
    ndeM=Pr.connMS(i,:);             ndeM(ndeM==0)=[];
    ndeOM= polysort(Pr.x(:,ndeM));   ndeM=ndeM(ndeOM); % cc-wise
    Xver=Pr.x(:,ndeM);
    [C] = polygonCentroid(Xver.');    C=C.';
    cNd=cNd+1;          CNode=cNd;    Pr.x(:,cNd)=C;
    % add mid-edge nodes and centroid edges ------
    nde=Pr.conn(i,:);    nde(nde==0)=[];
    ndeO= polysort(Pr.x(:,nde));   nde=nde(ndeO); % cc-wise
    edgAdd=zeros(1,2*length(ndeM));  ndeAdd=zeros(1,length(ndeM));
    ndeMc=[ndeM ndeM(1)]; % circular nodes
    inN=0; inE=0;          % index for new nodes edges
    for j=1:length(ndeM)
        % -------  determine broken edge or not
        Cnt=(Pr.x(:,ndeMc(j))+Pr.x(:,ndeMc(j+1)))/2;
        ni=0;
        for k=1:length(nde)
            if norm(Cnt-Pr.x(:,nde(k)))<1e-5
                ni=nde(k);
            end
        end
        % -- if not broken
        if ni==0
            % add middle node on edge
            cNd=cNd+1; Pr.x(:,cNd)=Cnt;
            inN=inN+1; ndeAdd(inN)=cNd;
            % add middle node to the neighbor elements
            ln=find(sum(ismember(Pr.conn,[ndeMc(j) ndeMc(j+1)]),2)==2);  lnc= (ln~=i);  ln=ln(lnc); % find neig
            nnd=Pr.conn(ln,:); nnd(nnd==0)=[]; nnd=[nnd cNd];    nndA= polysort(Pr.x(:,nnd)); nnd=nnd(nndA);
            nD=length(nnd);   Pr.conn(ln,1:nD)=nnd;  Pr.conn(ln,nD+1:end)=0;   Pr.En(ln)=nD;
            % add new edge from centroid to edge
            cEd=cEd+1; Pr.edges(cEd,:) = [min(CNode,cNd) max(CNode,cNd)];
            inE=inE+1; edgAdd(inE)=cEd;
            % add new edge on the side edge
            cEd=cEd+1;  Pr.edges(cEd,:) = [min(ndeMc(j),cNd) max(ndeMc(j),cNd)];
            inE=inE+1;  edgAdd(inE)=cEd;
            % update the edge on the side edge
            Pr.edges(ismember(Pr.edges,[min(ndeMc(j),ndeMc(j+1)) ...
                max(ndeMc(j),ndeMc(j+1))],'rows'),:)= [min(ndeMc(j+1),cNd) max(ndeMc(j+1),cNd)];
        else
            % add new edge
            cEd=cEd+1; Pr.edges(cEd,:)=[min(CNode,ni) max(CNode,ni)];
            inE=inE+1; edgAdd(inE)=cEd;
            inN=inN+1; ndeAdd(inN)=ni;
        end
    end
    % add new elements  ----
    ndeAdd(ndeAdd==0)=[];
    ndeAll=[ndeM ndeAdd];  NordA= polysort(Pr.x(:,ndeAll));
    ndeAll=ndeAll(NordA); ndeAllc=[ndeAll ndeAll];% All nodes
    NordA= polysort(Pr.x(:,ndeAdd)); ndeAdd=ndeAdd(NordA); ndeAddc=[ndeAdd ndeAdd(1)];
    for j=1:length(ndeM)
        if j==1; eln=i; else cEl=cEl+1; eln=cEl; end
        n1=ndeAddc(j); n2=ndeAddc(j+1);
        l1=find(ndeAllc==n1);  l1=l1(1);
        l2=find(ndeAllc==n2);  if l2>l1;  l2=l2(1); else l2=l2(2); end
        %%%%%%%%  check   for middle nodes for new elements
        MSnde=[CNode ndeAllc([l1:l2])];
        ndeM= polysort(Pr.x(:,MSnde)); MSnde=MSnde(ndeM);
        MSndeC=[MSnde MSnde(1)];
        for jj=1:length(MSnde)
            CntM=(Pr.x(:,MSndeC(jj))+Pr.x(:,MSndeC(jj+1)))/2;
            diff=abs(Pr.x(1,:)-CntM(1))+abs(Pr.x(2,:)-CntM(2));
            lMc=find(diff<1e-5);
            if lMc
                MSnde=[MSnde lMc];
            end
        end
        ndeM= polysort(Pr.x(:,MSnde)); MSnde=MSnde(ndeM);
        nE=length(MSnde); Pr.conn(eln,1:nE)=MSnde;  Pr.conn(eln,nE+1:end)=0;
        nEm=length([CNode ndeAllc([l1:l2])]);
        Pr.connMS(eln,1:nEm)=[CNode ndeAllc([l1:l2])];  Pr.connMS(eln,nEm+1:end)=0; % m
        Pr.En(eln)=nE;
    end
end
%  ---  update connectivity and dof
Pr.conn( :, all( ~any( Pr.conn ), 1 ) ) = []; % remove zero columns
Pr.nel=size(Pr.conn,1);
for i=1:size(Pr.conn,1)
    nde=Pr.conn(i,:);nde(nde==0)=[];  ndeA= polysort(Pr.x(:,nde));
    nde=nde(ndeA);
    Pr.conn(i,1:length(nde))=nde;     Pr.En(i)=length(nde);
end
for i=1:size(Pr.edges,1)
    if Pr.edges(i,1)>Pr.edges(i,2)
Pr.edges(i,:)=fliplr(Pr.edges(i,:));
    end
end
Pr.connEg=zeros(Pr.nel,Pr.S);
for i=1:Pr.nel
    tc=0;
    while tc==0
        tc=1;
        for j=1:Pr.En(i)
            if j<Pr.En(i)
                t=sort(Pr.conn(i,j:j+1));
            else
                t=sort(Pr.conn(i,[j,1]));
            end
            tl=find(ismember(Pr.edges,t,'rows'),1);
            if tl
                Pr.connEg(i,j)=tl;
            else
                nde=Pr.conn(i,:);nde(nde==0)=[];  ndeA= polysort(Pr.x(:,nde));
                nde=nde(ndeA);
                %%%%%%%%%%%%  check for any missing (hanging) node
                ndeC=[nde nde(1)];
                for jj=1:length(nde)
                    CntM=(Pr.x(:,ndeC(jj))+Pr.x(:,ndeC(jj+1)))/2;
                    diff=abs(Pr.x(1,:)-CntM(1))+abs(Pr.x(2,:)-CntM(2));
                    lMc=find(diff<1e-6);
                    if lMc
                        nde=[nde lMc];
                    end
                end
                ndeM= polysort(Pr.x(:,nde));      nde=nde(ndeM);
                Pr.conn(i,1:length(nde))=nde;     Pr.En(i)=length(nde);
                if size(Pr.conn,2)>Pr.connEg; Pr.connEg(end,size(Pr.conn,2))=0;end % increase size
                tc=0;  Pr.connEg(i,:)=0;  break
            end
        end
   end
end

Pr.S=size(Pr.conn,2); Pr.numnod=max(max(Pr.conn)); 
%%% BC nodes correction
gTol=1e-6;
for i=1:Pr.numnod
    if abs(Pr.x(1,i)-0)<gTol; Pr.x(1,i)=0;end
    if  abs(Pr.x(1,i)-Pr.Length)<gTol; Pr.x(1,i)=Pr.Length;end
    if abs(Pr.x(2,i)-0)<gTol; Pr.x(2,i)=0;end
    if abs(Pr.x(2,i)-Pr.Height)<gTol; Pr.x(2,i)=Pr.Height;end
end
cd=0; cn=0;
for i=1:size(Pr.edges,1)
    if (  (Pr.DBCtype(4)==1 && abs(Pr.x(1,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-0)<gTol) || ...                    % left
            (Pr.DBCtype(2)==1 && abs(Pr.x(1,Pr.edges(i,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-Pr.Length)<gTol) || ...) % right
            (Pr.DBCtype(1)==1 && abs(Pr.x(2,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-0)<gTol) || ...                  % bottom
            (Pr.DBCtype(3)==1 && abs(Pr.x(2,Pr.edges(i,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-Pr.Height)<gTol))        %top
        cd=cd+1;
    end
    if (  (Pr.NBCtype(4)==1 && abs(Pr.x(1,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-0)<gTol) || ...                    % left
            (Pr.NBCtype(2)==1 && abs(Pr.x(1,Pr.edges(i,1))-Pr.Length)<gTol &&  abs(Pr.x(1,Pr.edges(i,2))-Pr.Length)<gTol) || ...) % right
            (Pr.NBCtype(1)==1 && abs(Pr.x(2,Pr.edges(i,1))-0)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-0)<gTol) || ...                  % bottom
            (Pr.NBCtype(3)==1 && abs(Pr.x(2,Pr.edges(i,1))-Pr.Height)<gTol &&  abs(Pr.x(2,Pr.edges(i,2))-Pr.Height)<gTol))        %top
        cn=cn+1;
    end
end
Pr.nDEbc=cd;
Pr.nNEbc=cn;
Pr.dof=zeros(Pr.nel,Pr.S*(1+(Pr.P-1)+Pr.P));
ep=(Pr.P-1)+Pr.P;
for i=1:Pr.nel
    Pr.dof(i,1:Pr.S)=Pr.conn(i,1:Pr.S);
    for j=1:Pr.En(i)
        Pr.dof(i,Pr.S+1+(j-1)*ep:Pr.S+j*ep)=((Pr.connEg(i,j)-1)*ep+1:(Pr.connEg(i,j))*ep)+ Pr.numnod;
    end
end
Pr.dofEg=zeros(size(Pr.edges,1),ep);
for i=1:size(Pr.edges,1)
    Pr.dofEg(i,1:ep)=((i-1)*ep+1:i*ep)+ Pr.numnod;
end
Pr.NU= Pr.nQ+2*Pr.nQ;  Pr.NUh=Pr.S*(1+(Pr.nH-2)+Pr.nV);     Pr.NV=Pr.nHH+Pr.nVV;
